#!/usr/bin/perl
use CGI;
$query = new CGI;


#----------------------------------#
#  2. Print the doctype statement  #
#----------------------------------#

print $query->header;


#----------------------------------------------------#
#  3. Start the HTML doc, and give the page a title  #
#----------------------------------------------------#

print $query->start_html('My scrolling_list.cgi program');


#------------------------------------------------------------#
#  4a.  If the program is called without any params, print   #
#       the scrolling_list form.                             #
#------------------------------------------------------------#

if (!$query->param) {

	print $query->startform;
	print $query->h3('Select your favorite programming language(s):');
	print $query->scrolling_list(-name=>'languages',
				 -values=>[
					   'Basic',
					   'C',
					   'C++',
					   'Cobol',
					   'DHTML',
					   'Fortran',
					   'HTML',
					   'Korn Shell (Unix)',
					   'Perl',
					   'Java',
					   'JavaScript',
					   'Python',
					   'Tcl/Tk',
					   'Visual Basic'],
				 -size=>8,
				 -multiple=>'true',
				 -default=>'Perl');

	# Notes:
	# ------
	#	"-multiple=>'true'" lets the user make multiple selections
	#		from the scrolling_list
	#	"-default" is optional
	#	"-size" lets you specify the number of visible rows in the list
	#	can also use an optional "-labels" parameter to let the user
	#		see labels you want them to see, while you use
	#		different names for each parameter in your program
	
	print $query->br;
	print $query->submit(-value=>'Submit your favorite language(s)');
	print $query->endform;

} else {

	#----------------------------------------------------------#
	#  4b.  If the program is called with parameters, retrieve #
	#  the 'languages' parameter, assign it to an array        #
	#  named $languages, then print the array with each        #
	#  name separated by a <BR> tag.                           #
	#----------------------------------------------------------#

	print $query->h3('Your favorite languages are:');
	@languages = $query->param('languages');
	print "<BLOCKQUOTE>\n";
	foreach $language (@languages) {
		print "$language<BR>";
	}
	print "</BLOCKQUOTE>\n";

}


#--------------------------------------------------#
#  5. After either case above, end the HTML page.  #
#--------------------------------------------------#

print $query->end_html;

