--
-- Selected TOC Entries:
--
\connect - israeld

--
-- TOC Entry ID 16 (OID 3045857)
--
-- Name: Bitacora Type: TABLE Owner: israeld
--

CREATE TABLE "Bitacora" (
	"Identificador" integer,
	"fecha" character varying(30),
	"hora" character varying(20),
	"IP" character varying(20)
);

--
-- TOC Entry ID 2 (OID 3235330)
--
-- Name: apdopost_apdo_id_seq Type: SEQUENCE Owner: israeld
--

CREATE SEQUENCE "apdopost_apdo_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 17 (OID 3235332)
--
-- Name: apdopost Type: TABLE Owner: israeld
--

CREATE TABLE "apdopost" (
	"apdo_id" integer DEFAULT nextval('"apdopost_apdo_id_seq"'::text) NOT NULL,
	"cod_post" character varying(100),
	"ciudad" character varying(20),
	"pais" character varying(20),
	"localidad" character varying(50),
	"municipio" character varying(50),
	"apdo_post" character varying(75),
	Constraint "apdopost_pkey" Primary Key ("apdo_id")
);

--
-- TOC Entry ID 4 (OID 3235335)
--
-- Name: datosdepen_dep_id_seq Type: SEQUENCE Owner: israeld
--

CREATE SEQUENCE "datosdepen_dep_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 18 (OID 3235337)
--
-- Name: datosdepen Type: TABLE Owner: israeld
--

CREATE TABLE "datosdepen" (
	"dep_id" integer DEFAULT nextval('"datosdepen_dep_id_seq"'::text) NOT NULL,
	"nom_int" character varying(100) NOT NULL,
	"siglas_inst" character varying(20),
	"nom_depen" character varying(200),
	"siglas_depen" character varying(10),
	"nom_subdepen" character(150),
	"ano_fundacion" character varying(50),
	"pag_web" character varying(100),
	"observaciones" character varying(1000),
	"dep_obs" character varying(1000),
	"objetivo" character varying(1000),
	"semaforo" character varying(100),
	Constraint "datosdepen_pkey" Primary Key ("dep_id")
);

--
-- TOC Entry ID 6 (OID 3235343)
--
-- Name: datosubdep_subdep_id_seq Type: SEQUENCE Owner: israeld
--

CREATE SEQUENCE "datosubdep_subdep_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 19 (OID 3235345)
--
-- Name: datosubdep Type: TABLE Owner: israeld
--

CREATE TABLE "datosubdep" (
	"subdep_id" integer DEFAULT nextval('"datosubdep_subdep_id_seq"'::text) NOT NULL,
	"dep_id" integer NOT NULL,
	"nom_subdepen" character varying(200),
	"subdepen_siglas" character varying(10),
	"subdepen_ano_fundacion" numeric(4,0),
	"subdepen_pag_web" character varying(100),
	"observaciones" character varying(1000),
	"subdepen_obs" character varying(1000),
	Constraint "datosubdep_pkey" Primary Key ("subdep_id", "dep_id")
);

--
-- TOC Entry ID 8 (OID 3235351)
--
-- Name: datosbiblio_bib_id_seq Type: SEQUENCE Owner: israeld
--

CREATE SEQUENCE "datosbiblio_bib_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 20 (OID 3235353)
--
-- Name: datosbiblio Type: TABLE Owner: israeld
--

CREATE TABLE "datosbiblio" (
	"bib_id" integer DEFAULT nextval('"datosbiblio_bib_id_seq"'::text) NOT NULL,
	"nombre" character varying(200),
	"nombre_abrev" character varying(50),
	"adscripcion" character varying(100),
	"subsistema" character(100),
	"ano_fundacion" character varying(50),
	"ref_historica" character varying(12500),
	"pag_web" character varying(400),
	"control_dgb" character varying(30),
	"control_lc" character varying(30),
	"control_hx" character varying(30),
	"categoria" character varying(20),
	"cod_prog_lib" character varying(50),
	"cod_prog_rev" character varying(50),
	"prep_asig521" character varying(150),
	"prep_ejer521" character varying(150),
	"prep_asig523" character varying(150),
	"prep_ejer523" character varying(150),
	"prep_asig421" character varying(150),
	"prep_ejer421" character varying(150),
	"prep_enc_asig" character varying(150),
	"prep_enc_ejer" character varying(150),
	"superficie" numeric(9,2),
	"observaciones" character varying(1000),
	"datospropbib_obs" character varying(1000),
	"status" character varying(25),
	"spnosis" character varying(3000),
	"objetivo" character varying(1000),
	"foto" character varying(500),
	"catalogolibros" character varying(1000),
	"catalogorev" character varying(1000),
	"catalogomap" character varying(1000),
	"ariel" character varying(500),
	"contacto" character varying(500),
	"fotomapa" character varying(500),
	"opac" character varying(2000),
	"google" character varying(2000),
	"nombrecorto" character varying(2000),
	Constraint "datosbiblio_pkey" Primary Key ("bib_id")
);

--
-- TOC Entry ID 21 (OID 3235359)
--
-- Name: direccion Type: TABLE Owner: israeld
--

CREATE TABLE "direccion" (
	"dir_id" integer NOT NULL,
	"bib_id" integer NOT NULL,
	"dep_id" integer NOT NULL,
	"subdep_id" integer NOT NULL,
	"calle" character varying(100),
	"localidad" character varying(80),
	"municipio" character varying(80),
	"ciudad" character varying(80),
	"estado" character varying(50),
	"pais" character varying(80),
	"apdo_id" integer,
	"cod_post" character varying(50),
	"observaciones" character varying(1000),
	"dir_obs" character varying(1000),
	Constraint "direccion_pkey" Primary Key ("dir_id", "bib_id", "dep_id", "subdep_id")
);

--
-- TOC Entry ID 22 (OID 3235365)
--
-- Name: coleccion Type: TABLE Owner: israeld
--

CREATE TABLE "coleccion" (
	"bib_id" integer NOT NULL,
	"num_tit_lib" numeric(10,0),
	"num_vol_lib" numeric(10,0),
	"num_tit_rev" numeric(10,0),
	"num_fasc_rev" numeric(10,0),
	"num_tit_tes" numeric(10,0),
	"num_vol_tes" numeric(10,0),
	"otros_mat_doc" character varying(1000),
	"num_usuarios" numeric(10,0),
	"num_asistentes" numeric(10,0),
	"pub_editadas" character varying(2000),
	"clasif_conacyt" character varying(1000),
	"cobert_geogra" character varying(25),
	"descriptores" character varying(1500),
	"descript_entidad" character varying(2500),
	"idioma" character varying(300),
	"sist_clasif" character varying(250),
	"observaciones" character varying(1000),
	"colec_obs" character varying(1000),
	Constraint "coleccion_pkey" Primary Key ("bib_id")
);

--
-- TOC Entry ID 10 (OID 3235371)
--
-- Name: datospersona_per_id_seq Type: SEQUENCE Owner: israeld
--

CREATE SEQUENCE "datospersona_per_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 23 (OID 3235373)
--
-- Name: datospersona Type: TABLE Owner: israeld
--

CREATE TABLE "datospersona" (
	"per_id" integer DEFAULT nextval('"datospersona_per_id_seq"'::text) NOT NULL,
	"grado" character varying(15),
	"nombre" character varying(150),
	"tel_1" character varying(75),
	"tel_2" character varying(75),
	"tel_3" character varying(75),
	"fax_1" character varying(75),
	"fax_2" character varying(75),
	"mail_1" character varying(80),
	"mail_2" character varying(80),
	"horario" character varying(150),
	"observaciones" character varying(1000),
	"per_obs" character varying(1000),
	"foto" character varying(500),
	"funcion" character varying(100),
	Constraint "datospersona_pkey" Primary Key ("per_id")
);

--
-- TOC Entry ID 24 (OID 3235373)
--
-- Name: datospersona Type: ACL Owner: 
--

REVOKE ALL on "datospersona" from PUBLIC;
GRANT ALL on "datospersona" to "israeld";

--
-- TOC Entry ID 25 (OID 3235379)
--
-- Name: infraestructura Type: TABLE Owner: israeld
--

CREATE TABLE "infraestructura" (
	"bib_id" integer NOT NULL,
	"num_cpu" numeric(4,0),
	"num_term" numeric(4,0),
	"num_impr" numeric(4,0),
	"num_serv" numeric(4,0),
	"sw" character varying(2000),
	"activ_autom" character varying(1000),
	"observaciones" character varying(1000),
	"infra_obs" character varying(1000),
	Constraint "infraestructura_pkey" Primary Key ("bib_id")
);

--
-- TOC Entry ID 26 (OID 3235385)
--
-- Name: normatividad Type: TABLE Owner: israeld
--

CREATE TABLE "normatividad" (
	"bib_id" integer NOT NULL,
	"comision" character varying(2),
	"reglamento" character varying(2),
	"manuales" character varying(200),
	"observaciones" character varying(1000),
	"norm_obs" character varying(1000),
	Constraint "normatividad_pkey" Primary Key ("bib_id")
);

--
-- TOC Entry ID 27 (OID 3235391)
--
-- Name: persona Type: TABLE Owner: israeld
--

CREATE TABLE "persona" (
	"bib_id" integer NOT NULL,
	"per_id" integer NOT NULL,
	"cargo" integer NOT NULL,
	Constraint "persona_pkey" Primary Key ("bib_id", "per_id")
);

--
-- TOC Entry ID 28 (OID 3235394)
--
-- Name: rechumanos Type: TABLE Owner: israeld
--

CREATE TABLE "rechumanos" (
	"bib_id" integer NOT NULL,
	"academicos" numeric(4,0),
	"admvos" numeric(4,0),
	"honorarios" numeric(3,0),
	"total" numeric(6,0),
	"observaciones" character varying(1000),
	"rechum_obs" character varying(1000),
	Constraint "rechumanos_pkey" Primary Key ("bib_id")
);

--
-- TOC Entry ID 29 (OID 3235400)
--
-- Name: servicio Type: TABLE Owner: israeld
--

CREATE TABLE "servicio" (
	"bib_id" integer NOT NULL,
	"horario" character varying(1000) NOT NULL,
	"t_acceso_acervo" character varying(100),
	"t_matdoc_prest" character varying(2000),
	"servs_especial" character varying(2000),
	"t_fuentes_impr" character varying(2000),
	"t_fuentes_elec" character varying(2000),
	"servicios" character varying(2000),
	"t_prestamo" character varying(1000),
	"inst_usuario" character varying(2000),
	"acceso_internet" character varying(2),
	"acceso_redunam" character varying(2),
	"acceso_bd_dgb" character varying(2),
	"observaciones" character varying(1000),
	"serv_obs" character varying(1000),
	Constraint "servicio_pkey" Primary Key ("bib_id")
);

--
-- TOC Entry ID 12 (OID 3235406)
--
-- Name: usuario_usu_id_seq Type: SEQUENCE Owner: israeld
--

CREATE SEQUENCE "usuario_usu_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 30 (OID 3235408)
--
-- Name: usuario Type: TABLE Owner: israeld
--

CREATE TABLE "usuario" (
	"usu_id" integer DEFAULT nextval('"usuario_usu_id_seq"'::text) NOT NULL,
	"area" integer NOT NULL,
	"usu_login" character varying(20),
	"usu_passwd" character varying(20),
	Constraint "usuario_pkey" Primary Key ("usu_id")
);

--
-- TOC Entry ID 14 (OID 3235411)
--
-- Name: modificacion_mod_id_seq Type: SEQUENCE Owner: israeld
--

CREATE SEQUENCE "modificacion_mod_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 31 (OID 3235413)
--
-- Name: modificacion Type: TABLE Owner: israeld
--

CREATE TABLE "modificacion" (
	"mod_id" integer DEFAULT nextval('"modificacion_mod_id_seq"'::text) NOT NULL,
	"mod_id_tabla" integer,
	"mod_tabla" character(30),
	"mod_fecha" character(50),
	"mod_area" integer,
	Constraint "modificacion_pkey" Primary Key ("mod_id")
);

--
-- TOC Entry ID 32 (OID 3235416)
--
-- Name: bitacora Type: TABLE Owner: israeld
--

CREATE TABLE "bitacora" (
	"identificador" integer,
	"fecha" character varying(30),
	"hora" character varying(30),
	"ip" character varying(20)
);

--
-- Data for TOC Entry ID 54 (OID 3045857)
--
-- Name: Bitacora Type: TABLE DATA Owner: israeld
--


--
-- Data for TOC Entry ID 55 (OID 3235332)
--
-- Name: apdopost Type: TABLE DATA Owner: israeld
--


INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (0,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (144,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (145,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (166,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (198,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (213,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (214,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (215,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (216,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (217,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (218,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (219,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (220,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (221,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (222,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (223,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (224,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (225,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (226,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (227,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (228,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (229,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (230,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (231,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (232,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (233,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (234,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (235,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (236,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (237,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (238,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (239,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (240,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (241,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (242,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (243,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (244,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (245,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (246,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (247,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (248,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (249,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (250,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (251,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (252,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (253,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (254,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (255,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (256,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (257,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (258,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (259,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (260,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (261,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (262,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (263,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (264,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (265,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (266,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (267,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (268,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (269,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (270,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (271,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (272,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (273,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (274,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (275,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (276,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (277,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (278,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (279,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (280,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (281,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (282,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (283,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (284,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (285,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (286,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (287,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (288,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (289,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (290,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (291,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (292,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (293,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (294,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (295,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (296,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (297,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (298,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (326,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (332,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (333,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (339,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (133,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (31,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (48,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (72,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (23,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (336,'78283-0426','Texas','USA','','San Antonio','P. O. Box 830426');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (161,'62280','Cuernavaca','Mxico','','','565-A');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (157,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (160,'0','Morelos','Mxico','','Temixco','34');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (139,'62250','Cuernavaca','Mxico','','','510-3');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (330,'62250','Cuernavaca','Mxico','','','510-3');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (152,'62251','Cuernavaca','Mxico','','','48-3');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (206,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (80,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (79,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (78,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (83,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (341,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (346,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (334,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (324,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (128,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (153,'22800','','Mxico','','Ensenada, Baja California','356');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (205,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (171,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (335,'0','','Canad','','','78034');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (140,'93600','','','','','136');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (54,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (130,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (338,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (90,'62431','Morelos','Mxico','','Cuernavaca','4-106');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (86,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (76,'0','0','','0','0','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (22,'62280','Cuernavaca','Mxico','','','48-3');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (340,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (2,'22800','B. C.','Mxico','Ensenada','','106');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (52,'95701','','Mxico','San Andrs Tuxtla','','94');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (113,'77580','Cancn','Mxico','Puerto Morelos','Benito Jurez','1152');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (112,'82000','','Mxico','','Mazatln','811');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (111,'24140','','Mxico','El Carmen','Campeche','30');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (116,'04510','D. F.','Mxico','','Del. Coyoacn','70-543');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (74,'62580','Morelos','Mxico','','Temixco','34');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (84,'83000','Hermosillo','Mxico','','','1039');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (85,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (347,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (191,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (5,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (33,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (91,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (36,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (190,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (3,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (34,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (142,'62251','','Mxico','','Cuernavaca','273-3');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (67,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (70,'22800','','Mxico','','Ensenada','14');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (53,'48980','Jalisco','Mxico','','San Patricio','21');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (69,'62251','Cuernavaca','Mxico','','','62251');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (11,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (151,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (27,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (331,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (141,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (28,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (88,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (155,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (55,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (19,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (148,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (45,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (150,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (35,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (343,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (342,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (348,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (349,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (350,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (351,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (170,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (162,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (353,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (360,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (361,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (362,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (363,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (163,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (61,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (165,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (26,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (354,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (355,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (47,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (174,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (167,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (10,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (24,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (175,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (127,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (126,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (169,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (105,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (356,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (357,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (168,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (119,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (358,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (359,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (364,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (365,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (366,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (368,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (369,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (176,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (50,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (164,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (44,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (189,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (143,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (193,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (131,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (177,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (17,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (194,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (37,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (195,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (40,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (196,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (39,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (197,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (38,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (178,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (96,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (182,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (187,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (100,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (181,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (101,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (180,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (102,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (185,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (103,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (186,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (104,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (97,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (183,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (98,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (199,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (8,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (9,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (29,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (188,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (6,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (200,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (57,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (202,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (13,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (14,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (203,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (41,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (204,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (129,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (30,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (207,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (134,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (135,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (208,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (56,'0','Cd. Mx.','Mxico','','','20-234');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (209,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (63,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (65,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (64,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (62,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (210,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (77,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (81,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (211,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (118,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (66,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (192,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (92,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (212,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (93,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (94,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (123,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (124,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (300,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (109,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (106,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (110,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (108,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (107,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (301,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (1,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (302,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (51,'04510','Cd. Mx.','Mxico','Ciudad Universitaria','Del. Coyoacn','70-233');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (304,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (136,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (303,'0','Cd. Mx.','Mxico','','Col. Coyoacn','70-543');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (305,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (16,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (307,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (68,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (306,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (21,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (308,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (138,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (309,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (71,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (310,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (137,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (311,'0','Cd. Mx.','Mxico','Ciudad Universitaria','','70-472');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (87,'04510','Cd. Mx.','Mxico','','Del. Coyoacn','70-472');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (4,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (25,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (313,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (82,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (89,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (322,'01000','Cd. Mx.','Mxico','San ngel','Del. lvaro Obregn','20-726');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (18,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (321,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (73,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (12,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (60,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (58,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (59,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (42,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (43,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (20,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (49,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (323,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (75,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (325,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (114,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (121,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (345,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (370,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (371,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (372,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (373,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (320,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (315,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (319,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (314,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (317,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (318,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (154,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (312,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (316,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (156,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (146,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (149,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (147,'62431','Morelos','Mxico','','Cuernavaca','4-106');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (327,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (159,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (158,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (337,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (329,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (344,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (299,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (352,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (125,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (46,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (179,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (95,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (184,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (32,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (201,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (115,'0','','','','','70-391');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (117,'0','','','','Taxco de Alarcn','70');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (132,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (367,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (328,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (120,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (7,'0','','','','','0');
INSERT INTO "apdopost" ("apdo_id","cod_post","ciudad","pais","localidad","municipio","apdo_post") VALUES (99,'0','','','','','0');
--
-- Data for TOC Entry ID 56 (OID 3235337)
--
-- Name: datosdepen Type: TABLE DATA Owner: israeld
--


INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (65,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Ingeniera','FING','                                                                                                                                                      ','0','http://www.ingenieria.unam.mx/menu_principal.php','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (74,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Ciencias del Mar y Limnologa','ICML','                                                                                                                                                      ','0','http://www.icmyl.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (0,'Universidad Nacional Autnoma de Mxico','UNAM','Universidad Nacional Autnoma de Mxico',NULL,'                                                                                                                                                      ','0','http://www.ier.unam.mx/\011\011','Biblioteca dada de alta 14 febrero 2014','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (125,'Universidad Nacional Autnoma de Mxico',NULL,'Centro de Investigaciones en Geografa Ambiental. Campus Morelia, Mich.',NULL,'                                                                                                                                                      ','0','http://www.ciga.unam.mx','Biblioteca dada de alta 14 febrero 2014','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (93,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Matemticas','IMAT','                                                                                                                                                      ','0','http://www.matem.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (104,'UNAM',NULL,'Biblioteca del Campus Juriquilla','','                                                                                                                                                      ','0','http://www.biblioteca.juriquilla.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (11,'Universidad Nacional Autnoma de Mxico','UNAM','Centro de Enseanza para Extranjeros','CEPE','                                                                                                                                                      ','0','http://www.cepe.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (55,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Arquitectura','FARQ','                                                                                                                                                      ','0','http://www.arq.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (7,'Universidad Nacional Autnoma de Mxico','UNAM','Centro de Ciencias Aplicadas y Desarrollo Tecnolgico','CCAD','                                                                                                                                                      ','0','http://www.ccadet.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (61,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Estudios Superiores Cuautitln','FESC','                                                                                                                                                      ','0','http://www.cuautitlan.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (72,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Biologa','IBIO','                                                                                                                                                      ','0','http://www.ib.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (73,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Ciencias Nucleares','ICNU','                                                                                                                                                      ','0','http://www.nucleares.unam.mx/icn2/\011','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (63,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Estudios Superiores Zaragoza','FESZ','                                                                                                                                                      ','0','http://www.zaragoza.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (100,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Biotecnologa. Cuernavaca, Mor.','IBIT','                                                                                                                                                      ','0','http://www.ibt.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (62,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Estudios Superiores Iztacala','FESI','                                                                                                                                                      ','0','http://www.iztacala.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (1,'Universidad Nacional Autnoma de Mxico','UNAM','Biblioteca Conjunta de Ciencias de la Tierra','BCCT','                                                                                                                                                      ','0','http://bcct.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (17,'Universidad Nacional Autnoma de Mxico','UNAM','Centro de Ciencias Genmicas. Cuernavaca, Mor.','CIFN','                                                                                                                                                      ','0','http://www.ccg.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (101,'Universidad Nacional Autnoma de Mxico','UNAM','Centro de Ciencias de la Atmsfera','CCAT','                                                                                                                                                      ','0','http://www.atmosfera.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (82,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Investigaciones Antropolgicas','IIAN','                                                                                                                                                      ','0','http://www.iia.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (66,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Medicina','FMED','                                                                                                                                                      ','0','http://www.facmed.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (2,'Universidad Nacional Autnoma de Mxico','UNAM','Centro de Investigaciones sobre Amrica Latina y el Caribe','CCDE  ','                                                                                                                                                      ','0','http://www.cialc.unam.mx/','Gaceta del 20 de agosto 2007 el CCyDEL cambia a CIALC. DPLybf','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (44,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Artes y Diseo','ENAP','                                                                                                                                                      ','0','http://www.enap.unam.mx','Cambio de denominacin de Escuela Nacional de Artes Plsticas a Facultad de Artes y Diseo. Lunes 24 de marzo de 2014.','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (37,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Preparatoria. Plantel 4, Vidal Castaeda y Njera','ENP4','                                                                                                                                                      ','0','http://enp4.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (40,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Preparatoria. Plantel 8, Miguel E. Schulz','ENP8','                                                                                                                                                      ','0','http://prepa8.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (4,'Universidad Nacional Autnoma de Mxico','UNAM','Centro Universitario de Estudios Cinematogrficos','CUEC','                                                                                                                                                      ','0','http://www.cuec.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (35,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Preparatoria. Direccin General','ENPD','                                                                                                                                                      ','0','http://dgenp.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (67,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Medicina Veterinaria y Zootecnia','FMVZ','                                                                                                                                                      ','0','http://www.fmvz.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (43,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Preparatoria. Plantel 3, Justo Sierra','ENP3','                                                                                                                                                      ','0','http://enp3.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (36,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Preparatoria. Plantel 5, Jos Vasconcelos','ENP5','                                                                                                                                                      ','0','http://www.prepa5.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (106,'Universidad Nacional Autnoma de Mxico',NULL,'Unidad Acadmica de Estudios Regionales. Sede La Cinega, Jiquilpan de Jurez, Mich.',NULL,'                                                                                                                                                      ','0','http://uaer.humanidades.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (15,'Universidad Nacional Autnoma de Mxico','UNAM','Centro de Investigaciones sobre Amrica del Norte','CIAN','                                                                                                                                                      ','0','http://www.cisan.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (3,'Universidad Nacional Autnoma de Mxico','UNAM','Centro Regional de Investigaciones Multidisciplinarias de la UNAM. Cuernavaca, Mor.','CRIM','                                                                                                                                                      ','0','http://www.crim.unam.mx/drupal/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (6,'Universidad Nacional Autnoma de Mxico','UNAM','Centro Universitario de Teatro','CUTE','                                                                                                                                                      ','0','http://www.cut.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (107,'Universidad Nacional Autnoma de Mxico','UNAM','Consejo Acadmico del Bachillerato','CAB','                                                                                                                                                      ','0','http://www.cab.unam.mx','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (110,'Universidad Nacional Autnoma de Mxico','UNAM','Consejo Tcnico y Coordinacin de la Investigacin Cientfica','CIC','                                                                                                                                                      ','0','http://www.cic-ctic.unam.mx/cic/index_cic.html','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (26,'Universidad Nacional Autnoma de Mxico','UNAM','Coordinacin de Estudios de Posgrado','DGEP','                                                                                                                                                      ','0','http://www.posgrado.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (18,'Universidad Nacional Autnoma de Mxico','UNAM','Coordinacin de Universidad Abierta y Educacin a Distancia','CUAE','                                                                                                                                                      ','0','http://www.cuaed.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (116,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de  Comunicacin Social','DPR','                                                                                                                                                      ','0','http://www.dgcs.unam.mx/','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (117,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de  Planeacin','PL','                                                                                                                                                      ','0','http://www.planeacion.unam.mx/','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (21,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Artes Visuales','DGAR','                                                                                                                                                      ','0','http://www.muac.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (23,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Bibliotecas','DGBI','                                                                                                                                                      ','0','http://dgb.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (31,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Cmputo y de Tecnologas de Informacin y Comunicacin','DGSC','                                                                                                                                                      ','0','http://www.tic.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (24,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Divulgacin de la Ciencia','DGDC','                                                                                                                                                      ','0','http://www.dgdc.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (25,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Estudios de Legislacin Universitaria','DGEL','                                                                                                                                                      ','0','http://www.dgelu.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (114,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Evaluacin  Educativa','DEE','                                                                                                                                                      ','0','http://www.evaluacion.unam.mx/','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (115,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Incorporacin y Revalidacin de Estudios','DIR','                                                                                                                                                      ','0','http://www.dgire.unam.mx/contenido/home.htm','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (118,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Personal','DGP','                                                                                                                                                      ','0','http://www.personal.unam.mx/DGPE/','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (119,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Publicaciones y Fomento Editorial','DPB','                                                                                                                                                      ','0','http://www.libros.unam.mx/','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (120,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Radio UNAM','RU','                                                                                                                                                      ','0','http://www.radiounam.unam.mx/','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (32,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Televisin Universitaria','DGTV','                                                                                                                                                      ','0','http://www.tvunam.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (45,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional de Enfermera y Obstetricia','ENEO','                                                                                                                                                      ','0','http://www.eneo.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (48,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Msica','ENMU','                                                                                                                                                      ','0','http://www.enmusica.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (39,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Preparatoria. Plantel 9, Pedro de Alba','ENP9','                                                                                                                                                      ','0','http://www.prepa9.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (42,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Preparatoria. Plantel 7, Ezequiel A. Chvez','ENP7','                                                                                                                                                      ','0','http://prepa7.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (34,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Preparatoria Plantel 1, Gabino Barreda','ENP1','                                                                                                                                                      ','0','http://prepa1.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (56,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Ciencias','FCIE','                                                                                                                                                      ','0','http://www.fciencias.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (13,'Universidad Nacional Autnoma de Mxico','UNAM','Centro de Geociencias. Campus Juriquilla, Qro.','I3','                                                                                                                                                      ','0','http://www.geociencias.unam.mx/geociencias/index.html','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (102,'Universidad Nacional Autnoma de Mxico','UNAM','Centro de Fsica Aplicada y Tecnologa Avanzada. Campus Juriquilla. Qro.',NULL,'                                                                                                                                                      ','0','http://www.fata.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (94,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Neurobiologa. Campus Juriquilla, Qro.','INEU','                                                                                                                                                      ','0','http://www.inb.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (87,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Investigaciones Filosficas','IIFS','                                                                                                                                                      ','0','http://recursos.filosoficas.unam.mx/~jrg/iifs/sitio/index.php\011','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (78,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Geofsica','IGEF','                                                                                                                                                      ','0','http://www.igeofcu.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (80,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Geologa','IGEL','                                                                                                                                                      ','0','http://www.geologia.unam.mx/igl','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (57,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Ciencias Polticas y Sociales','FCPS','                                                                                                                                                      ','0','http://www.politicas.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (58,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Contadura y Administracin','FCAD','                                                                                                                                                      ','0','http://www.fca.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (59,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Derecho','FDER','                                                                                                                                                      ','0','http://www.derecho.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (60,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Economa','FECO','                                                                                                                                                      ','0','http://herzog.economia.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (46,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Estudios Superiores  Acatln','FESA','                                                                                                                                                      ','0','http://www.acatlan.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (47,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Estudios Superiores Aragn','FESAR','                                                                                                                                                      ','0','http://www.aragon.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (64,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Filosofa y Letras','FFLE','                                                                                                                                                      ','0','http://www.filos.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (68,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Odontologa','FODO','                                                                                                                                                      ','0','http://www.odonto.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (69,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Psicologa','FPSI','                                                                                                                                                      ','0','http://www.psicologia.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (70,'Universidad Nacional Autnoma de Mxico','UNAM','Facultad de Qumica','FQUI','                                                                                                                                                      ','0','http://www.quimica.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (5,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Investigaciones Bibliotecolgicas y de la Informacin','CUIB','                                                                                                                                                      ','0','http://iibi.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (84,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Investigaciones Econmicas','IIEC','                                                                                                                                                      ','0','http://www.iiec.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (86,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Investigaciones Filolgicas','IIFL','                                                                                                                                                      ','0','http://www.iifilologicas.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (88,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Investigaciones Histricas','IIHI','                                                                                                                                                      ','0','http://www.historicas.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (89,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Investigaciones Jurdicas','IIJU','                                                                                                                                                      ','0','http://info.juridicas.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (12,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Investigaciones sobre la Universidad y la Educacin','CESU','                                                                                                                                                      ','0','http://www.iisue.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (90,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Investigaciones Sociales','IISO','                                                                                                                                                      ','0','http://www.iis.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (71,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Astronoma','IAST','                                                                                                                                                      ','0','http://www.astroscu.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (8,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Ciencias Fsicas. Cuernavaca, Mor.','CCFI','                                                                                                                                                      ','0','http://www.fis.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (77,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Fsica','IFIS','                                                                                                                                                      ','0','http://www.fisica.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (76,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Fisiologa Celular','IFCE','                                                                                                                                                      ','0','http://www.ifc.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (79,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Geografa','IGEO','                                                                                                                                                      ','0','http://www.igg.unam.mx/sigg/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (81,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Ingeniera','IING','                                                                                                                                                      ','0','http://www.iingen.unam.mx/es-mx/Paginas/default.aspx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (92,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Investigaciones en Matemticas Aplicadas y en Sistemas','IIMA','                                                                                                                                                      ','0','http://www.iimas.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (121,'Universidad Nacional Autnoma de Mxico','UNAM','Secretara de Desarrollo Institucional','CRU','                                                                                                                                                      ','0','http://www.sdei.unam.mx/','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (122,'Universidad Nacional Autnoma de Mxico','UNAM','Unidad Coordinadora de Servicios Acadmicos','USA','                                                                                                                                                      ','0','http://www.cab.unam.mx/','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (85,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Investigaciones Estticas','IIES','                                                                                                                                                      ','0','http://www.esteticas.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (38,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Preparatoria. Plantel 2, Erasmo Castellanos Quinto','ENP2','                                                                                                                                                      ','0','http://prepa2.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (41,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Preparatoria. Plantel 6, Antonio Caso','ENP6','                                                                                                                                                      ','0','http://www.prepa6.unam.mx/ENP6/_P6/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (108,'Universidad Nacional Autnoma de Mxico','UNAM','Programa Universitario de Estudios de la Diversidad Cultural y la Interculturalidad','PUMN','                                                                                                                                                      ','0','http://www.nacionmulticultural.unam.mx/','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (123,'Universidad Nacional Autnoma de Mxico','UNAM','Centro de Ciencias Matemticas. Campus Morelia, Mich.','CCM','                                                                                                                                                      ','0','http://www.matmor.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (103,'Universidad Nacional Autnoma de Mxico','UNAM','Centro Peninsular en Humanidades y Ciencias Sociales. Mrida, Yuc.',NULL,'                                                                                                                                                      ','0','http://www.cephcis.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (98,'Universidad Nacional Autnoma de Mxico','UNAM','Programa Universitario de Estudios sobre la Ciudad','PUEC','                                                                                                                                                      ','0','http://www.puec.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (91,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Investigaciones en Materiales','IIMT','                                                                                                                                                      ','0','http://www.iim.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (75,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Ecologa','IECO','                                                                                                                                                      ','0','http://web.ecologia.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (95,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Qumica','IQUI','                                                                                                                                                      ','0','http://www.iquimica.unam.mx','Cuenta con una sede foranea desde 2008: el Centro Conjunto de Investigacin en Qumica Sustentable  en Toluca','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (19,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Actividades Cinematogrficas','DGAC','                                                                                                                                                      ','0','http://www.filmoteca.unam.mx/','Gaceta 8 de marzo 2012. Nuevo espacio  con 2,522 m2 en donde incluye bvedas, tienda, videoclub y biblioteca. DPLybf','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (124,'Universidad Nacional Autnoma de Mxico',NULL,'Escuela Nacional de Estudios Superiores. Unidad Len, Gto.',NULL,'                                                                                                                                                      ','0','http://enes.unam.mx/?lang=es_MX','Gaceta 5 septiembre 2011. ENES ocupa el predio del saucillo y el potrero, con una superficie de 10795m2. DPLybf','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (9,'Universidad Nacional Autnoma de Mxico','UNAM','Centro de Nanociencias y Nanotecnologa. Ensenada, B. C.','CCMC','                                                                                                                                                      ','0','http://www.cnyn.unam.mx/','Gaceta 3 marzo 2014. Construccin de edificio C, Incluye aulas, laboratorios e investigacin, cmputo, sala de seminarios y biblioteca. DPLybf','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (16,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Energas Renovables. Temixco, Mor.','CIEN','                                                                                                                                                      ','0','http://xml.cie.unam.mx/xml/','CAMBIO DE DENOMINACION: Centro de Investigacin en Energia. Temixco, Mor. A Instituto de Energas Renovables. Publicado en Gaceta 4485. 28/enero/2013. DPLybf','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (83,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Investigaciones Biomdicas','IIBO','                                                                                                                                                      ','0','http://www.biomedicas.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (105,'Universidad Nacional Autnoma de Mxico',NULL,'Instituto de Investigaciones en Ecosistemas y Sustentabilidad. Campus Morelia, Mich.',NULL,'                                                                                                                                                      ','0','http://www.oikos.unam.mx/CIEco/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (99,'Universidad Nacional Autnoma de Mxico','UNAM','Centro de Investigaciones Multidisciplinarias sobre Chiapas y la Frontera Sur. San Cristbal de las Casas, Chis.','PIMM','                                                                                                                                                      ','0','http://proimmse.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (109,'Universidad Nacional Autnoma de Mxico','UNAM','Instituto de Radioastronoma y Astrofsica. Campus Morelia, Mich.','A2','                                                                                                                                                      ','0','http://www.crya.unam.mx/','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (126,'Universidad Nacional Autnoma de Mxico',NULL,'Escuela Nacional de Estudios Superiores. Unidad Morelia, Mich.','ENESM',NULL,NULL,'http://www.enesmorelia.unam.mx/index.php',NULL,NULL,NULL,'u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (30,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Atencin a la Salud','DGSM','                                                                                                                                                      ','0','http://www.dgsm.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (49,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional de Trabajo Social','ENTS','                                                                                                                                                      ','0','http://www.trabajosocial.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (113,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General de Atencin a la Comunidad','SC','                                                                                                                                                      ','0','http://www.tucomunidad.unam.mx/','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (14,'Universidad Nacional Autnoma de Mxico','UNAM','Centro de Investigaciones Interdisciplinarias en Ciencias y Humanidades','CEII','                                                                                                                                                      ','0','http://www.ceiich.unam.mx/0/index.php','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (20,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin General del Deporte Universitario','DGAD','                                                                                                                                                      ','0','http://www.deporte.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (112,'Universidad Nacional Autnoma de Mxico','UNAM','Direccin de Relaciones Laborales','DRL','                                                                                                                                                      ','0','http://web.dgp.unam.mx:9090/laborales/','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (97,'Universidad Nacional Autnoma de Mxico','UNAM','Centro de Investigaciones y Estudios de Gnero','PUEG','                                                                                                                                                      ','0','http://www.pueg.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (111,'Universidad Nacional Autnoma de Mxico','UNAM','Coordinacin de Difusin Cultural','DF','                                                                                                                                                      ','0','http://www.cultura.unam.mx/index.aspx','','','','');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (10,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional de Lenguas, Lingstica y Traduccin','CELE','                                                                                                                                                      ','0','http://comenius.cele.unam.mx/cele/','Cuenta con una sede fuera de CU desde 2011: CELE, Tlalpan. G. 5 diciembre 2011. DPLybf','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (33,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Colegio de Ciencias y Humanidades. Direccin General','CCHD','                                                                                                                                                      ','0','http://www.cch.unam.mx','La biblioteca se encuentra en las instalaciones del Centro de Formacin Docente del CCH desde el 9 de abril de 2012. Ubicado en Guty Crdenas. G. 19 abril 2012. DPLybf.','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (50,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Colegio de Ciencias y Humanidades. Plantel Azcapozalco','CCHA','                                                                                                                                                      ','0','http://www.cchazc.unam.mx','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (51,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Colegio de Ciencias y Humanidades. Plantel Naucalpan','CCHN','                                                                                                                                                      ','0','http://www.cch-naucalpan.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (52,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Colegio de Ciencias y Humanidades. Plantel Oriente','CCHO','                                                                                                                                                      ','0','http://www.cch-oriente.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (53,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Colegio de Ciencias y Humanidades. Plantel Sur','CCHS','                                                                                                                                                      ','0','http://www.cch-sur.unam.mx/','','','','u');
INSERT INTO "datosdepen" ("dep_id","nom_int","siglas_inst","nom_depen","siglas_depen","nom_subdepen","ano_fundacion","pag_web","observaciones","dep_obs","objetivo","semaforo") VALUES (54,'Universidad Nacional Autnoma de Mxico','UNAM','Escuela Nacional Colegio de Ciencias y Humanidades. Plantel Vallejo','CCHV','                                                                                                                                                      ','0','http://www.cch-vallejo.unam.mx/','','','','u');
--
-- Data for TOC Entry ID 57 (OID 3235345)
--
-- Name: datosubdep Type: TABLE DATA Owner: israeld
--


INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (0,0,'','','1950','',NULL,NULL);
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (8,81,'Grupo de Estudios Sobre Innovacin Tecnologica','','1950','www.unam.mx',NULL,NULL);
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (34,70,'Divisin de Estudios de Posgrado','','1950','www.unam.mx',NULL,NULL);
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (5,23,'Biblioteca Central','DGBI','1956','http://bc.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (29,66,'Departamento de Medicina Familiar','','1993',' http://www.facmed.unam.mx','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (27,66,'Departamento de Salud Pblica','','1984',' http://www.facmed.unam.mx','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (31,66,'Divisin de Estudios de Posgrado e Investigacin','','1954','http://www.facmed.unam.mx','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (19,65,'Acervo Histrico','','1959','http://www.ingenieria.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (15,56,'Divisin de Estudios de Profesionales','','1950','http://www.fciencias.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (3,55,'Centro de Investigaciones de Diseo Industrial','','1984','http://ce-atl.posgrado.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (12,72,'','','1929','http://132.248.13.40/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (51,11,'Escuela de Extensin, Gatineau, Canad','','1950','http://www.unameseca.com/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (11,89,'Unidad de Documentacin de Legislacin y Jurisprudencia','','1950','http://info.juridicas.unam.mx/infjur/leg/direc.htm','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (9,60,'Divisin de Estudios de Posgrado','','1950','http://www.depfe.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (32,68,'Divisin de Estudios Profesionales','','1975','http://www.odonto.unam.mx/licenciatura/index.html','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (28,66,'Departamento de Psicologa Mdica, Psiquiatra y Salud Mental','','1950','http://www.facmed.unam.mx','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (30,66,'Departamento de Historia y Filosofia de la Medicina','','1954','http://www.facmed.unam.mx','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (16,65,'Estudios de Posgrado','','1959','http://www.ingenieria.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (43,31,'Centro de Extensin en Cmputo y Telecomunicaciones Coapa','','2001','http://www.coapa.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (17,65,'Divisin de Educacin Continua y a Distancia','DEC','1959','http://www.mineria.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (38,11,'Campus Taxco, Gro.','CEET','1992','http://www.cepetaxco.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (52,11,'Escuela Permanente de Extensin, San Antonio, Texas','','1950','http://www.usa.unam.edu/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (53,18,'Centro de  Alta Tecnologa de Educacin a Distancia, Tlaxcala. Tlax.','','1950','http://www.cated.cuaed.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (44,63,'Campo 2','','1950',' http://www.zaragoza.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (20,67,'Centro de Enseanza, Inv. y Ext.en Produccin Avcola','CEIEPA','1971',' http://www.fmvz.unam.mx/fmvz/centros/ceiepa/ceiepa.htm','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (23,67,'Centro de Enseanza, Inv. y Ext en Produccin Ovina, Huitzilac, Mor.','CEIEPO','1992','http://www.fmvz.unam.mx/fmvz/centros/ceiepo/ceiepo.htm','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (49,67,'Centro de Enseanza, Inv. y Ext. en Produccin Porcina, Jilotepec','CEIEPP','1969','http://www.fmvz.unam.mx/fmvz/centros/ceiepp/ceiepp.htm','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (35,70,'Divisin de Estudios Profesionales (Anexo)','','1965','http://www.fquim.unam.mx','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (36,70,'Divisin de Estudios de Posgrado (Anexo)','','1965','http://www.fquim.unam.mx','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (37,70,'Hemeroteca','','1965','http://www.fquim.unam.mx','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (47,74,'Unidad Acadmica Mazatln, Sin.','','1980','http://ola.icmyl.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (26,93,'Unidad Cuernavaca, Mor.','','1950','http://www.matcuer.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (25,93,'Campus Morelia, Mich.','','1990','http://www.matmor.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (39,69,'Divisin de Estudios Profesionales','','1973','http://www.psicol.unam.mx/Principal/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (10,61,'Campo 4','','1974','0','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (50,67,'Centro de Enseanza, Inv. y Ext. en Ganadera Tropical, Martnez de la Torre, Ver.','CEIEGT','1977','http://www.fmvz.unam.mx/fmvz/centros/ceiegt/ceiegt.html','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (18,65,'Divisin de Estudios Profesionales (Anexo)','','1959',' ','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (41,31,'Centro de Extensin Nuevo Len','','1992','http://www.nuevoleon.unam.mx','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (42,31,'Centro de Extensin Mascarones','','1995','http://hermes.mascarones.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (33,68,'Divisin de Estudios de Posgrado','','1975','http://www.odonto.unam.mx/posgrado/index.html','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (21,67,'Centro de Enseanza, Inv. y Ext.en Produccin Animal en Altiplano, Tequisquiapan, Qro.','CEIEPByC','1969',' http://www.fmvz.unam.mx/fmvz/centros/ceiepaa/acerca.html','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (6,23,'Subdireccin de Servicios de Informacin Especializada. Departamento de Informacin y Servicios Documentales','','1971','http://www.dgbiblio.unam.mx','*En 1971 fue creado como Centro de Informacin Cientfica y Humanstica (CICH) $*En 1997 pasa a formar parte de la Direccin General de Bibliotecas.$*10 de enero 2006 la Subdireccin de Servicios Especializados se denominar Subdireccin de Servicios de Informacin Especializada. DPLybf','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (7,58,'Divisin de Estudios de Posgrado','','1973','http://posgrado.fca.unam.mx','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (4,55,'Divisin de Estudios de Posgrado','','1990','http://ciepfa.posgrado.unam.mx/index_flash.html','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (40,69,'Divisin de Estudios de Posgrado','','1973','http://www.psicologia.unam.mx/pagina/es/238/division-de-investigaciony-posgrado','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (13,72,'Estacin de Biologa Tropical Los Tuxtlas, Veracruz','','1967','http://www.ibiologia.unam.mx/tuxtlas/tuxtlas.htm','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (14,72,'Estacin de Investigacin, Experimentacin y Difusin Chamela, Jalisco','','1971','http://www.ibiologia.unam.mx/ebchamela/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (46,74,'Estacin Ciudad del Carmen, Campeche','','1950','http://www.icmyl.unam.mx/?q=node/23','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (54,85,'Sede Oaxaca',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (45,80,'Estacin Regional del Noroeste, Hermosillo, Son.','ERNO','1974','http://www.geologia-son.unam.mx/','0','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (1,71,'Observatorio Astronmico Nacional San Pedro Mrtir. Ensenada, B. C.','OANS','1979','http://bufadora.astrosen.unam.mx/indexeda.html','0','Inaugurada 03.09.1988. Gaceta 3214');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (2,44,'Posgrado en Artes y Diseo','','1950','http://academiasancarlos.unam.mx/index.html','Cambio de denominacin de Divisin Estudios de Posgrado a POSGRADO EN ARTES Y DISEO. 30 marzo 2011. DPLybf','');
INSERT INTO "datosubdep" ("subdep_id","dep_id","nom_subdepen","subdepen_siglas","subdepen_ano_fundacion","subdepen_pag_web","observaciones","subdepen_obs") VALUES (48,74,'Unidad Acadmica Sistemas Arrecifales Puerto Morelos, Quintana Roo','','1950','http://www.icmyl.unam.mx/arrecifes/rsu.html','0','');
--
-- Data for TOC Entry ID 58 (OID 3235353)
--
-- Name: datosbiblio Type: TABLE DATA Owner: israeld
--


INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (5,'Biblioteca "Juan Comas"','','','Investigacin en Humanidades                                                                        ','1973','1973 ','http://biblio.unam.mx:8250/','AN','','P06','','32202210152107','32202210152303','0','0.00','0','0.00','0.00','0.00','0','0','986.00','','',NULL,NULL,'','bib05.jpg','','','','','','Mbib05.jpg','http://jcomas.iia.unam.mx:8991','https://goo.gl/maps/h2NgUoCM9pR2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (146,'Biblioteca Conjunta de Ciencias de la Tierra','','','Investigacin Cientfica                                                                            ','1997','',' http://bcct.unam.mx/ ','CAT','','P1A','','31203110252105','31203110252301','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','','',NULL,NULL,'','bib146.jpg','','','','','','Mbib146.jpg','http://132.248.182.16:8991','https://goo.gl/maps/5dwmWq2BygH2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (43,'Biblioteca "Guillermo Haro"','','','Bachillerato                                                                                        ','1972','','http://www.cch-oriente.unam.mx/','CYHE','','P4A','','21204720552101','21204720552307','0','0.00','0','0.00','0.00','0.00','0','0','1871.00','','',NULL,NULL,'','bib43.jpg','','','','','','Mbib43.jpg','http://biblioteca.cch-oriente.unam.mx:8991','https://goo.gl/maps/CAxK9Hs1twS2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (16,'Biblioteca "C.P.Wilfrido Castillo Miranda"','','','Licenciatura y Posgrado                                                                             ','1997','',' http://biblio.contad.unam.mx/ ','C1','','PF1','','11204130252102','11204130252308','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','1946.00','','',NULL,NULL,'','bib16.jpg','','','','','','Mbib16.jpg','http://alephfca.fca.unam.mx:8991','https://goo.gl/maps/iqurukJR83p','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (3,'Biblioteca. Observatorio Astronmico Nacional ','','','Investigacin Cientfica                                                                            ','1980','',' http://bufadora.astrosen.unam.mx/~bibens/biblioteca.html ','A1','','P03','','31203120252102','31203120252308','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','282.00','','',NULL,NULL,'','bib03.jpg','','','','','','Mbib03.jpg','http://microens.astrosen.unam.mx:8991','https://goo.gl/maps/z4Ki7NHZ6Ut','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (46,'Biblioteca "Javier Elola Fernndez"','','','Investigacin en Humanidades                                                                        ','1940','','http://www.juridicas.unam.mx/infjur/leg/','DC1','','PF4','','','','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','573.00','','',NULL,NULL,'','bib46.jpg','','','','','','Mbib46.jpg','SIN CATLOGOS','https://goo.gl/maps/JquSpveTpF42','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (78,'Biblioteca "Mtro. Sotero Prieto"','','','Investigacin Cientfica                                                                            ','1948','','http://biblioteca.matem.unam.mx/','GM','','P90','','31203190152104','31203190152300','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','645.00','','',NULL,NULL,'','bib78.jpg','','','','','','Mbib78.jpg','http://132.248.17.225:8991','https://goo.gl/maps/dYvNFUFGAr42','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (147,'Biblioteca "Solomon Lefschetz"','','','Investigacin Cientfica                                                                            ','1999','','http://132.248.41.35:8991/F','GM2','','','','31023190352100','31023190352306','0','0.00','0','0.00','0.00','0.00','0.00','0.00','114.00','','',NULL,NULL,'','bib147.jpg','','','','','','Mbib147.jpg','http://presli.matcuer.unam.mx:8991','https://goo.gl/maps/K6kTpj6HfHG2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (0,'',NULL,NULL,'                                                                                                    ','0',NULL,'','',NULL,'',NULL,NULL,NULL,'0.00',NULL,'0.00','0.00','0.00','0.00','0.00','0.00','0.00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1070,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1080,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1090,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1110,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1120,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1130,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1140,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1160,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1170,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1180,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1190,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1210,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (1220,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (149,'"Biblioteca Grupo de Estudios sobre Innovacin Tecnolgica"',NULL,NULL,'Licenciatura y Posgrado                                                                             ','1952',NULL,' http://www.unam.mx ','CIT',NULL,'P31',NULL,NULL,NULL,'0.00',NULL,'0.00','0.00','0.00','0.00','0.00','0.00','0.00',NULL,NULL,NULL,NULL,NULL,'bib149.jpg',NULL,NULL,NULL,NULL,NULL,'Mbib149.jpg',NULL,NULL,'NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (119,'Biblioteca "Simn Bolvar"','','','Extensin y Administracin Universitaria                                                            ','1926','La biblioteca del Centro de Enseanza para Extranjeros (CEPE) inici sus actividades en el ao de 1926, en el edificio conocido con el nombre de Mascarones, ubicado en la calle de Ribera de San Cosme, nm. 71, sede, en ese entonces, de la Escuela de Verano, hoy CEPE. En el Catlogo de la Universidad Nacional de Mxico, 1926-1927, se sealaba que la biblioteca contaba con un acervo de 1000 volmenes. $En el folleto de propaganda de la Escuela de Verano, del ao 1929, se mencionaba que: Los alumnos de la Escuela de Verano pueden hacer uso, sin costo alguno, de los libros que forman la biblioteca de la Escuela de Verano.... La biblioteca ha sido partcipe de los cambios de sede de la escuela antes mencionada. En 1955 comparti espacio con la biblioteca de la Facultad de Filosofa y Letras y, en 1978, se le dota de las instalaciones que hasta la fecha ocupa.$$Texto elaborado por Rebeca Garca.','http://www.cepe.unam.mx/biblioteca.php','N','','PB8','','43206130152106','43206130152302','0','0.00','0','0.00','0.00','0.00','0','0','157.00','','',NULL,NULL,'','bib119.jpg','','','','','','Mbib119.jpg','http://biblioteca.cepe.unam.mx:8991','https://goo.gl/maps/V3ZGMwzon7x','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (28,'Biblioteca. Direccin General de Artes Visuales','','','Extensin y Administracin Universitaria                                                            ','1980','La Biblioteca se inici en 1980 como centro documental del Centro de Investigacin y Servicios Museolgicos (CISM), adscrito al Departamento de Museos y Galeras de la Coordinacin de Humanidades, cambiando posteriormente su adscripcin a la Coordinacin de Extensin Universitaria.$Uno de sus fondos ms importantes est formado por los catlogos de exposiciones realizadas en el MUCA y en la Galera Universitaria Aristos.$Informacin proporcionada por: Lic. Patricia de la Fuente Merino.','http://muac.unam.mx/biblioteca.php','CIM','','P30','','41026210152101','41016210152304','0','0.00','0','0.00','0.00','0.00','0.00','0.00','109.00','','',NULL,NULL,'','bib28.jpg','','','','','','Mbib28.jpg','http://biblio192.dgbiblio.unam.mx:8994','https://goo.gl/maps/UT93YxfjPUS2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (123,'Biblioteca "Manuel Sandoval Vallarta"','','','Extensin y Administracin Universitaria                                                            ','1992','La biblioteca Manuel Sandoval Vallarta  anteriormente perteneca al  Consejo Nacional para la Ciencia y la Tecnologa (CONACYT),  que al dejar las instalaciones en el Ciudad Universitaria,  deja una  coleccin  de  aproximadamente  9, 000  ejemplares, que sumados a los  5, 000 ejemplares del  Centro Universitario de Comunicacin de la Ciencia, hoy DGDC,  conforman la base para integrar una coleccin documental  no solo en la divulgacin de las ciencias sino en otras reas afines.Para dar cumplimiento a los objetivos de difusin y divulgacin de la ciencia, as como el apoyo a la docencia e investigacin y extensin de la cultura, la biblioteca,  el 12 de diciembre de 1992, fecha en la que el Museo de las Ciencias UNIVERSUM, es inaugurado por el Dr. Jos Sarukhn Kermez,  inicia el desarrollo de una coleccin especializada en la divulgacin de la ciencia, con la cual ofrece a los usuarios una gama de recursos documentales.La constante actualizacin  de su  coleccin  monogrfica,  la facilidad de acceso directo a sus colecciones,  con  ms  de 18, 000 ejemplares, de donde  se destaca la coleccin infantil, nica en su gnero en el Sistema Bibliotecario de la UNAM. Adicionalmente la coleccin de 1, 500  materiales videogrficos entre los que encontramos formatos VHS y  DVD  interactivos. Su coleccin de publicaciones peridicas, ofrece las ltimas novedades en el campo de la divulgacin y enseanza de la ciencia y la tecnologa, con 75  ttulos adquiridos por compra y donacin. Como complemento a toda sta  riqueza documental,  existen otras colecciones especiales como INEGI, Tesis en el rea de  divulgacin, Mapas en Ciencias de la Tierra y Astronoma  y Libros antiguos, con todos ellos se atiende a la comunidad de la DGDC y al pblico que asiste al museo,  sumando ms de 100, 000 usuarios desde  su apertura. Sus confortables instalaciones las cuales para beneplcito de sus usuarios,  en agosto de 2007,  despus de 15 aos de servicio se remodelan  adecuando espacios y mobiliario acorde  al tipo de servicios y usuarios.La automatizacin de su control de prstamo y de  registro de usuarios, el acceso en la recuperacin de sus colecciones mediante los catlogos automatizados, y las distintas bases de datos, auspiciadas por la DGB,  entre las que destacan la de videos y temtica, sus servicios de documentacin y los recursos electrnicos, sumados  al  equipo de trabajo de su personal administrativo y profesional,  ofrecen una atencin  personalizada en busca de satisfacer las necesidades de informacin de los usuarios. Logrando hacer de la biblioteca una de las primeras a nivel nacional en el rea de divulgacin y la enseanza de la ciencia y la tecnologa. Texto enviado por  Mtro. Ral Ortega','http://biblioteca.universum.unam.mx/  ','PCC','','PBC','','44016410152103','44016410152309','159939.00','0.00','0','0.00','0','0.00','0','0','998.00','','',NULL,NULL,'','bib123.jpg','','','','','','Mbib123.jpg','http://perseo.universum.unam.mx:8991','https://goo.gl/maps/AZU8NZtbieD2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (159,'Biblioteca. Escuela Nacional de Estudios Superiores. Unidad Len, Gto.','','','Licenciatura y Posgrado                                                                             ','2011','0','http://enes.unam.mx/?lang=es_MX',NULL,'ENESL','ENESL','','','','','','','','','','','','1635.00','','',NULL,NULL,'0','bib159.jpg','','','','0','0','Mbib159.jpg','http://biblioteca.enes.unam.mx:8991','https://goo.gl/maps/hUaNY8ehj2C2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (162,'Biblioteca. Escuela Nacional de Estudios Superiores. Unidad Morelia, Mich.','','','Licenciatura y Posgrado                                                                             ','2013','','http://www.enesmorelia.unam.mx/index.php/vida-universitaria/biblioteca/',NULL,'ENESM','ENESM','','','','','','','','','','','','819.00','Biblioteca ingresada en el directorio en 19 noviembre de 2015. DPLybf','',NULL,NULL,'','bib162.jpg','','','','','',NULL,'http://biblioteca.enesmorelia.unam.mx:8991','https://goo.gl/maps/C74mGXQ6f5q','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (70,'Biblioteca. Centro de Enseanza, Inv. y Ext. en Produccin Porcina','','','Licenciatura y Posgrado                                                                             ','1996','','http://www.fmvz.unam.mx/fmvz/centros/ceiepp/acerca.html','GEP','','P8C','','10014190552101','10014190552307','0','0.00','0','0.00','0.00','0.00','0.00','0.00','11.00','','',NULL,NULL,'','bib70.jpg','','','','','','Mbib70.jpg','http://bibliodigital.fmvz.unam.mx:8991','https://goo.gl/maps/EYqbLu1gyom','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (2,'Biblioteca "Guillermo Haro"','','','Investigacin Cientfica                                                                            ','1967','Sus colecciones se encuentran sistematizadas y automatizadas en diferentes mdulos de Automated Library Expandable Program (Aleph).$La coleccin hemerogrfica est constituida por revistas, boletines, reportes, anuarios nacionales y extranjeros algunas de estas revistas datan del siglo XIX, colecciones que se siguen adquiriendo como es el caso de: Astrophysical Journal 1895- , Monthly Notices of the Royal Astronomical Society, 1886- , Publications of the Astronomical Society of the Pacific, 1890- entre otras, 1266 microfichas que corresponden a 4 ttulos de revistas, 1979 cartas del cielo y una coleccin especial de 385 libros antiguos del siglo XIX.$Informacin proporcionada por: Lic. Vernica Mata Acosta.','http://www.astroscu.unam.mx/IA/index.php?option=com_content&view=article&id=21&Itemid=46&lang=es','A','','P02','','31203120152105','31203120152301','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','375.00','','',NULL,NULL,'','bib02.jpg','','','','','','Mbib02.jpg','http://132.248.230.114:8991','https://goo.gl/maps/vozXFrjtHCK2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (72,'Biblioteca. Instituto de Ciencias Fsicas','','','Investigacin Cientfica                                                                            ','1987','','http://www.fis.unam.mx/biblioteca.php','GF1','','PDE','','31023110752102 $31033110752105 $31043110752108','31203110752306','0','0','0','0.00','0','0.00','0','0','206.00','','',NULL,NULL,'','bib72.jpg','','','','','','Mbib72.jpg','http://leona.fis.unam.mx:8991','https://goo.gl/maps/Rxy1ZfVYPiF2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (120,'Biblioteca "Marcos Rosenbaum"','','','Investigacin Cientfica                                                                            ','1969','1969 ','http://sigi.nucleares.unam.mx/uib/site/index','NC','','P01','','31203270152103','31203270152309','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','776.00','','',NULL,NULL,'','bib120.jpg','','','','','','Mbib120.jpg','http://xochitl.nucleares.unam.mx:8991','https://goo.gl/maps/yFL39FwGeDo','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (13,'"Biblioteca Conjunta de Ciencias de la Tierra"','','','Investigacin Cientfica                                                                            ','1997','La Biblioteca Conjunta de Ciencias de la Tierra (BCCT) se encuentra conformada por los recursos documentales, humanos, econmicos y materiales de cinco dependencias de investigacin, las cuales son los Institutos de Geologa, Geofsica y Ciencias del Mar y Limnologa, as como los Centros de Ciencias de la Atmsfera y Geociencias (en Juriquilla, Qro.). contando con bibliotecas en las Unidades Acadmicas de Hermosillo, Son., Mazatln, Sin., El Carmen, Camp. y Puerto Morelos, Q. Roo, ofreciendo servicios adems a los buques universitarios Justo Sierra y PUMA.$La BCCT fue inaugurada oficialmente en diciembre de 2005. Desde sus inicios unific fsicamente sus colecciones en Ciudad Universitaria en un solo local y desarrollando y fortaleciendo las propias en las unidades acadmicas en provincia, las cuales forman parte activa de la BCCT pero trabajando bajo la estructura organizacional de la unidad a la que pertenecen y explotando los servicios electrnicos generados por la Biblioteca Conjunta en CU y los creados exprofeso para los acadmicos que en ellas laboran.$La coordinacin general de la BCCT se encuentra en el Campus Universitario y cada biblioteca de las Unidades Acadmicas cuenta con un jefe o responsable de la misma, siendo autnomas en la prestacin de los servicios y reglamentacin, realizando el desarrollo de sus colecciones con el apoyo directo de la biblioteca principal en Ciudad Universitaria, que permite evitar la duplicidad de materiales.$El Campus Universitario en la Ciudad de Mxico ha sido su sede original desde la fecha de su creacin, contando con tres remodelaciones a lo largo de los ltimos diez aos, para la creacin de la mapoteca y de oficinas.$Informacin proporcionada por: Lic. Sal Armendriz Snchez.',' http://bcct.unam.mx ','BCCT','','','','','','0.00','0.00','0.00','0.00','0','0.00','0','0','1859.00','','',NULL,NULL,'','bib13.jpg','','','','','','Mbib13.jpg','http://132.248.182.16:8991','https://goo.gl/maps/5dwmWq2BygH2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (155,'"Biblioteca del Campus Juriquilla"','','','Investigacin Cientfica                                                                            ','2007','El Campus Juriquilla, Quertaro data de 1996 y es resultado de un proyecto para contribuir a la descentralizacin de las actividades de investigacin cientfica, de educacin superior, desarrollo tecnolgico y formacin de recursos humanos en la Regin del Bajo.$Debido al crecimiento de las actuales  dependencias del Campus: Centro de Fsica Aplicada y Tecnologa Avanzada (CFATA), Centro de Geociencias (CGEO), Instituto de Neurobiologa (INB), la Unidad de Neurodesarrollo y de Resonancia Magntica y la Coordinacin de Servicios Administrativos (COSJ), el Consejo de Direccin del Campus consider que las entonces tres ex Bibliotecas pertenecientes a las dependencias de investigacin antes mencionadas, y que presentaban una saturacin en sus espacios, se integraran al proyecto del Centro Acadmico y Cultural (CAC), lo que dio por resultado la  fusin de las colecciones y el personal de las mismas en un nico espacio, buscando optimizar sus recursos.$El 24 de Noviembre del 2006 se inaugur la Biblioteca del Campus Juriquilla, la cual forma parte del  CAC, conformado por diversos espacios de uso comn como el Teatro-Auditorio, la Unidad de Docencia y Seminarios, as como una Cafetera. El proyecto de diseo y construccin del CAC estuvo a cargo de la Direccin de Proyectos Especiales de la UNAM, y arranc en octubre del 2005 para finalizar en noviembre del 2006. La Biblioteca tiene una superficie total de 1,306.86 m2 de construccin.$Informacin proporcionada por: Pilar Galarza Barrios.','http://www.biblioteca.juriquilla.unam.mx/','BCJ',NULL,NULL,'','','','','','','','','','','','1478.00','','',NULL,NULL,'','bib155.jpg','','','','','',NULL,'http://132.248.248.1:8991','https://goo.gl/maps/mudgSTkd9NF2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (30,'Biblioteca. Centro de Ciencias Aplicadas y Desarrollo Tecnolgico','','','Investigacin Cientfica                                                                            ','1971','En 1971 es fundada como Centro de Instrumentos (C.I.).$En 2002 cambia de nombre a Centro de Ciencias Aplicadas  y Desarrollo Tecnolgico (CCADET).$El Edificio donde se encuentra actualmente la Biblioteca fue construido en 1999 para tal fin, el cual cuenta con espacios adecuados y con servicios propios de una Biblioteca Especializada, la cual conforma el Sistema Bibliotecario de la UNAM, para cubrir de manera directa las necesidades de informacin de los usuarios.$Informacin proporcionada por: Lic. Mara Roco Bastida Garca.','http://www.ccadet.unam.mx/secciones/bibli/biblio.html','CK','','P32','','31013110552105 $31023110552108 $31033110552101','31023110552304, 31033110552307, 31043110552300','0','0.00','0','0.00','0','0.00','0','0','318.00','','',NULL,NULL,'','bib30.jpg','','','','','','Mbib30.jpg','http://biblio192.dgbiblio.unam.mx:8996','https://goo.gl/maps/FUArutv3GrG2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (24,' Biblioteca. Centro de Ciencias Genmicas','','','Investigacin Cientfica                                                                            ','1981','','http://www.ccg.unam.mx/es/biblioteca','CFN','','P24','','31203110352102','31203110352308','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','144.00','La biblioteca del Centro de Ciencias Genmicas (CCG) e Instituto de Biotecnologia (IBT) funciona temporalmente en las instalaciones de la biblioteca del Instituto de Ciencias Fsicas (IFC) a partir de enero de 2013. Solo dispone de acervo de libros impresos, las revistas se encuentran en  bodega. 21mayo2013  DPLybf','',NULL,NULL,'','bib24.jpg','','','','','','Mbib24.jpg','http://biblioteca.ccg.unam.mx:8991','https://goo.gl/maps/s1Z2v65U92H2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (158,'Unidad de Documentacin','','','Investigacin Cientfica                                                                            ','1991','','http://www.matmor.unam.mx/documentacion/','GM1','','P35','','31023190252103','31023190252309','0','0.00','0','0.00','0','0.00','0.00','0','110.00','NUEVO NOMBRAMIENTO: Unidad de Documentacin. Comunicado 20 septiembre 2012. DPLybf','El IM en campus Morelia se transforma en Centro de Ciencias Matemticas por Acuerdo del Rector en septiembre de 2011. DPLybf',NULL,NULL,'','bib158.jpg','','','','','','Mbib158.jpg','http://alephmor.matmor.unam.mx:8995','https://goo.gl/maps/CgU2biBE2tp','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (121,'Biblioteca "Juan Ruz de Alarcn"','','','Extensin y Administracin Universitaria                                                            ','1992','','http://www.cepetaxco.unam.mx/biblioteca/','NT','','','','','43206130152302','0.00','0.00','0','0.00','0.00','0.00','0.00','0.00','69.00','','',NULL,NULL,'','bib121.jpg','','','','','','Mbib121.jpg','http://biblioteca.cepe.unam.mx:8991','https://goo.gl/maps/L2kpb5a188Q2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (150,'Biblioteca del Campus Juriquilla','','','Investigacin Cientfica                                                                            ','1999','','http://www.biblioteca.juriquilla.unam.mx/BCJ.htm','GF3',NULL,'GF3','','','','0','','0','0','0','0','0','0','0.00','','',NULL,NULL,'','bib150.jpg','','','','','','Mbib150.jpg','http://132.248.248.1:8991','https://goo.gl/maps/mudgSTkd9NF2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (89,'Biblioteca del Campus Juriquilla','','','Investigacin Cientfica                                                                            ','1998','','http://www.geociencias.unam.mx/geociencias/infraestructura/biblioteca.html','I3','','P0C','','31023110352104','00000','0','0.00','0.00','0.00','0.00','0.00','0','0','0.00','','',NULL,NULL,'','bib89.jpg','','','','','','Mbib89.jpg','http://132.248.248.1:8991','https://goo.gl/maps/mudgSTkd9NF2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (92,'Departamento de Informacin y Documentacin ','','','Investigacin en Humanidades                                                                        ','1986','El 20 de enero de 1986 se cre el Centro de Investigaciones Interdisciplinarias en Humanidades (CIIH) con la fusin de los recursos del Programa Universitario Justo Sierra y el Centro de Estudios sobre los Estados Unidos de Norteamrica, bajo esas condiciones se integr el acervo de la biblioteca. A partir del 28 de abril del 1995, por acuerdo del Consejo Universitario, se asign al CIICH la tarea de ampliar sus funciones enfocadas a las ciencias sociales y las humanidades, para incorporar de manera institucional a las dems disciplinas cientficas. Por esta razn desde entonces se denomina Centro de Investigaciones Interdisciplinarias en Ciencias y Humanidades (CEIICH). Desde su integracin las polticas para incrementar los acervos e implementar los servicios bibliotecarios del Departamento de Informacin y Documentacin se han diseado para apoyar el trabajo acadmico y los programas de investigacin que se llevan a cabo la comunidad de este Centro. El Departamento de Informacin y Documentacin tiene como objetivo fomentar el desarrollo de sus colecciones, preservarlas y difundirlas de acuerdo con las necesidades de los programas de investigacin que se llevan a cabo en el CEIICH, adems de facilitar, promover y actualizar los procesos y las tareas relacionadas con el apoyo a las actividades de investigacin del propio Centro.  Programas de investigacin: Estudios Interdisciplinarios de Ciencia y Tecnologa Ciencias Sociales y Literatura, Ciudades y Gestin en el Mundo Actual: Gobiernos, Sociedad, Territorio y Pluriculturalidad, El Mundo en el Siglo XXI, Epistemologa de las Ciencias y Sistemas de Informacin y Comunicacin, Investigacin Feminista, Procesos de Democratizacin, Produccin de Bienes y Servicios Bsicos, Historia de la Ciencia, Derecho y sociedad, Prevencin de Conflictos y Negociacin, Prospectiva Global: Estudios de Futuros. Texto enviado por Leonor Garca Urbano','http://biblio.unam.mx:8170/index.php/la-biblioteca','IIH','','PDA','','32022110352100','32022110352306','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','225.00','','',NULL,NULL,'','bib92.jpg','','','','','','Mbib92.jpg','http://ceiich.ceiich.unam.mx:8991','https://goo.gl/maps/1dNZqmrd6Zv','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (90,'Biblioteca "Paul Kirchhoff"','','','Investigacin en Humanidades                                                                        ','1985','1985 Inicio actividades como Centro de Investigaciones Humansticas de Mesoamrica y el Estado de Chiapas (CIHMECH)','http://proimmse.unam.mx/cbiblioteca/index.php','IHM','','PE4','','32022210252106','32022210252302','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','167.00','Cambio de edificio en marzo-abril 2013. DPLybf','Cambio de denominacin de Programa a Centro. Mayo 2015. DPLybf',NULL,NULL,'','bib90.jpg','','','','','','Mbib90.jpg','http://201.122.222.105:8991','https://goo.gl/maps/DDwjwbhaNHJ2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (58,'Biblioteca "Rosa Cusminsky Mogilner"','','','Investigacin en Humanidades                                                                        ','1989','','http://biblio.unam.mx:8180/ ','EUA','','PEF','','32022110752108 $32212110752109','32022110752304','0','0.00','0','0.00','0','0.00','0','0','230.00','','',NULL,NULL,'','bib58.jpg','','','','','','Mbib58.jpg','http://biblios.super.unam.mx:8991','https://goo.gl/maps/1dNZqmrd6Zv','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (21,'Biblioteca "Simn Bolvar"','','','Investigacin en Humanidades                                                                        ','1980','La Biblioteca ',' http://www.cialc.unam.mx/biblioteca.html ','CEL','','P21','','32202110552102','32202110552308','0','0.00','0','0.00','0.00','0.00','0','0','460.00','','',NULL,NULL,'','bib21.jpg','','','','','','Mbib21.jpg','http://bolivar.cialc.unam.mx:8991','https://goo.gl/maps/1dNZqmrd6Zv','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (125,'Biblioteca "Rosario Castellanos"','','','Investigacin en Humanidades                                                                        ','1992','En 1984, con la creacin del Centro de Estudios de la Mujer (CEM), de la Facultad de Psicologa de la UNAM, se conform una unidad de informacin y documentacin dedicada a recopilar y organizar la informacin documental sobre mujeres a nivel nacional. $El acervo documental del CEM, creci gradualmente, a travs de: donaciones, compras y canjes, llegando a formarse una valiosa y original coleccin documental especializada en los Estudios de y sobre las Mujeres.$Con la creacin del Programa Universitario de Estudios de Gnero (PUEG) en 1992, el Centro de Informacin adquiri una mayor importancia, conformando a lo largo de los aos de vida de sta institucin, el acervo bibliogrfico y documental especializado en gnero ms importante en la Universidad y a nivel nacional. Adems, ha desarrollado una serie de servicios de informacin para atender la demanda estudiantil, as como la de investigacin y docencia que se realiza en la perspectiva de gnero.  $Tiempo despus, surgi la necesidad de dar un nombre a este centro de informacin. El nombre elegido fue: Biblioteca ','http://www.pueg.unam.mx/index.php/biblioteca','PEG','','P15','','45022110952108','45022110952304','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','89.00','','El PUEG se traslada  al 7o. piso de la Torre II de Humanidades en 1998. DPLybf',NULL,NULL,'','bib125.jpg','','','','','','Mbib125.jpg','http://biblioteca.pueg.unam.mx:8991','https://goo.gl/maps/1dNZqmrd6Zv','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (73,'Biblioteca. Centro de Nanociencias y Nanotecnologa','','','Investigacin Cientfica                                                                            ','1983','','http://www.cnyn.unam.mx/biblio/index.html','GF2','','PE1','','31023110652105','31023110652301','0','0.00','0','0.00','0.00','0.00','0.00','0.00','569.00','Cambio de edificio en febrero-marzo 2014. DPLybf','',NULL,NULL,'','bib73.jpg','','','','','','Mbib73.jpg','http://gigante.cnyn.unam.mx:8991','https://goo.gl/maps/ewECnjBPkHN2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (154,'Biblioteca. Centro Peninsular en Humanidades y Ciencias Sociales','','','Investigacin en Humanidades                                                                        ','2004','La biblioteca fue creada en julio de 2004, slo un mes despus de que la Unidad Acadmica de Ciencias Sociales y Humanidades, antecedente del CEPHCIS, se instalara en el edificio histrico que actualmente ocupa, el Ex - Sanatorio Rendn Peniche (estilo Neomaya, 1919). En un principio la biblioteca ocup el pabelln oeste mientras era restaurado y acondicionado el resto del inmueble. En junio de 2005, ya reconstruido la totalidad del edificio, la biblioteca se instala en el pabelln este, donde actualmente se encuentra.$El llamado fondo de origen de la biblioteca se constituy con los donativos que hicieron de sus publicaciones los institutos, centros y programas que conforman la Coordinacin de Humanidades, cerca de 1,200 volmenes de libros y 800 fascculos de revistas; en julio de 2006 se inicia la compra de libros y para el ao de 2007 se tramitan las primeras suscripciones a 16 ttulos de revistas impresas. En febrero de 2007 el Centro hace una importante adquisicin bibliogrfica al comprar la biblioteca particular del abogado Rodolfo Ruz Menndez, compuesta de libros, revistas, folletos y manuscritos, de los que sobresalen documentos relativos la historia de Yucatn, lengua maya, henequn, educacin, literatura, leyes, decretos y, textos escritos por autores yucatecos o autores forneos que escribieron sobre los estados que actualmente conforman la Pennsula de Yucatn; esta coleccin conforma el llamado Fondo Ruz Menndez.$Informacin proporcionada por: Lic. Ral Novelo Pea.','http://www.cephcis.unam.mx/index.php/biblioteca/','UCSY',NULL,'P18','','','','0','','0','0','0','0','0','0','365.00','','',NULL,NULL,'','bib154.jpg','','','','','','Mbib154.jpg','http://catalogo.cephcis.unam.mx:8991','https://goo.gl/maps/5JzbZhnLv5N2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (94,' Biblioteca "Dr. Francisco Lpez Cmara"','','','Investigacin en Humanidades                                                                        ','1985','1985 ','http://www.crim.unam.mx/drupal/?q=node/171','ISC','','PDB','','32022110652101','32022110652307','0','0.00','0','0.00','0.00','0.00','0.00','0.00','157.00','NOMBRAMIENTO DE LA BIBLIOTECA: Maestro Francisco Lpez Cmara. Comunicado 25 enero 2013. DPLybf','cambio septiembre 2013 de maestro a doctor a peticin de la responsable',NULL,NULL,'','bib94.jpg','','','','','','Mbib94.jpg','http://132.248.35.100:8991','https://goo.gl/maps/qJAEokH246R2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (48,'Biblioteca. Centro Universitario de Estudios Cinematogrficos','','','Extensin y Administracin Universitaria                                                            ','1963','OBJETIVOS$*  Apoyar los programas y proyectos docentes del CUEC, proporcionando el material adecuado y requerido por cada una de las reas acadmicas.$*  Seleccionar,  adquirir por compra, donacin o canje las obras bibliogrficas, videogrficas y hemerogrficas para su consulta,  y de cualquier otro material siempre y cuando est relacionado con el rea de la cinematografa, de acuerdo con los programas y proyectos de la docencia e investigacin del Centro Universitario de Estudios Cinematogrficos.$*  Organizar y preservar este acervo a fin de que permanezca en ptimas condiciones para su consulta.$*  Tomar las medidas pertinentes para  una mejor conservacin de mobiliario y  equipo de la biblioteca.$La biblioteca fue creada en 1974 y formalizada como tal a mediados de 1975.$Informacin proporcionada por: Gregoria Bustamante Rojas.','http://www.cuec.unam.mx/','DF3','','P66','','43206140152103','43206140152309','0','0.00','0','0.00','0.00','0.00','0','0','169.00','30.00 antes de 2013','',NULL,NULL,'','bib48.jpg','','','','','','Mbib48.jpg','http://biblioteca.cuec.unam.mx:8991','https://goo.gl/maps/zvUWFx8tDeu','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (38,'Biblioteca "Hctor Mendoza"','','','Extensin y Administracin Universitaria                                                            ','1994','En marzo del ao de 1994 se contaban con 500 ttulos aun sin ser registrados en Direccin General de Bibliotecas, para el mes de septiembre del mismo ao, se inaugura oficialmente la biblioteca con nombre de Hctor Mendoza contando con estantera cerrada. En este mismo ao se logra la adquisicin de material bibliogrfico y se inicia la captura de publicaciones peridicas, VHS, libretos y CDs.$Con el aumento del acervo se contempl un nuevo espacio a la biblioteca en el nuevo edificio (anexo) que fue inaugurado en marzo del 2005. Adems de aumentar al servicio una nueva seccin de digital video disc (DVD).$En el ao 2006 se instalan los servicios de Internet, Librunam y computo para el servicio de profesores y alumnos.$En el  mes de Junio del 2007 se instal el nuevo equipo de cmputo donado por DGB, y el uso de los programas  de Circula y Mantale para la administracin de los bienes de la biblioteca.$Informacin proporcionada por: Margarita Chvez Martn del Campo.','http://www.cut.unam.mx/  ','CUT','','','','43026150152102','','57065.00','0.00','0.00','0.00','0.00','0.00','0.00','8781.00','36.00','','',NULL,NULL,'','bib38.jpg','','','','','','Mbib38.jpg','http://biblio192.dgbiblio.unam.mx:8992','https://goo.gl/maps/XX9s4qg79U32','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (49,'Centro de Informacin. Coordinacin de Estudios de Posgrado','','','Extensin y Administracin Universitaria                                                            ','1992','',' http://www.posgrado.unam.mx/','CGP','','P6B','','11015130152100','','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','76.00','','La  Unidad de Posgrado cambia de denominacin a Direccin General de Estudios de Posgrado, gaceta 6 feb. 1997. DPLybf',NULL,NULL,'','bib49.jpg','','','','','','Mbib49.jpg','http://biblio192.dgbiblio.unam.mx:8998','https://goo.gl/maps/WpTJ6cvjUVt','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (136,'Centro de Documentacin','','','Extensin y Administracin Universitaria                                                            ','0','En 1997 el Centro de Documentacin adquiere mayor importancia y gracias a la remodelacin de las instalaciones, el acervo bibliogrfico se traslad a las instalaciones actuales en 1998, lo que ha facilitado el crecimiento y diversificacin de la coleccin bibliogrfica.$En septiembre de 2000 se firma el Acta Constitutiva del Comit del Centro de Documentacin de la CUAED (denominado Comisin de Biblioteca) y se procede a designar a los miembros que lo integran, quienes asumen, entre sus funciones, la de sugerir las polticas de desarrollo y crecimiento del acervo, as como la definicin del Reglamento de dicho Centro.$Actualmente el Centro de Documentacin cuenta con la informacin automatizada de todo su acervo bibliogrfico especializado en temas afines a la educacin abierta, continua, a distancia y nuevas tecnologas.  El material se encuentra en idioma espaol e ingls.$Informacin proporcionada por: Lic. Mara Guadalupe Rojo Czares.','http://biblioteca.cuaed.unam.mx/','UA','','','','15014810152103 $43024810252108','00000','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','35.00','Ampliacin y remodelacin de la biblioteca  del 2 de marzo a 16 de agosto. Reapertura el 17 de agosto 2015. DPLybf.','',NULL,NULL,'','bib136.jpg','','','','','','Mbib136.jpg','http://biblio.cuaed.unam.mx:8991','https://goo.gl/maps/cp59StG3yGt','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (153,'Biblioteca. Centro de Alta Tecnologa de Educacin a Distancia','','','Extensin y Administracin Universitaria                                                            ','2004','','http://biblioteca.cuaed.unam.mx/localizacion.html','UA1',NULL,'UA1','','','','0','','0','0','0','0','0','0','117.00','','',NULL,NULL,'','bib153.jpg','','','','','','Mbib153.jpg','http://catedaleph500.cuaed.unam.mx:8991','https://goo.gl/maps/sAACEd6KGdL2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (64,'Biblioteca. Direccin General de Actividades Cinematogrficas','','','Extensin y Administracin Universitaria                                                            ','1981','','http://www.filmoteca.unam.mx/pages/servicios/centro-de-documentacion','FU','','P86','','41206230152103','41206230152309','0','0.00','0','0.00','0.00','0.00','0','0','429.00','','',NULL,NULL,'','bib64.jpg','','','','','','Mbib64.jpg','http://dgb1.dgac.unam.mx:8991','https://goo.gl/maps/HSF95Fr6DL72','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (50,'Biblioteca "Dr. Lzaro Benavides Vzquez"','','','Extensin y Administracin Universitaria                                                            ','1975','','http://www.dgsm.unam.mx/biblioteca.html','DM','','P6E','','18205630152108','18205630152304','0','0.00','0','0.00','0.00','0.00','0','0.00','43.00','','',NULL,NULL,'','bib50.jpg','','','','','','Mbib50.jpg','SIN CATLOGOS','https://goo.gl/maps/2QK5TiDeSQr','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (12,'"Biblioteca Central"','','','Extensin y Administracin Universitaria                                                            ','1956','El 5 de abril de 1956, la Biblioteca Central abri sus puertas y espacios a la comunidad de la Universidad Nacional Autnoma de Mxico (UNAM). El edificio que alberga la Biblioteca Central tuvo como propsito original servir de sede a la Biblioteca y Hemeroteca Nacionales. Contaba con un acervo de 80,000 volmenes: 20,000 adquiridos ex profeso para ella, 60,000 provenientes del Departamento Tcnico de Bibliotecas.$La primera remodelacin (1981-1983) tuvo como objetivo: la interaccin de los usuarios con las colecciones. Los principales fueron: redistribucin del acervo y servicios a los usuarios en el edificio; el acceso de los usuarios a las colecciones y nuevo horario de servicio.$La automatizacin de los servicios (1986).$En el ao 2000 se realiza una segunda remodelacin y distribucin del acervo en la Biblioteca, se ampla el horario de servicio de 8:30 hrs. a 21:30 hrs. y se crea la videoteca.$En el 2003 se remodela la Sala de Consulta y se ampla la seccin de recursos electrnicos de informacin con ms equipos y nueva rea de servicio en el entrepiso.$En el 2006, en el primer piso se acondiciona la sala modelo de acervos y videoteca; en el basamento se concluye la sala de videoconferencias y de educacin a distancia. Para el ao 2007, se genera un nuevo servicio en el jardn interior de la biblioteca denominado jardn ciberntico donde se  instalaron cinco mesas con conexiones elctricas y red inalmbrica.$Informacin proporcionada por: Lic. Gloria Adriana Hernndez Snchez.','http://bibliotecacentral.unam.mx/','BC','','P10','','18205640152105','18205640152301','0','0','0','0','0','0','0','0','10066.00','*De acuerdo a un anlisis a la estructura orgnica de la DGB, a partir de 15 febrero de 2002, la Subdireccin de  de Servicios bibliotecarios cambiar de denominacin a Subdireccin de Biblioteca Central. periodo directora Silvia Gonzlez Marin. DPLybf','',NULL,NULL,'','bib12.jpg','','','','','','Mbib12.jpg','http://informatica.dgbiblio.unam.mx:8991','https://goo.gl/maps/rtCcFRPoJVv','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (26,'Departamento de Informacin y Servicios Documentales','','','Extensin y Administracin Universitaria                                                            ','1971','Se crea en 1972, tiene sus orgenes con el Centro de Informacin Cientfica y Humanstica (CICH) como Departamento de Biblioteca. Cabe mencionar que a partir de 1997 el antes CICH pertenece a la Direccin General de Bibliotecas, cambiando a Unidad de Informacin Cientfica y Humanstica-DGB, despus se le nombr Subdireccin de Servicios Especializados-DGB; el 10 de enero de 2006  su nuevo nombre  es Subdireccin de Servicios de Informacin Especializada-DGB. Por otra parte el Depto. de Biblioteca a partir de 2002 cambia a Departamento de Informacin y Servicios Documentales perteneciente a dicha Subdireccin.$De 1972 a 1976 se ubico en las oficinas de la DGOSE, de noviembre de 1976 a la fecha ha permanecido en el rea de la investigacin cientfica sin cambios; con una ampliacin, en la planta baja (antes imprenta), para reacomodar la coleccin de ndices y abstracts.$Desde octubre 2005 se tiene el nuevo servicio de informacin especializada Inforvm para el sector externo en: http://inforum.unam.mx/$Informacin proporcionada por: Mtro. Federico Russell Turnbull Muoz.','http://bidi.unam.mx/web/dgbsite/serv_info_esp.htm ','CI','','P2A','','36205640152103','','0','0.00','0.00','0.00','0.00','0.00','0','0','296.00','','',NULL,NULL,'','bib26.jpg','','','','','','Mbib26.jpg','SIN CATLOGOS','https://goo.gl/maps/V8FNtjJcdA62','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (129,'Biblioteca. Direccin General de Cmputo y de Tecnologas de Informacin y Comunicacin','','','Extensin y Administracin Universitaria                                                            ','1985','1985 ','http://bibliotecas.tic.unam.mx/','PUC','','PC3','','18015220152108 $18025220152101 $36035220152102 ','','0','0.00','0.00','0.00','0.00','0.00','0','0','170.00','','LA biblioteca  DGSCA Coapa, inicia sus labores el 11 de junio de 2001, para 20.. se da de baja en el SIBIUNAM. DPL.',NULL,NULL,'','bib129.jpg','','','','','','Mbib129.jpg','http://132.248.168.125:8991','https://goo.gl/maps/BVrEWn5WuWF2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (130,'Biblioteca. Centro de Extensin Nuevo Len','','','Extensin y Administracin Universitaria                                                            ','1992','La Biblioteca del Centro de Extensin en Cmputo y Telecomunicaciones Nuevo Len es una de las cuatro que forman el conjunto de bibliotecas de la Direccin General de Servicios de Cmputo Acadmico (DGSCA).$La Biblioteca en sus 59 m2 alberga una coleccin especializada en cmputo y telecomunicaciones seleccionada con un alto nivel de actualizacin para apoyar al Centro en la imparticin de cursos sobre ms de 200 tpicos diferentes organizados en 19 reas temticas, abarcando desde temas introductorios hasta avanzados.$Sus servicios estn dirigidos a docentes, alumnos de los cursos, personal de la DGSCA y pblico en general para satisfacer sus necesidades de informacin y documentacin.$Informacin proporcionada por: Lic. Xchitl Aguilar Gonzlez.','http://bibliotecas.tic.unam.mx/conocenos.html','PUC1','','P5D','','43055220152106','','72016.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','59.00','','',NULL,NULL,'','bib130.jpg','','','','','','Mbib130.jpg','http://132.248.168.125:8991','https://goo.gl/maps/pqTcWFc83372','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (131,'Biblioteca. Centro de Extensin Mascarones','','','Extensin y Administracin Universitaria                                                            ','1995','En noviembre de 1994 se crea el Centro Mascarones que es una extensin multidisciplinaria. A unos aos de su apertura se inician los preparativos para la biblioteca necesaria para la investigacin del Centro.$En 1995 se inician actividades la Biblioteca del Centro Mascarones. En este primer ao el acervo estuvo orientado a la temtica de la computacin.$En 1996 se incorpora una pequea coleccin del Centro de Enseanza de Lenguas Extranjeras (CELE), en calidad de resguardo, con el propsito de atender a los usuarios que asisten a los cursos de idiomas impartidos en esta sede.$En 1997 el catlogo en lnea est disponible en World Wide Web a travs del programa Aleph. Al igual que la biblioteca de la DGSCA incorporan las colecciones electrnicas en los aos 2002 y 2003.$La BCM es una biblioteca especializada en cmputo e idiomas, aunque el acervo de sta ltima especialidad es mnimo, pues la coleccin es provista por el CELE, institucin que se aloj ms recientemente en este centro, y el sostenimiento de la biblioteca corre a cargo de la DGSCA.$Informacin proporcionada por: Lic. Erndira Montiel Calzadilla.','http://bibliotecas.tic.unam.mx/conocenos.html','PUC2','','PF7','','43065220152109','','72016.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','66.00','','',NULL,NULL,'','bib131.jpg','','','','','','Mbib131.jpg','http://132.248.168.125:8991','https://goo.gl/maps/ixWecmpxw5S2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (109,'Biblioteca "Jorge Carpizo"','','','Extensin y Administracin Universitaria                                                            ','1981','','http://biblio192.dgbiblio.unam.mx:8999/F','LU','','PAE','','55027310152100 $55037310152103','55037310152309','0','0.00','0','0.00','0.00','0.00','0','0','106.00','','',NULL,NULL,'','bib109.jpg','','','','','','Mbib109.jpg','http://biblio192.dgbiblio.unam.mx:8999','https://goo.gl/maps/U8sK38eci9H2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (53,'Departamento de Acervo y Documentacin','','','Extensin y Administracin Universitaria                                                            ','1985','OBJETIVO$*  Ofrecer  alternativas de consulta a los productores de TV-UNAM para complementar sus contenidos en la realizacin de programas de televisin. De igual forma, ofrecer a la comunidad universitaria y al pblico en general los materiales bibliogrficos que se tienen, relacionados con los medios audiovisuales y las ciencias de la comunicacin.$HISTORIA$Anteriormente el acervo bibliogrfico se encontraba adscrito a la Subdireccin de Comunicacin, dentro del Departamento de Acervo y documentacin y se contaba con una pequea oficina en donde estaban agrupados los materiales. Desde el 2007, se encuentra adscrito a la Subdireccin de Programacin, e igualmente dentro del departamento de acervo y documentacin, contando con un rea exclusiva para su acomodo, resguardo y consulta.$Informacin proporcionada por: Enrique Dvila Diez.',' http://www.tvunam.unam.mx/ ','DTU','','PE3','','44016530152100','44026530152309','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','36.00','','',NULL,NULL,'','bib53.jpg','','','','','','Mbib53.jpg','SIN CATLOGOS','https://goo.gl/maps/Fa9Pod2PZKm','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (47,'Centro de Documentacin del Deporte y la Recreacin ','','','Extensin y Administracin Universitaria                                                            ','1978','','http://deporte.unam.mx/biblioteca/','DD','','P61','','43065620152101','43065620152307','0','0.00','0','0.00','0.00','0.00','0.00','0.00','120.00','','',NULL,NULL,'','bib47.jpg','','','','','','Mbib47.jpg','http://deportivas.dgadyr.unam.mx:8991','https://goo.gl/maps/mPRDmoQUyZw','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (19,'Biblioteca. Escuela Nacional Colegio de Ciencias y Humanidades. Direccin General','','','Bachillerato                                                                                        ','1972','Con la creacin del Colegio de Ciencias y Humanidades en 1971 nace la Biblioteca de la Direccin General del Colegio de Ciencias y Humanidades.$La biblioteca cuenta con un acervo dirigido a profesores, funcionarios y dems personal interesado en conocer el bachillerato de la UNAM, por lo que sus ttulos estn orientados, principalmente, a educacin y pedagoga. El acervo incluye el Centro de Documentacin Acadmica (CDA), que desde su creacin en febrero de 1979, est dedicado a organizar y resguardar los productos acadmicos elaborados por los profesores de carrera del Colegio.$Su primer sede estuvo en avenida Universidad 3000, en lo que era  la Unidad Acadmica del Ciclo del Bachillerato del Colegio de Ciencias y Humanidades (UACB), hoy Escuela Nacional Colegio de Ciencias y Humanidades.SAcadmicamente dependa de la Secretara General del Colegio, posteriormente a la Secretara Acadmica, y hoy da a la Secretara de Servicios de Apoyo al Aprendizaje; su funcin sustantiva es apoyar la educacin universitaria.$Informacin proporcionada por: Profa. Cristina Altamirano Velazco.',' http://www.cch.unam.mx/aprendizaje/bibliotecas','CCH','','P1D','','24014720152101 $24024720152104 $24034720152107','','0','0.00','0.00','0.00','0.00','0.00','0.00','0.00','53.00','Nueva ubicacin de la biblioteca a partir de 2014 en Av. Universidad 3000. DPLybf. Espacio antes de 2012 = 96, espacio a partir de 14 de enero de 2012= 164.$CAMBIO DE LUGAR :la biblioteca ocupa un espacio dentro del edificio de CCH ubicado en  Av. Universidad No. 3000, primer piso. DPLybf 10/2/15 con 52 m2','',NULL,NULL,'','bib19.jpg','','','','','','Mbib19.jpg','http://biblioteca.cch-sur.unam.mx:8991','https://goo.gl/maps/nekTfsDkwft','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (40,'Biblioteca. Escuela Nacional Colegio de Ciencias y Humanidades. Plantel Azcapotzalco','','','Bachillerato                                                                                        ','1981','','http://www.cchazc.unam.mx/?page_id=166 ','CYHB','','P47','','21204720252100','21204720252306','0','0.00','0','0.00','0.00','0.00','0','0','2538.00','','',NULL,NULL,'','bib40.jpg','','','','','','Mbib40.jpg','http://biblioteca.cchazc.unam.mx:8991','https://goo.gl/maps/aFk4TJK5HRD2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (39,'Biblioteca. "Dr. Ignacio Renero Ambros"','','','Bachillerato                                                                                        ','1971','La biblioteca del Colegio de Ciencias y Humanidades Plantel Naucalpan comienza a funcionar poco tiempo despus de la fundacin del Colegio en 1971. En un principio su acervo esta dividido y resguardado en 2 edificios distintos: La coleccin para uso de los docentes se ubicaba en el Edificio del PEC y la coleccin general comparta espacio con la sala de Usos mltiples y Teatro, en el edificio que actualmente ocupa Audiovisuales. Los servicios que ofreca era Consulta, Hemeroteca, Consulta en Sala y Prstamo  a domicilio. La estantera era cerrada.  Conforme fueron creciendo el acervo y los servicios se vio la necesidad de contar con un edificio propio, el cual fue inaugurado en el ao de 1981 y en el que sigue funcionando a la fecha. Los servicios que se ofrecen son: Estantera abierta (desde 1991), sala de lectura, Consulta, Hemeroteca, Prstamo a domicilio automatizado, catalogo en lnea y sala computo para maestros. El acervo esta conformado 17103 ttulos y 182897 ejemplares, entre libros, revistas, peridicos, CD y mapas. Es a partir de agosto de 2005, que la biblioteca lleva el nombre de ','http://www.cch-naucalpan.unam.mx/index.php','CYHA','','P46','','21014720352106','21204720352303','0','0.00','0','0.00','0.00','0.00','0','0','1897.00','','',NULL,NULL,'','bib39.jpg','','','','','','Mbib39.jpg','http://biblioteca.cch-naucalpan.unam.mx:8991','https://goo.gl/maps/FNAUB5Kp2Zy','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (42,'Biblioteca. Escuela Nacional Colegio de Ciencias y Humanidades. Plantel Sur','','','Bachillerato                                                                                        ','1972','','http://www.cch-sur.unam.mx/#','CYHD','','P49','','21014720652107 $21024720652100 $21034720652103','21204720652304','0','0.00','0','0.00','0.00','0.00','0','0.00','2780.00','','',NULL,NULL,'','bib42.jpg','','','','','','Mbib42.jpg','http://biblioteca.cch-sur.unam.mx:8991','https://goo.gl/maps/gxvWATZnEsA2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (41,'Biblioteca. Escuela Nacional Colegio de Ciencias y Humanidades. Plantel Vallejo','','','Bachillerato                                                                                        ','1971','','http://www.cch-vallejo.unam.mx/','CYHC','','P48','','21204720452104','21204720452300','0','0.00','0','0.00','0.00','0.00','0.00','0','2569.00','','',NULL,NULL,'','bib41.jpg','','','','','','Mbib41.jpg','http://biblioteca.cch-vallejo.unam.mx:8991','https://goo.gl/maps/ggUeyMGSRKw','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (148,'Biblioteca "Graciela Arroyo de Cordero"','','','Licenciatura y Posgrado                                                                             ','1952','1952 Misin: ','http://www.eneo.unam.mx/alumnos/biblioteca_enfermeria.php','HB','','P93','','10204340152105','10204340152301','0','0.00','0','0.00','0.00','0.00','0','0','1088.00','Gaceta 12 abril de 2004 se le asigna el nombre de Graciela Arroyo a la biblioteca. DPLybf','',NULL,NULL,'','bib148.jpg','','','','','','Mbib148.jpg','http://eneo-a500.eneo.unam.mx:8991','https://goo.gl/maps/szKHvWhThfN2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (31,'Biblioteca "Stephen A. Bastien"','','','Licenciatura y Posgrado                                                                             ','1980','En 1979 se instala la biblioteca e inicia el servicio de prstamo, con un acervo de 5000 volmenes aproximadamente. El acervo original proviene de las donaciones realizadas por las embajadas de Alemania, Francia, Estados Unidos y el Consejo Britnico, de los materiales que se encontraban en los cubculos de los profesores y de las adquisiciones  realizadas por el proyecto  de la maestra en lingstica aplicada de la Unidad Acadmica de los Ciclos Profesional y Posgrado del CCH.$En 1980 la biblioteca abre sus puertas al pblico, ofrece los servicios de prstamo interno, a domicilio e interbibliotecario. Ms tarde en 1984 la biblioteca se trasladada a un local adaptado en el edificio A del CELE. El 14 de mayo de ese ao el Consejo Asesor del CELE acord nombrar a la biblioteca ','http://cele.unam.mx/index.php?categoria=15','CL','','P33','','11206120152102','11206120152308','0','0.00','0','0.00','0.00','0.00','0','0','535.00','','',NULL,NULL,'','bib31.jpg','','','','','','Mbib31.jpg','http://catalogo.cele.unam.mx:8991','https://goo.gl/maps/1xTi2Ctwi2J2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (135,'Centro de Informacin y Servicios Bibliotecarios','','','Licenciatura y Posgrado                                                                             ','1972','En 1972 la alumna Mara del Carmen Mendoza Rangel inici el trabajo de recoleccin y ordenamiento de materiales. En 1973 Jos Humberto Caballero Miranda, egresado de la carrera, asume la tarea de organizar el servicio de prstamo y en 1976 se le designa como primer Coordinador de Biblioteca.$La biblioteca inici con materiales nacionales y temas mdicos y jurdicos, los de la especialidad provenan del exterior. Con la licenciatura, pronto se enriqueci con otras reas del conocimiento.$En 1972 da servicio en un cubculo del Anexo de la Facultad de Derecho. De 1973 a 1980 funciona en el hoy edificio ','http://www.trabajosocial.unam.mx/dirs/biblioteca/biblioteca.html','TS','','PD2','','10014360152108 $10204360152109','10204360152305','0','0.00','0','0.00','0.00','0.00','0','0','984.00','','',NULL,NULL,'','bib135.jpg','','','','','','Mbib135.jpg','http://www.cisbents.unam.mx:8991','https://goo.gl/maps/veeUaFW3cRp','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (100,'Biblioteca "Mtro. Antonio Caso"','','','Bachillerato                                                                                        ','1979','Sus labores se inauguran el 03 de febrero de 1868, en el venerable y monumental edificio del antiguo colegio de San Ildefonso, por lo que ah es donde se forma la primera Biblioteca de la UNAM.$El 08 de diciembre de 1980, se inauguran las nuevas instalaciones de la Preparatoria N 1, campus Xochimilco.$En su coleccin, la biblioteca cuenta con materiales en diferentes formatos como CD, CD-ROOM, VHS, Diapositivas, Publicaciones peridicas, Cassetes, etc.$Informacin proporcionada por: Graciela Flores Pacheco.','http://biblio.unam.mx:8010','L1','','PA4','','21204520152107','21204520152303','0','0.00','0','0.00','0.00','0.00','0','0','2062.00','','',NULL,NULL,'','bib100.jpg','','','','','','Mbib100.jpg','http://biblio1.prepa1.unam.mx:8991','https://goo.gl/maps/y4YJsZVPZUJ2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (99,'Biblioteca. Escuela Nacional Preparatoria. Direccin General','','','Bachillerato                                                                                        ','1950','La biblioteca tiene sus inicios en la dcada de los aos 60`s en la calle de Justo Sierra 16 Col. Centro, posteriormente en los aos 80`s es trasladada a las instalaciones de Difusin Cultural de la DGENP, en la calle de San Ildefonso 30 Col. Centro. La siguiente  reubicacin tiene lugar en el ao 2001 a la planta baja del edificio donde actualmente se sita la DGENP Adolfo Prieto 722 Col. Del Valle delegacin Benito Jurez.$La biblioteca de la DGENP forma parte de 10 bibliotecas que conforman el subsistema bibliotecario de la Escuela Nacional Preparatoria y  tiene como objetivo fundamental ofrecer espacios para apoyar las actividades acadmicas y de difusin de la cultura de la comunidad preparatoriana.$Sus acervos se actualizan con base a lo requerido por los Planes y Programas de Estudio de la ENP, las necesidades reales de los miembros de la comunidad acadmica y las solicitudes que se generan en la Muestra Bibliogrfica y Videogrfica de la ENP.$La biblioteca cuenta con una sala de lectura con amplios espacios, luz y ventilacin natural, catlogos en lnea y estantera abierta, permitiendo as al lector una estada amena y confortable, el orden que predomina en la biblioteca facilita el poder identificar y localizar los materiales de manera fcil y rpida.$Informacin proporcionada por: C.D. Ral Roberto Marichi Rodrguez.','http://biblio.unam.mx:8100/','L','','PA3','','24204510152109','24204510152305','0.00','0.00','0.00','0.00','0.00','0.00','0','0.00','151.00','Remodelacin de la biblioteca en 2012. DPLybf','En diciembre de 1993 dio inicio a la construccin de las nuevas bibliotecas de los planteles 4, 7 y 9 cuyo trmino se tiene programado par diciembre 1994. Gaceta 7 julio 1994 DPLybf',NULL,NULL,'','bib99.jpg','','','','','','Mbib99.jpg','http://biblio192.dgbiblio.unam.mx:8993','https://goo.gl/maps/uNRiGcviM7K2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (103,'Biblioteca "Prof. Ral Martnez y Rosas"','','','Bachillerato                                                                                        ','1979','La biblioteca ha existido desde el ao de 1943. En la administracin del Lic. Ral Pons Ortiz (1951-1958) ocup el espacio llamado anexo, en las calles de Primo Verdad y Guatemala del centro histrico de la Ciudad de Mxico.$En 1978 la biblioteca  se traslada a sus actuales instalaciones, ocupando un espacio de 400 m2.$En 1982 se realiza la primera remodelacin que consisti en la construccin de un mezanine y la eliminacin  de salones donde se impartan clases, aumentando en un 25 por ciento su superficie.$Tuvo una segunda remodelacin en el ao 1990, que consisti en la eliminacin de muros, implementndose el  servicio de estantera abierta.$En 1992 se comienza la automatizacin del servicio de prstamo, por medio del  sistema circula.Es la primer biblioteca de las preparatorias en que se comienza a usar el cdigo de barras en las credenciales de los usuarios y el cdigo en los libros, haciendo ms rpido y efectivo el servicio.$La tercera remodelacin se da en el ao 2004, consistiendo en la construccin de un edificio de 500 m2, terminado en septiembre del 2005, posteriormente se hace la unin de los dos edificios, dichas obras fueron terminadas en julio del 2006. En la actualidad la biblioteca cuenta con una superficie total de 1100 m2.$La biblioteca fue inaugurada el 11 de agosto del 2006 por el Prof. Ral Martnez y Rosas, de quien la biblioteca lleva el nombre.$Informacin proporcionada por: Biol. Rosendo Daz Rojas','http://biblio.unam.mx:8030','L2','','PA7','','21204520252104','21204520252300','0','0.00','0','0.00','0.00','0.00','0','0.00','635.00','','',NULL,NULL,'','bib103.jpg','','','','','','Mbib103.jpg','http://biblio1.prepa2.unam.mx:8991','https://goo.gl/maps/6cQHRDDV8dt','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (104,'Biblioteca "Erasmo Castellanos Quinto"','','','Bachillerato                                                                                        ','1964','Erasmo Castellanos Quinto dispuso que su biblioteca pasara a servir a la Escuela Nacional Preparatoria ','http://biblio.unam.mx:8140/','L3','','PA8','','21204520352101','21204520352307','0','0.00','0','0.00','0.00','0.00','0','0','1858.00','','',NULL,NULL,'','bib104.jpg','','','','','','Mbib104.jpg','http://biblio1.prepa3.unam.mx:8991','https://goo.gl/maps/Zh4WNSkn9mR2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (105,'Biblioteca "Concepcin Glvez de Tovar"','','','Bachillerato                                                                                        ','1964','La Biblioteca tiene su origen en los ao 50`s  en las calles de Puente de Alvarado, lugar en donde se encontraba el edificio que albergaba las instalaciones del plantel en las cuales fue necesario improvisar una Biblioteca ya que no se contaba con un espacio. Se acondicion un pasillo del edificio cubrindolo con mamparas para depositar el acervo y as  proporcionar el servicio.$Inicialmente, la coleccin se obtuvo mediante donaciones de profesores y ex alumnos y con compras que se efectuaban a consideracin del encargado de la biblioteca.$En 1964 se trasladan las instalaciones de la preparatoria a la Avenida Observatorio # 170, conocida como preparatoria de Tacubaya. En las nuevas instalaciones se contaba  con un espacio destinado para la Biblioteca pero por el crecimiento de la poblacin estudiantil y las necesidades de sta, en 1994 se inicia la construccin del nuevo edificio donde se instalaran los laboratorios LASE y servira para la ampliacin de la Biblioteca, inaugurada en 1996.$De 1964 al 1994 el servicio es estantera cerrada. Al estrenarse las nuevas instalaciones se cambia a estantera abierta. Se cuenta con dos salas de proyecciones equipadas con sus respectivas caseteras y reproductores de DVD para 12 personas cada una, contando adems con 10 espacios individuales para proyectar el material, una sala de tareas con 20 computadoras que cuentan con el servicio de Internet y un tcnico para dar asesora a los usuarios. Asimismo existen 6 salas para trabajar en grupo.$Informacin proporcionada por: Rubn Hinojosa Martnez.','http://biblio.unam.mx:8040/','L4','','PA9','','21204520452108','21204520452304','0','0.00','0','0.00','0.00','0.00','0','0','1250.00','','',NULL,NULL,'','bib105.jpg','','','','','','Mbib105.jpg','http://biblio1.prepa4.unam.mx:8991','https://goo.gl/maps/hfdfEzrtZfK2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (106,'Biblioteca. Escuela Nacional Preparatoria. Plantel 5','','','Bachillerato                                                                                        ','1956','','http://biblio.unam.mx:8050','L5','','PAA','','21204520552105','21204520552301','0','0.00','0','0.00','0.00','0.00','0','0','1017.00','','',NULL,NULL,'','bib106.jpg','','','','','','Mbib106.jpg','http://biblio1.prepa5.unam.mx:8991','https://goo.gl/maps/ayoTtMDTAA92','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (107,'Biblioteca. Escuela Nacional Preparatoria. Plantel 6','','','Bachillerato                                                                                        ','1964','','http://biblio.unam.mx:8000','L6','','PAB','','21204520652102','21204520652308','0','0.00','0','0.00','0.00','0.00','0','0','667.00','','',NULL,NULL,'','bib107.jpg','','','','','','Mbib107.jpg','http://biblio1.prepa6.unam.mx:8991','https://goo.gl/maps/kLay2jzXs5z','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (108,'Biblioteca "Prof. Jos Castillo Farreras"','','','Bachillerato                                                                                        ','1964','','http://biblio.unam.mx:8060','L7','','PAC','','21204520752109','21204520752305','0','0.00','0','0.00','0.00','0.00','0','0','1276.00','El 14 de abril de 2005 se le asigna el nombre a la biblioteca ','',NULL,NULL,'','bib108.jpg','','','','','','Mbib108.jpg','http://biblio1.prepa7.unam.mx:8991','https://goo.gl/maps/fbWZ1LHPt9L2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (101,'Biblioteca "Ral Pous Ortz"','','','Bachillerato                                                                                        ','1965','','http://biblio.unam.mx:8080','L18','','PA5','','21204520852106','21204520852302','0','0.00','0','0.00','0.00','0.00','0','0','1050.00','','',NULL,NULL,'','bib101.jpg','','','','','','Mbib101.jpg','http://biblio1.prepa8.unam.mx:8991','https://goo.gl/maps/6JkBv6MVEtG2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (102,'Biblioteca "Benito Jurez Garca"','','','Bachillerato                                                                                        ','1965','El edificio actual data de junio de 1996. Fue inaugurada por el director  Hctor Hugo Figueroa Tapia. En ese entonces, la biblioteca fue diseada en cinco niveles con cubculos de estudio, una sala de cmputo para consulta a Internet y para realizar trabajos, as como amplias salas de lectura.$Sus acervos con coleccin general y coleccin de consulta.$Los catlogos computarizados permiten la consulta de manera automatizada. Al ser inaugurada la biblioteca se dejo el viejo sistema de prstamo Gaylor y Newark y posteriormente se adopt el sistema computarizado de prstamo Aleph 500. Asimismo se cambi a estantera abierta permitiendo el libre acceso a las colecciones a todos sus usuarios.$Informacin proporcionada por: Mario Rafael Ojeda Pia.','http://biblio.unam.mx:8090','L19','','PA6','','21204520952103','21204520952309','0','0.00','0','0.00','0.00','0.00','0','0','1309.00','','',NULL,NULL,'','bib102.jpg','','','','','','Mbib102.jpg','http://biblio1.prepa9.unam.mx:8991','https://goo.gl/maps/JP2Qo6GUNGK2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (10,'Biblioteca "Lino Picaseo"','','','Licenciatura y Posgrado                                                                             ','1784','','http://arquitectura.unam.mx/bibliotecas.html','BA','','P0B','','10204240152102','10204240152308','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','1187.00','','Biblioteca Lino Picaseo el  5 dic. al 15 feb. 2014. Gaceta 27 de febrero 2014. Superficie de 60.75 m2. Incremento de equipo y renovacin. Gaceta 8 de marzo 2012',NULL,NULL,'','bib10.jpg','','','','','','Mbib10.jpg','http://biblioarq.arq.unam.mx:8991','https://goo.gl/maps/86gbzBP16gP2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (11,'Biblioteca "Clara Porset Dumas"','','','Licenciatura y Posgrado                                                                             ','1984','','http://arquitectura.unam.mx/biblioteca-disentildeo-industrial.html','BAI','','P0E','','10204240452103','10204240452309','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','196.00','','',NULL,NULL,'','bib11.jpg','','','','','','Mbib11.jpg','http://biblioarq.arq.unam.mx:8991','https://goo.gl/maps/GdWtxF2w4gF2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (32,'Biblioteca "Luis Unikel"','','','Licenciatura y Posgrado                                                                             ','1990','La biblioteca Luis Unikel fue creada en 1990 como una biblioteca multidisciplinaria del Posgrado, bajo la entonces administracin del Jefe de Estudios de Posgrado, arquitecto Ernesto Alva Martnez.$Junto con las bibliotecas Lino Picaseo y Clara Porset,  forma parte del Sistema Bibliotecario de la Facultad de Arquitectura.$Debe su nombre al ingeniero Luis Unikel, quien dentro de su amplia trayectoria acadmica imparti cursos en la entonces Escuela Nacional de Arquitectura; realiz diversas publicaciones en libros y revistas; ocup importantes cargos nacionales e internacionales; y obtuvo mltiples premios nacionales en economa.  Sin embargo, su mayor legado al pas son las aportaciones al proceso de urbanizacin en Mxico.$La biblioteca Luis Unikel de la Divisin de Estudios de Posgrado se readecu en el ao 2001-2002, bajo la administracin del Coordinador de Estudios del Posgrado arquitecto Juan Giral y Mazn.  Su acervo general est conformado principalmente por libros y revistas de arquitectura, urbanismo, vivienda, restauracin, arte e historia y tesis de maestra y doctorado.$Informacin proporcionada por: Mara de Lourdes Robleda Gonzlez de Castilla.','http://arquitectura.unam.mx/biblioteca-luis-unikel.html ','CMP1','','P36','','11204240252102','11204240252308','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','304.00','','',NULL,NULL,'','bib32.jpg','','','','','','Mbib32.jpg','http://biblioarq.arq.unam.mx:8991','https://goo.gl/maps/7girZK2CXDt','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (8,'Centro de Documentacin "Prof. Jos Ma. Natividad Correa Toca"','','','Licenciatura y Posgrado                                                                             ','1979','','http://blogs.enap.unam.mx/centro_documentacion/','B','','P09','','10204320152101','10204320152307','0','0.00','0','0.00','0.00','0.00','0','0','664.00','','',NULL,NULL,'','bib08.jpg','','','','','','Mbib08.jpg','http://biblio.enap.unam.mx:8991','https://goo.gl/maps/cQ4fGmxDPrn','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (9,'Biblioteca. Facultad de Artes y Diseo. Posgrado en Artes y Diseo','','','Licenciatura y Posgrado                                                                             ','1974','1785 orgenes de la fundacin de la Biblioteca (Antigua Academia de San Carlos)','http://academiasancarlos.unam.mx/biblioteca.html','B1','','P0A','','11204320152104','11204320152300','0','0.00','0','0.00','0.00','0.00','0','0','286.00','REMODELACIN DE LA BIBLIOTECA 2007. CAMBIO DE LUGAR PLANTA BAJA','',NULL,NULL,'','bib09.jpg','','','','','','Mbib09.jpg','http://132.247.30.5:8991','https://goo.gl/maps/1CMHUKWqPCm','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (60,'Biblioteca "Ricardo Monges Lpez"','','','Licenciatura y Posgrado                                                                             ','1995','Los antecedentes de la actual Biblioteca Ricardo Monges Lpez se remontan al ao de 1954 en que fue inaugurada la Facultad de Ciencias, en las instalaciones de la entonces recin construida Ciudad Universitaria. En la Facultad se contaba ya con una pequea coleccin de 50 libros. An con estos pocos ejemplares se design un espacio que durante algunos aos constituy la primera biblioteca de la Facultad de Ciencias.  Naturalmente que este acervo se fue incrementando con el paso del tiempo, y con la creacin en 1967 de nuevos planes de estudio para las carreras de Actuara, Biologa, Fsica y Matemticas se impuls notablemente el crecimiento de la coleccin de libros; en ese momento el acervo alcanz los nueve mil ejemplares aproximadamente. Diez aos despus, en 1977, la Facultad de Ciencias se traslad a las instalaciones, que ocupa en la actualidad. En el diseo de estos edificios se consider el espacio dedicado a contener la biblioteca, que ya para entonces contaba con un acervo bibliogrfico de aproximadamente once mil ejemplares. Esta biblioteca fue pensada de manera que pudiera atender a las necesidades de un mayor nmero de usuarios, por lo que contaba ya con una sala de estudios, un rea que contena la coleccin general y una sala con ejemplares de consulta. Esta biblioteca tuvo como propsito principal ofrecer servicios a los estudiantes de las cuatro carreras que entonces se impartan en la facultad. El personal acadmico se organiz en tres departamentos: Biologa, Fsica y Matemticas, y cada uno de estos ha contado desde entonces con sus edificios independientes. Ante los requerimientos de informacin especficos de la planta acadmica de cada uno de los departamentos, se desarrollaron bibliotecas departamentales con materiales bibliogrficos de niveles de posgrado e investigacin. Paralelamente se fue conformando en cada una de stas un acervo hemerogrfico acorde a cada rea del conocimiento. En particular, la biblioteca del Departamento de Fsica recibi en donacin aproximadamente cinco mil libros que fueron propiedad del Dr. Alejandro Medina, distinguido miembro de ese departamento. Al fallecer el Dr. Medina, en un gesto de aprecio por la facultad, sus familiares tuvieron a bien realizar esta noble accin y en un acto de reconocimiento y reciprocidad, el departamento de Fsica nombr a su biblioteca como Biblioteca Alejandro Medina. De manera semejante la biblioteca departamental de Matemticas recibi el nombre del Dr. Guillermo Torres, quien fuera un excelente profesor y director de la facultad. En 1995 se inaugur el conjunto Amoxcalli (Casa de los libros) que cuenta con diferentes espacios como el Auditorio Carlos Graef, el Aula Leonila Vzquez, los Salones de Seminarios Sotero Prieto I, II y III, el Anfiteatro Alfredo Barrera, el centro de Cmputo Toms A. Brody y por supuesto su espacio principal destinado a contener la Biblioteca Ricardo Monges Lpez. Este nombre le fue otorgado en honor al primer director de la Facultad de Ciencias.  La gran coleccin bibliogrfica actual se conform con los acervos de la biblioteca principal y de las bibliotecas departamentales. De igual forma las colecciones de revistas y tesis de las bibliotecas departamentales se reunieron para conformar el acervo de la hemeroteca. En resumen, la Biblioteca Ricardo Monges Lpez posee una coleccin que se ha ido conformando durante un poco ms de medio siglo y que se mantiene en constante crecimiento y actualizacin. Esta biblioteca tiene ahora la capacidad para atender a la comunidad de la Facultad de Ciencias con aproximadamente una decena de miles de usuarios y a sus visitantes externos. Texto enviado por Mat. Adrin Girard','http://www.fciencias.unam.mx/servicios/biblioteca/Index','FC','','P7F','','10204110152108','10204110152304','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','5047.00','','',NULL,NULL,'','bib60.jpg','','','','','','Mbib60.jpg','http://aleph.fciencias.unam.mx:8980','https://goo.gl/maps/Mg6QDKNwme92','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (35,'Biblioteca "Isidro Fabela"','','','Licenciatura y Posgrado                                                                             ','1984','','http://www.politicas.unam.mx/principal/biblioteca.php ','CP','','P3C','','10204120152105','10204120152301','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','1564.00','Creacin de licenciatura en Antropologia con participacin del IA, Filolgicas, CPHCS y CIMCHFS. Gaceta 4707. 2 julio 2015. DPLybf','La biblioteca cuenta con biblioteca digital llamada Henrique Gonzlez Casanova, puesta a disposicin el 14 febrero 2005, Gaceta 3784. DPLybf',NULL,NULL,'','bib35.jpg','','','','','','Mbib35.jpg','http://biblioteca.politicas.unam.mx:8991','https://goo.gl/maps/aw1qJVgTTrF2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (15,'Biblioteca "C.P. Alfredo Adam Adam"','','','Licenciatura y Posgrado                                                                             ','1986','1986 inauguracin de Biblioteca con el nombre de C.P. Alfredo Adam Adam. ','http://biblio.contad.unam.mx/ ','C','','P14','','10204130152102, 11204130252102','10204130152308','0','0.00','0','0.00','0.00','0.00','0','0','3139.00','','',NULL,NULL,'','bib15.jpg','','','','','','Mbib15.jpg','http://alephfca.fca.unam.mx:8991','https://goo.gl/maps/JAp1C3dxbCx','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (44,'Biblioteca "Antonio Caso"','','','Licenciatura y Posgrado                                                                             ','1954','',' http://www.derecho.unam.mx/biblioteca/index-biblioteca.php ','D','','P4C','','10204140152109','10204140152305','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','4695.00','','',NULL,NULL,'','bib44.jpg','','','','','','Mbib44.jpg','http://bassi.derecho.unam.mx:8991','https://goo.gl/maps/S1bnPSciXAB2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (33,'Biblioteca "Ramn Ramrez Gmez"','','','Licenciatura y Posgrado                                                                             ','1976','1974 ','http://www.depfe.unam.mx/biblioteca/index.htm','CMP5','','P3A','Activa','11024230252107','11024230252303','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','1520.00','','',NULL,NULL,'','bib33.jpg','No','No','No','','','Mbib33.jpg','http://biblioteca.economia.unam.mx:8991','https://goo.gl/maps/durUh9X1TyR2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (133,'Biblioteca "Enrique Gonzlez Aparicio"','','','Licenciatura y Posgrado                                                                             ','1937','','http://132.248.45.5/biblioteca/index.html','Q','','PC4','','10204230152105 $11024230252107','10204230152301','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','3850.00','','',NULL,NULL,'','bib133.jpg','','','','','','Mbib133.jpg','http://biblioteca.economia.unam.mx:8991','https://goo.gl/maps/bBVQ1pAm7R82','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (4,'Centro de Informacin y Documentacin','','','Licenciatura y Posgrado                                                                             ','1975','La Escuela Nacional de Estudios Profesionales Acatln fue fundada en 1975.  Ese mismo ao inician las funciones de la Biblioteca que contaba con un acervo de 3,750 volmenes.$En el ao de 1982, debido al crecimiento natural del servicio y del propio acervo bibliogrfico se vio la necesidad de contar con un edificio donde se brindaran los servicios en espacios funcionales; de esta manera fueron ampliadas las instalaciones a una superficie de 4,500 m2; se cambi su denominacin a Centro de Informacin y Documentacin y se establece tambin el sistema de estantera abierta.$En 1989, con la utilizacin de cdigos de barras en credenciales y libros, se realiz desde esa poca el prstamo y devolucin del material en forma automatizada.  Previniendo el auge que tendra la informacin en formato electrnico y tomando en cuenta el avance tecnolgico, en 1997, inicia su funcionamiento la Sala de Consulta Especializada.$Informacin proporcionada por: Lic. Patricia Espinosa Martnez.','http://www.acatlan.unam.mx/cid/ ','ACA','','P04','','10204420152104','10204420152300','00','0.00','0','0.00','0.00','0.00','0','0','4531.00','','',NULL,NULL,'','bib04.jpg','','','','','','Mbib04.jpg','http://132.248.80.61:8991','https://goo.gl/maps/AvKzCnWWy7S2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (7,'Biblioteca "Jess Reyes Heroles"','','','Licenciatura y Posgrado                                                                             ','1976','','http://www.aragon.unam.mx/aragon/biblioteca.html','ARA','','P08','','10204440152108','10204440152304','0','0.00','0','0.00','0.00','0.00','0','0','5310.00','Gaceta 10 enero de 2013 en la biblioteca se habilit la puerta de emergencia y se instal un radiorreceptor para recibir la seal de alerta ssmica. DPLybf','',NULL,NULL,'','bib07.jpg','','','','','','Mbib07.jpg','http://biblioteca-fes.aragon.unam.mx:8991','https://goo.gl/maps/obF8qYQJzV32','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (36,'Biblioteca. Facultad de Estudios Superiores Cuautitln. Campo 1','','','Licenciatura y Posgrado                                                                             ','1974','',' http://avalon.cuautitlan2.unam.mx/biblioteca/ ','CUA','','P44','','10204410152107','10204410152303','0','0.00','0','0.00','0.00','0.00','0.00','0.00','1420.00','','',NULL,NULL,'','bib36.jpg','','','','','','Mbib36.jpg','http://dgb1.cuautitlan2.unam.mx:8991','https://goo.gl/maps/CEQ7EayCpeJ2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (37,'Biblioteca. Facultad de Estudios Superiores Cuautitln. Campo 4','','','Licenciatura y Posgrado                                                                             ','1974','','http://avalon.cuautitlan2.unam.mx/biblioteca/','CUA4','','PF3','','','','0.00','0.00','0','0.00','0','0.00','0','0','2114.00','','',NULL,NULL,'','bib37.jpg','','','','','','Mbib37.jpg','http://bib2.cuautitlan1.unam.mx:8991','https://goo.gl/maps/3tbrXHyP4jF2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (95,'Unidad de Documentacin Cientfica','','','Licenciatura y Posgrado                                                                             ','1975','',' http://www.iztacala.unam.mx/sga/udc/ ','IZT','','P9E','','10204430152101','10204430152307','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','4577.00','','',NULL,NULL,'','bib95.jpg','','','','','','Mbib95.jpg','http://udc.iztacala.unam.mx:8991','https://goo.gl/maps/82vo9nfjvzE2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (138,'Biblioteca. Facultad de Estudios Superiores Zaragoza. Campo 1','','','Licenciatura y Posgrado                                                                             ','1976','','http://www.bibliotecampus1.org/','ZAR','','PD8','','10204450152105','10204450152301','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','2149.00','','',NULL,NULL,'','bib138.jpg','','','','','','Mbib138.jpg','http://biblio66.zaragoza.unam.mx:8991','https://goo.gl/maps/Z22YMzUUtoB2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (139,'Biblioteca.  Facultad de Estudios Superiores Zaragoza. Campo 2','','','Licenciatura y Posgrado                                                                             ','1979','','http://bibliotecacampus2.blogspot.mx/','ZAR2','','PD9','','','10204450152301','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','2393.00','En enero de 2014 se encuentran provisionalmente en otro recinto del campus con 1200m2','',NULL,NULL,'','bib139.jpg','','','','','','Mbib139.jpg','http://132.248.193.2:8991','https://goo.gl/maps/Xn3iigP7AH12','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (59,'Biblioteca "Samuel Ramos"','','','Licenciatura y Posgrado                                                                             ','1959','Sus races se encuentran en el siglo XVI, cuando se instaura la Facultad de Artes de la Real y Pontificia Universidad de Mxico.$A principios del siglo XX, se funda la Escuela de Altos Estudios, antecedente de la Facultad. En los aos treinta, la biblioteca ocup una sala adaptada en el edificio de Mascarones.$Tras el desplazamiento a Ciudad Universitaria se le asign una planta con 780m2, y all funcion durante casi cuarenta aos (actualmente es la segunda seccin de la biblioteca). Las necesidades de espacio y de modernizacin de los servicios hicieron prioritaria la construccin de una nueva biblioteca, con edificio propio y con acceso a las innovaciones tecnolgicas.$Mediante el apoyo del Programa UNAM-BID, se logr la construccin de la nueva Biblioteca Samuel Ramos que se inaugur el 27 de abril de 1995.$En la planta principal de la biblioteca se localizan la hemeroteca, los catlogos electrnicos para el servicio a los usuarios, el mdulo de prstamo, la sala automatizada, el rea de lectura y la Coordinacin.$La planta baja guarda el acervo general y el fondo reservado. En este mismo nivel est ubicado el Departamento de Adquisiciones y Procesos Tcnicos y el rea de fotocopiado.$Informacin proporcionada por: Mtro. Jorge Gmez Briseo.','http://palas-atenea.filos.unam.mx/ ','F','','P7D','','10014150152105$12024150452105','10204150152302$11014150252301','0','0.00','0','0.00','0.00','0.00','0.00','0','3949.00','REMODELACION: cambio de loseta asfltica por loseta cermica 2008. DPLybf','Biblioteca construida en dos niveles con un rea de 2507m2. Gaceta 4 mayo 1995. DPLybf.',NULL,NULL,'','bib59.jpg','','','','','','Mbib59.jpg','http://bsr.filos.unam.mx:8991','https://goo.gl/maps/S1bnPSciXAB2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (65,'Biblioteca "Ing. Antonio Doval Jaime"','','','Licenciatura y Posgrado                                                                             ','1954','','http://www.ingenieria.unam.mx/bibliotecas/','G','','P87','','10204160152103','10204160152309','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','600.00','','',NULL,NULL,'','bib65.jpg','','','','','','Mbib65.jpg','http://bibliotecasfi.fi-a.unam.mx:8991','https://goo.gl/maps/5UQvPdSWKm42','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (68,'Biblioteca "Mtro. Enrique Rivero Borrell"','','','Licenciatura y Posgrado                                                                             ','1967','','http://www.ingenieria.unam.mx/bibliotecas/','G1','','PEE','','','','0.00','0.00','1363927.00','1363927.00','0.00','0.00','0.00','0.00','3390.00','','',NULL,NULL,'','bib68.jpg','','','','','','Mbib68.jpg','http://bibliotecasfi.fi-a.unam.mx:8991','https://goo.gl/maps/xs4RBio7YPt','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (66,'Biblioteca "Dr. Enzo Levi"','','','Licenciatura y Posgrado                                                                             ','1957','','http://www.ingenieria.unam.mx/bibliotecas/','G2','','P89','','11204160252103','11204160252309','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','2000.00','','',NULL,NULL,'','bib66.jpg','','','','','','Mbib66.jpg','http://bibliotecaenzolevi.fi-p.unam.mx:8991','https://goo.gl/maps/kjrBbMnYEBw','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (67,'Centro de Informacin y Documentacin "Ing. Bruno Mascanzoni"','','','Licenciatura y Posgrado                                                                             ','1984','','http://www.mineria.unam.mx/cid.php','G3','','P8A','','14024160352101','14024160352307','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','139.00','2012. Cambio de lugar. Se encontraban en primer piso y se reubicaron en planta baja del mismo edificio de ','',NULL,NULL,'','bib67.jpg','','','','','','Mbib67.jpg','http://biblio192.dgbiblio.unam.mx:8995','https://goo.gl/maps/tVe5aZEXLfL2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (75,'Biblioteca "Ing. Antonio M. Anza"','','','Licenciatura y Posgrado                                                                             ','1987','La Biblioteca del Acervo Histrico del Palacio de Minera resguarda aproximadamente 200,000 volmenes entre monografas y publicaciones peridicas de los siglos XVI a XX. Sus antecedentes se remontan a 1792, ao de la fundacin del Real Seminario o Colegio de Minera de Mxico. Durante la poca virreinal, la biblioteca de esta institucin se nutri de compras hechas en Europa y Mxico.$En 1867, el colegio se transform en Escuela Nacional de Ingenieros. Durante el gobierno de Porfirio Daz, dicha institucin particip en la construccin de la infraestructura ferroviaria, portuaria, etc. del pas. En 1910, la Escuela se incorpor a la Universidad Nacional de Mxico. Importantes ingenieros hicieron llegar sus colecciones personales a la biblioteca durante esta poca.$La Escuela sigui sus actividades en el Palacio de Minera hasta 1959, ao en que se traslad de manera definitiva a la Ciudad Universitaria y se transform en Facultad de Ingeniera. En ese momento, la coleccin qued en desuso, para despus constituirse en Acervo Histrico del Palacio de Minera, cuya biblioteca comenz a brindar servicio al pblico en 1989. Adicionalmente, se agregaron los fondos bibliogrficos y hemerogrficos de dos importantes asociaciones cientficas mexicanas fundadas en el siglo XIX: la Sociedad Cientfica ',' http://www.mineria.unam.mx/acervo.php ','GH3',NULL,'PE7','','','','','','','','','','','','821.00','','',NULL,NULL,'','bib75.jpg','','','','','','Mbib75.jpg','http://biblio192.dgbiblio.unam.mx:8995','https://goo.gl/maps/nWo1Mrp3spS2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (80,'Biblioteca. Facultad de Medicina','','','Licenciatura y Posgrado                                                                             ','1954','En 1956 la Escuela de Medicina ocup las nuevas instalaciones de la Facultad de Medicina, en la recin inaugurada Ciudad Universitaria. La Biblioteca se localizaba en la planta baja del edificio E, en ese espacio evolucion y, por ende, mejor la calidad de sus servicios, se adopt la modalidad de estantera abierta en 1989; el uso de catlogos y servicios de circulacin automatizados se inici en 1992.$El Dr. Jos Narro Robles, Director de la Facultad, anunci la construccin de un nuevo edificio para las Bibliotecas en su informe de actividades 2003. Despus de analizar varios proyectos, la opcin seleccionada fue construir un edificio nuevo donde estuviera el edificio E. Esto provoc que los Departamentos que ocupaban ese edificio (Servicios Escolares, Consejo Tcnico, Oficina de Personal Acadmico y Biblioteca) se mudaran a otras instalaciones. La Biblioteca ocup un lugar provisional, construido para tal efecto, en la planta baja del edificio B, de febrero a diciembre de 2006.$El 8 de enero de 2007 el nuevo edificio de 3 niveles abre sus puertas a la comunidad de la Facultad, incluyendo la Biblioteca Dr. Valentn Gmez faras, la Hemerobiblioteca ','http://www.facmed.unam.mx/bibliotecas/index.php?bib_ver=2 ','H','','P91','','10204170152100','10204170152306','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','3105.00','','',NULL,NULL,'','bib80.jpg','','','','','','Mbib80.jpg','http://aleph1.facmed.unam.mx:8991','https://goo.gl/maps/2bfdKVHLcnK2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (85,'Biblioteca "Dr. Nicols Len"','','','Licenciatura y Posgrado                                                                             ','1956','El Departamento de Historia y Filosofa de la Medicina y su biblioteca fueron creados en 1956 por el Dr. Francisco Fernndez del Castillo; l se aboc a clasificar, ordenar y catalogar el archivo histrico de la Facultad, adems de organizar simultneamente todo el material bibliogrfico, constituido por libros, tesis y revistas especializadas en el rea mdica, tanto nacionales como extranjeras que constituy la base para la creacin de la biblioteca histrica.$El nombre de la biblioteca le fue dado por el Dr. Fernndez del Castillo ya que l admiraba al Dr. Len, mdico obstetra, quien adems realiz estudios de bibliotecologa.$El acervo aument considerablemente para el ao de 1960 con la adquisicin de un lote de libros y documentos histricos.$En 1973 el Fondo Antiguo de la FM fue incorporado a la Biblioteca Histrica incrementando sus colecciones. Asimismo fueron recibidas diferentes donaciones de familiares de mdicos de reconocido prestigio.$Esta biblioteca tambin puede ser considerada una biblioteca museo debido a que existen obras que por su antigedad, valor cientfico, cultural y artstico, exclusivamente se exhiben dentro de la misma biblioteca as como en salas del Museo de la Historia de la Medicina Mexicana y se prestan y consultan reproducciones de las mismas para apoyar su preservacin.$Esta biblioteca es considerada como la primera en su gnero en nuestro pas y est entre las mejores en Amrica Latina ya que posee libros que en ocasiones tienen valores incalculables no slo desde el punto de vista econmico, sino tambin cultural, ya que son ejemplares de los que existen contados en el mundo.$Informacin proporcionada por: Mtra. Analicia Hinojosa.','http://fournier.facmed.unam.mx/deptos/hfm/index.php/biblioteca','HBM','','PE5','','','','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','607.00','http://fournier.facmed.unam.mx/deptos/hfm/index.php/biblioteca','',NULL,NULL,'','bib85.jpg','','','','','','Mbib85.jpg','http://aleph3.facmed.unam.mx:8991','https://goo.gl/maps/9ABLnxWnCoQ2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (145,'Biblioteca. Centro de Enseanza, Inv. y Ext. en Ganadera Tropical','','','Licenciatura y Posgrado                                                                             ','1981','Debido a las actividades propias del CEIEGT en la formacin de recursos humanos y el desarrollo de investigaciones en el sector pecuario, la Biblioteca del CEIEGT juega un papel importante en la aportacin de informacin de este sector productivo.$La biblioteca se fund el 19 de Febrero de 1981, con el apoyo de la Facultad de Medicina Veterinaria y Zootecnia de la UNAM y de la Organizacin de las Naciones Unidas para la Agricultura y la Alimentacin (FAO) a travs del Programa de las Naciones Unidas para el Desarrollo (PNUD).$De 1981 a 1984 se ubico en el edificio B, al finalizar la construccin de los edificios C y D en el ao de 1985 se realizo el cambio de ubicacin al edificio D, permitiendo la ampliacin de las reas de colecciones y servicios.$Cuenta con dos bibliotecarios del personal administrativo, quienes ofrecen el servicio al pblico de lunes a sbado.$Informacin proporcionada por: Sra. Victoria Alfonso Villa.','http://www.fmvz.unam.mx/fmvz/centros/ceiegt/servicios.html','CGT','','P27','','10024190852105','10024190852301','101167.00','0.00','864359.00','0.00','0.00','0.00','0.00','0.00','144.00','*Informacin (521) 2004$*Informacin (523) 2005$*Informacin encuadernacin (Censo 2004)','',NULL,NULL,'','bib145.jpg','','','','','','Mbib145.jpg','http://bibliodigital.fmvz.unam.mx:8991','https://goo.gl/maps/MDFH1koBq8m','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (57,'Biblioteca. Centro de Enseanza, Inv. y Ext. en Produccin  Ovina','','','Licenciatura y Posgrado                                                                             ','1992','','http://www.fmvz.unam.mx/fmvz/centros/ceiepo/acerca.html','EIB','','P78','','10024190652101','10024190652307','22246.00','0.00','108532.00','0.00','0.00','0.00','0.00','0.00','34.00','*Informacin (521) 2004$*Informacin (523) 2005 $*Informacin encuadernacin (Censo 2004)','',NULL,NULL,'','bib57.jpg','','','','','','Mbib57.jpg','http://bibliodigital.fmvz.unam.mx:8991','https://goo.gl/maps/VoxsTb6DF9x','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (69,'Biblioteca. Centro de Enseanza, Inv. y Ext. en Produccin Avcola','','','Licenciatura y Posgrado                                                                             ','2002','','http://www.fmvz.unam.mx/fmvz/centros/ceiepav/acerca.html','GEA','','P8B','','10024190752108','10024190752304','36517.00','0.00','34119.00','0.00','0.00','0.00','0.00','0.00','19.00','*Informacin (521) 2004$*Informacin (523) 2005 $*Informacin encuadernacin (Censo 2004)','',NULL,NULL,'','bib69.jpg','','','','','','Mbib69.jpg','http://bibliodigital.fmvz.unam.mx:8991','https://goo.gl/maps/FfrqkBwTZws','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (122,'Biblioteca "M.V. Jos de la Luz Gmez"','','','Licenciatura y Posgrado                                                                             ','1857','1969 Misin de la Biblioteca ','http://www.fmvz.unam.mx/fmvz/biblioteca/acerca.html','P','','PBA','','10204190152104 $11014190252103','10204190152300','0','0.00','0','0.00','0','0.00','0','0.00','3226.00','La coleccin de la divisin de sistema universidad abierta se integr a la biblioteca principal en 2006, DPLybf','Con el apoyo del programa UNAM-BID se construye la biblioteca con 3000m2 (noticia gaceta 3,783- 10-feb-2005) DPLybf',NULL,NULL,'','bib122.jpg','','','','','','Mbib122.jpg','http://bibliodigital.fmvz.unam.mx:8991','https://goo.gl/maps/RP7HC5GJfAJ2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (134,'Biblioteca. Centro de Enseanza, Inv. y Ext. en Produccin Animal en Altiplano','','','Licenciatura y Posgrado                                                                             ','2002','La Biblioteca del CEIEPAA es el resultado del traslado de dos Centros de Enseanza a su nueva ubicacin en Tequisquiapan, Quertaro en el Altiplano Mexicano.  En el ao 2002 es reubicado el hasta entonces Centro de Enseanza, Investigacin y Extensin en Produccin Agrcola y Ganadera (CEIEPAG) en Chalco, Estado de Mxico a su nueva sede en el Poblado de Santilln, Municipio de Tequisquiapan, Quertaro. Es en el casco de una Ex-Hacienda con ms de 350 aos de antigedad donde es preservado el acervo bibliogrfico proveniente de este Centro  para el uso de los alumnos. En el 2004 se incorpora el material bibliogrfico proveniente del Centro de Enseanza, Investigacin y Extensin en Produccin Bovina y Caprina (CEIEPBC), situado en el poblado de Tepotzotln, Estado de Mxico,  para conformar as la Biblioteca del Centro de Enseanza, Investigacin y Extensin en Produccin Animal en Altiplano, donde permaneci hasta el ao 2006. Cuando se concluye la construccin del nuevo complejo acadmico nuevamente se traslada el acervo a las actuales instalaciones, las cuales ya cuentan con infraestructura moderna para brindar un mejor servicio a los usuarios.Texto elaborado por Jos Alfredo Carranza Velzquez','http://www.fmvz.unam.mx/fmvz/centros/ceiepaa/acerca.html','RCM','','PC6','','10024191152109','','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','50.00','Se integran los acervos de Agricola y Ganadera (CGA) y Bovina y Caprina (RCM) oficialmente en 2006. DPLybf','',NULL,NULL,'','bib134.jpg','','','','','','Mbib134.jpg','http://bibliodigital.fmvz.unam.mx:8991','https://goo.gl/maps/t7ra8yjCCbk','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (96,'Biblioteca "Cuicamatini" ','','','Licenciatura y Posgrado                                                                             ','1943','La Escuela Nacional de Msica (ENM), que en aquellos das llevaba el nombre de Facultad de Msica (FM) de la UNAM, fue fundada el 7 de octubre de 1929. El Sr. Gonzalo Angulo fue el primer Bibliotecario que tuvo la Escuela (Facultad en ese entonces) de Msica. Se preocup por crear un acervo de msica para los alumnos de aquella poca.$En 1979 se crea un nuevo edificio, actual sede de la Escuela Nacional de Msica con l se traslada la biblioteca a un espacio con ciertas adaptaciones en dos niveles que permitan que los estudiantes pudieran consultar los materiales que se tenan en existencia.$Las colecciones que tena la biblioteca estaban integradas de materiales donados por algunos profesores y estudiantes, muy poco era adquirido.$Es el 7 de agosto de 1996 cuando se inaugura el nuevo edificio de la Biblioteca. A partir de este momento cambia de denominacin y se convierte en Coordinacin de Acervos Musicales que alberga la coleccin de la Biblioteca Cuicamatini.$Los usuarios que atiende van desde 5 o 6 aos de edad (iniciacin musical), hasta aquellos que realizan estudios de maestra y/o doctorado, sin olvidar a las personas que se encuentran en condiciones especiales.$Informacin proporcionada por: Lic. Daniel Villanueva Rivas.','http://www.fam.unam.mx/servicios/biblioteca.php','J','','P9F','','10204350152102','10204350152308','0','0.00','0','0.00','0.00','0.00','0','0','1493.00','','Biblioteca inaugurada  23 noviembre 1995. Gaceta 2972. DPLybf',NULL,NULL,'','bib96.jpg','','','','','','Mbib96.jpg','http://athenas.enmusica.unam.mx:8991','https://goo.gl/maps/Uw98VZZXPF82','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (97,'Biblioteca "Dr. Ignacio Aguilar Alvarez"','','','Licenciatura y Posgrado                                                                             ','1991','El 19 de abril de 1904 se inaugura el Consultorio Nacional de Enseanza Dental contando con una biblioteca integrada por 19 volmenes. Los temas de estos libros eran principalmente referentes a las reas mdicas y odontolgicas. Inclua un volumen de la Constitucin Mexicana y diccionarios ingls-espaol y francs-espaol, pues casi todos los volmenes estaban escritos en estos idiomas.$Es el 15 de marzo de 1958, cuando la Facultad de Odontologa ocupa la nueva sede definitiva de sus instalaciones en Ciudad Universitaria, se destina un local para la biblioteca situado en el 1er. Piso del edificio ','http://www.odonto.unam.mx/admin.php?IDPagina=biblioteca','K','','PA1','','10204210152101','10204210152307','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','660.00','','',NULL,NULL,'','bib97.jpg','','','','','','Mbib97.jpg','http://bibliotecafo.odonto.unam.mx:8991','https://goo.gl/maps/6zooyeyRvC92','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (98,'Biblioteca "Barnet M. Levy"','','','Licenciatura y Posgrado                                                                             ','1988','En el ao de 1988 la biblioteca inicia en un cubculo en el rea de investigacin y en ese mismo ao se le asigna la mitad del primer piso del edificio principal de posgrado. El Rector Jorge Carpizo, inaugura la Biblioteca de Posgrado ','http://www.odonto.unam.mx/admin.php?IDPagina=Bblioteca&idm=27','K1','','PA2','','11204210252101','11204210252307','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','441.00','','',NULL,NULL,'','bib98.jpg','','','','','','Mbib98.jpg','http://bibliotecafo.odonto.unam.mx:8991','https://goo.gl/maps/3EA5Svm2p4J2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (127,'Biblioteca "Dra. Graciela Rodrguez  Ortega"','','','Licenciatura y Posgrado                                                                             ','1973','Con la creacin de la Facultad de Psicologa el 27 de febrero de 1973, surge la Biblioteca como elemento fundamental del proceso de formacin acadmica de los estudiantes y en apoyo a la docencia, con la finalidad de cubrir la demanda de informacin requerida por la comunidad de la institucin. Con un acervo inicial de 2,787 volmenes, se fueron integrando y acrecentando mediante compra y donacin las colecciones de libros, tesis de licenciatura, pruebas psicolgicas, material audiovisual, etc.$De 1973 a 1976 se localiz en la planta baja del edificio ','http://www.psicologia.unam.mx/biblioteca-y-centro-de-documentacion/','PS','','PS','','10014220152107','','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','1103.00','sala de lectura anexa a la biblioteca. G. 3 de mayo de 2012. DPLybf','',NULL,NULL,'','bib127.jpg','','','','','','Mbib127.jpg','http://exlibris.psicol.unam.mx:8991','https://goo.gl/maps/UPnoDphx6732','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (128,'Centro de Documentacin "Dr. Rogelio Daz Guerrero"','','','Licenciatura y Posgrado                                                                             ','1976','El Centro de Documentacin Dr Rogelio Daz Guerrero, de la Divisin de Estudios de Posgrado de la Facultad de Psicologa , fundado en 1976, es una fuente importante de suministro de informacin para  la investigacin, la docencia y la prctica profesional. Todas estas tareas importantes para la incorporacin de avances del conocimiento en la disciplina, tanto en escenarios nacionales como internacionales.$El Centro tambin ha desarrollado el SIPAL. Sistema de Informacin Psicolgica para Amrica Latina, con la finalidad de apoyar la difusin de artculos publicados en revistas cientficas latinoamericanas especializadas en psicologa.$Informacin proporcionada por: Lic. Magdalena Zrate Santamara.','http://biblio.unam.mx:8390/index.php','PS1','','PC1','','11204220252108','11204220252304','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','702.00','','',NULL,NULL,'','bib128.jpg','','','','','','Mbib128.jpg','http://exlibris.psicol.unam.mx:8991','https://goo.gl/maps/duzbHpNAPT42','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (110,'Biblioteca. Facultad de Quimica. Divisin de Estudios Profesionales','','','Licenciatura y Posgrado                                                                             ','1957','Con el registro de 4795 unidades (libros, tesis, folletos y revistas) ocuparon el local construido ex profeso en la planta baja del edificio principal [de la Facultad de Qumica].  En Tacuba continuaron funcionando con algunos materiales hemerobibliogrficos.  En 1969 se registra un total de 6179 unidades documentales (ya que se haban reunido las dos colecciones).  En 1963 se  report que los acervos estaban conformados por 8 mil obras monogrficas y cien ttulos de publicaciones peridicas; para el ao siguiente el acervo se haba incrementado a 10500 volmenes.$El desarrollo de las bibliotecas fue continuo, de hecho la Facultad tiene cinco unidades bibliotecarias. Dos de las unidades pertenecen a Estudios Profesionales (Edificio A y D), dos a Estudios de Posgrado (Edificio B stano y E) y la Hemeroteca que resguarda publicaciones peridicas.$El incremento de la matrcula y la organizacin interna de la dependencia provocaron que en 1994 se empezara a trabajar en la ampliacin de la biblioteca principal.  Se cre la campaa ','http://quimica.webcom.com.mx/cont_seccion.php?id_rubrique=7&id_article=36&color=08346F ','M','','PAF','','10204180152107','10204180152303','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','1533.00','','El proyecto de ampliacin y modernizacin de la biblioteca tiene 1200 m2 ms de construccin, distribuidos en tres niveles inicia el 22 de junio de 1994.  Gaceta 3013. 13 mayo 1996. DPLybf',NULL,NULL,'','bib110.jpg','','','','','','Mbib110.jpg','http://alepha.quimica.unam.mx:8991','https://goo.gl/maps/mUiicxQedHu','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (111,'Biblioteca. Facultad de Qumica. Divisin de Estudios de Posgrado','','','Licenciatura y Posgrado                                                                             ','1965','En 1916 es fundada la Escuela Nacional de Industrias Qumicas que ms tarde se transforma en Escuela Nacional de Ciencias Qumicas y a partir de 1965 en Facultad de Qumica. Este mismo ao, con las donaciones de miembros de la comunidad de la Facultad y la del Instituto de Qumica, se forma la coleccin de la biblioteca de la Divisin de Estudios Superiores, que posteriormente formar la coleccin de la biblioteca de posgrado. La biblioteca qued ubicada en el stano del edificio ','http://quimica.webcom.com.mx/cont_espe2.php?id_rubrique=7&id_article=948&color=08346F&rub2=467','M1','','PB0','','11204180252107','11204180252303','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','450.00','desde julio del ao 2013 se han trasladado a nuevo lugar llamado antiguo  edificio de Biomdicas, se espera que el traslado se termine a finales de enero 2014.','',NULL,NULL,'','bib111.jpg','','','','','','Mbib111.jpg','http://alepha.quimica.unam.mx:8991','https://goo.gl/maps/wccuC77nFiL2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (112,'Biblioteca de Metalurgia','','','Licenciatura y Posgrado                                                                             ','1983','La carrera de Metalurgia surge a partir de 1920, teniendo algunos cambios en su nombre. Hasta 1967 adopta el nombre de Ingeniera Qumica Metalrgica (IQM). La infraestructura que se utilizaba  para el desarrollo de esta disciplina era muy limitada y se llevaba a cabo en el laboratorio 9, del edificio ','http://quimica.webcom.com.mx/cont_espe2.php?id_rubrique=7&id_article=949&color=08346F&rub2=468','M2','','PFD','','','','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','271.00','','',NULL,NULL,'','bib112.jpg','','','','','','Mbib112.jpg','http://alepha.quimica.unam.mx:8991','https://goo.gl/maps/h1gbsVNc1U22','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (113,'Biblioteca de Farmacia y Alimentos','','','Licenciatura y Posgrado                                                                             ','1993','La biblioteca de posgrado del Conjunto E, de la Facultad de Qumica, surge como parte de un proyecto de descentralizacin de la facultad debido a la demanda de espacios fsicos que requeran los investigadores y alumnos de posgrado, ya que literalmente no caban ms. En el inicio del proyecto se tena contemplado crear una Escuela de Alimentos en Cuernavaca, Iztapalapa  o Xochimilco.$Hacia finales de los 80s e inicios de los 90s, al agudizarse el problema de los espacios, cambia la idea original y se crea el Conjunto E en Ciudad Universitaria que albergara a los investigadores de Alimentos, Biofarmacia e Ingeniera Qumica.$La biblioteca del Conjunto E abri por primera vez sus puertas a los usuarios el da 6 de septiembre de 1993.$Actualmente se puede consultar tambin el SciFinder que es una de bases de datos ms completas en el campo cientfico, adems de recuperar documentos de instituciones externas a la UNAM, va fax, correo electrnico  y compra de documentos en el extranjero con el apoyo de la Direccin General de Bibliotecas.$Informacin proporcionada por: David Morales Zapatero.','http://quimica.webcom.com.mx/cont_espe2.php?id_rubrique=7&id_article=950&color=08346F&rub2=469','M3','','','','','','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','387.00','','',NULL,NULL,'','bib113.jpg','','','','','','Mbib113.jpg','http://alepha.quimica.unam.mx:8991','https://goo.gl/maps/h1gbsVNc1U22','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (114,'Hemeroteca. Facultad de Qumica','','','Licenciatura y Posgrado                                                                             ','1965','La Hemeroteca est en funcionamiento a partir  del  4  de junio de 1991 y forma parte del sistema Bibliotecario de dicha Facultad.$Su funcin es:$*  Apoyar con sus recursos  las labores de investigacin y docencia y difusin de la cultura en el rea de la Qumica.$*  Satisfacer las necesidades de los usuarios y asesorar en la recuperacin de informacin de los diferentes servicios que proporciona la Hemeroteca.$Informacin proporcionada por: Zayda Jimnez Bautista.',' http://quimica.webcom.com.mx/cont_espe2.php?id_rubrique=7&id_article=951&color=08346F&rub2=100','M5','','','','','','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','495.00','','',NULL,NULL,'','bib114.jpg','','','','','','Mbib114.jpg','SIN CATLOGOS','https://goo.gl/maps/YEArjkB139k','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (54,'Biblioteca. Instituto de Biologa','','','Investigacin Cientfica                                                                            ','1929','La Biblioteca del Instituto de Biologa es un acervo especializado en biologa organsmica, sistemtica, ecologa y otras disciplinas afines. Ubicada desde 1999 en sus nuevas instalaciones, fue reinaugurada en enero del ao 2000 con los acervos integrados de tres bibliotecas: la Biblioteca General (coleccin de zoologa, historia natural y biologa en general), Biblioteca del Herbario Nacional y Biblioteca del Jardn Botnico. Actualmente cuenta con un acervo de ms de 24,200 ejemplares, con un ingreso promedio de 750 libros por ao, adems recibe anualmente por suscripcin, canje o donacin 632 ttulos de publicaciones peridicas y seriadas. El acceso a la informacin de estos recursos es a travs de un servicio electrnico de informacin, en la direccin de Internet http://biblio68.ibiologia.unam.mx, donde los usuarios pueden consultar los catlogos del acervo bibliogrfico de la biblioteca, as como obtener informacin de publicaciones en formato electrnico y diversas bases de datos en las reas de inters. Texto tomado de la Web del Instituto de Biologa.',' http://www.ibiologia.unam.mx/bib/www/index.html','E','','P75','','31203130152102','31203130152308','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','1120.00','','',NULL,NULL,'','bib54.jpg','','','','','','Mbib54.jpg','http://132.248.13.22:8991','https://goo.gl/maps/tYmR9TTHtSK2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (55,'Biblioteca.Estacin de Biologa Tropical Los Tuxtlas','','','Investigacin Cientfica                                                                            ','1984','','http://www.ibiologia.unam.mx/tuxtlas/frame/infra/frame.htm','E1','','P76','','31013130352105','31013130352301','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','39.00','','',NULL,NULL,'','bib55.jpg','','','','','','Mbib55.jpg','http://132.248.13.22:8991','https://goo.gl/maps/RRQ2oJB93o12','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (56,'Biblioteca. Estacin de Investigacin Experimentacin y Difusin Chamela ','','','Investigacin Cientfica                                                                            ','1984','','http://www.ibiologia.unam.mx/ebchamela/www/servicios.html','E2','','P77','','31013130452102','31013130452308','0','0.00','0','0.00','0.00','0.00','0.00','0.00','77.00','noticia de gaceta 12 de agosto 2013: nueva construccin que alberga la biblioteca en  la Estacin de Biologa Chamela. DPL.ybf actualizar m2 y foto','Biblioteca que tenia 68 m2 antes de 2013',NULL,NULL,'','bib56.jpg','','','','','','Mbib56.jpg','http://132.248.13.22:8991','https://goo.gl/maps/BF1Tzd7opuk','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (144,'Biblioteca. Instituto de Biotecnologa','','','Investigacin Cientfica                                                                            ','1981','','http://biblioteca.ibt.unam.mx/revistas.php','CGB','','P26','','31203280152100','31203280152306','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','','',NULL,NULL,'','bib144.jpg','','','','','','Mbib144.jpg','http://biblioteca.ccg.unam.mx:8991','https://goo.gl/maps/iwKjXx57bit','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (141,'"Biblioteca Conjunta de Ciencias de la Tierra"','','','Investigacin Cientfica                                                                            ','1997','','http://bcct.unam.mx','MAR','','PB','','0','0','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','','En 1939 se creo el laboratorio de Hidrobiologia, en 1967 se transforma en Departamento de Ciencias del Mar y Limnologia y en julio de 1980 se transforma de Centro a Instituto. DPLybf ',NULL,NULL,'','bib141.jpg','','','','','','Mbib141.jpg','http://132.248.182.16:8991','https://goo.gl/maps/5dwmWq2BygH2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (115,'Biblioteca.  Estacin Ciudad del Carmen','','','Investigacin Cientfica                                                                            ','1980','','http://www.icmyl.unam.mx/?q=node/23','MAR1','','PB2','','','','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','60.00','','',NULL,NULL,'','bib115.jpg','','','','','','Mbib115.jpg','http://132.248.182.16:8991','https://goo.gl/maps/twR6p5AWE3F2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (116,'Biblioteca "Dra. Mara Elena Caso Muoz"','','','Investigacin Cientfica                                                                            ','1979','La biblioteca de la Unidad Acadmica Mazatln inici sus actividades de una manera muy limitada en 1976 en un espacio de 32 m2, y fue hasta 1983 que se inici su organizacin formal. En 1986 se incorporaron ms documentos y se emprendi la organizacin temtica del acervo con catlogos manuales. En 1994 se inici el sistema de captura del acervo en bases de datos y es hasta 1999 que se cuenta con catlogos electrnicos. El 6 de noviembre de 1991 se decidi dar nombre a la biblioteca, en honor de la Dra. Mara Elena Caso Muoz, quien fuera una insigne investigadora del Instituto de Ciencias del Mar y Limnologa en Ciudad Universitaria, tuvo durante su carrera acadmica una particular afinidad con el personal de la Estacin Mazatln. En septiembre de 1996, se logr ampliar el espacio fsico a 75 m2. En 1999 se construy un edificio ex profeso de 120 m2 con mobiliario y equipo acorde con la tecnologa de dicho perodo. En 2013 se cuenta con el Edificio de Unidades de Servicios, donde la biblioteca se muda al segundo piso con un rea aprox. de 260 m2. Actualmente la Biblioteca Regional Dra. Mara Elena Caso Muoz permite a los interesados en las Ciencias del Mar y otras disciplinas, el acceso a innumerables fuentes de informacin, por medios tradicionales y electrnicos, adems brinda servicios de colaboracin y envo de documentacin a instituciones nacionales, Latinoamrica y a nivel internacional. $Informacin enviada por Lic. Daniel Oviedo Jurez ',' http://ola.icmyl.unam.mx/biblio ','MAR2','','PB3','','31023250352105','31023250352301','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','120.00','','',NULL,NULL,'','bib116.jpg','','','','','','Mbib116.jpg','http://132.248.182.16:8991','https://goo.gl/maps/DtN5pJEscMm','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (117,'Biblioteca. Unidad Acadmica Sistemas Arrecifales','','','Investigacin Cientfica                                                                            ','1988','',' http://www.icmyl.unam.mx/arrecifes/library.html ','MAR3','','PB4','','31023250452102','31013250452305','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','38.00','','',NULL,NULL,'','bib117.jpg','','','','','','Mbib117.jpg','http://132.248.182.16:8991','https://goo.gl/maps/Fy96mjUFxWS2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (18,'Biblioteca. Instituto de Ecologa','','','Investigacin Cientfica                                                                            ','1988','','http://web.ecologia.unam.mx/index.php','CCE','','PE8','','31203290152107','31203290152303','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','184.00','http://web.ecologia.unam.mx/servicios/biblioteca/index.php','',NULL,NULL,'','bib18.jpg','','','','','','Mbib18.jpg','http://biblioteca.ecologia.unam.mx:8991','https://goo.gl/maps/5yjmGMnee1C2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (77,'Unidad de Informacin ','','','Investigacin Cientfica                                                                            ','1982','1996 ',' http://xml.cie.unam.mx/xml/sacad/bib/ ','GI2','','PDF','','31013110852106','31013110852302','0','0.00','0','0.00','0.00','0.00','00','0','220.00','','',NULL,NULL,'','bib77.jpg','','','','','','Mbib77.jpg','http://aleph.cie.unam.mx:8991','https://goo.gl/maps/6cs2LWnaLXF2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (71,'Biblioteca "Juan B. de Oyarzbal"','','','Investigacin Cientfica                                                                            ','1938','La historia de la Biblioteca del IFUNAM est ntimamente vinculada con la fundacin del Instituto en 1939, ya que desde esa fecha, existi la necesidad de tener una unidad de informacin que brindara soporte para el desarrollo de sus actividades acadmicas.I.ObjetivoProporcionar a los usuarios en forma eficiente y oportuna, los servicios bibliotecarios y de informacin, necesarios, para las actividades docentes y de investigacin que se llevan a cabo en el Instituto de Fsica.II. Colecciones La biblioteca tiene bsicamente tres tipos de colecciones.1. Coleccin bibliogrfica. Est formada por 13,250 volmenes de libros, distribuidos en dos categoras: Obras de consulta y acervo general. La temtica de estos materiales est orientada al campo de la fsica y reas afines.2. Coleccin hemerogrfica. A esta coleccin la integran ms de 230 ttulos de publicaciones peridicas vigentes. Algunos ttulos pueden ser consultados va electrnica, a travs de la opcin: Revistas Electrnicas3. Coleccin de tesis. Se tienen 689 volmenes de tesis de nivel licenciatura, maestra y doctorado. Los tpicos de estos materiales estn dirigidos al rea de fsica y disciplinas relacionadas. Texto tomado de la WEB del Instituto de Fsica.','http://w2.fisica.unam.mx/bif','GF','','P8D','','31203140152109','31203140152305','0','0.00','0','0.00','0','0.00','0','0','2000.00','','',NULL,NULL,'','bib71.jpg','','','','','','Mbib71.jpg','http://newton.fisica.unam.mx:8991','https://goo.gl/maps/c7UcEYH8Jfk','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (23,'Biblioteca "Dr. Armando Gmez Puyou"','','','Investigacin Cientfica                                                                            ','1986','','http://132.248.16.13:8991/F','CFC','','P23','','31023260152108','31023260152304','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','426.00','','',NULL,NULL,'','bib23.jpg','','','','','','Mbib23.jpg','http://sunbiblio.ifc.unam.mx:8991','https://goo.gl/maps/EKhu4NgLve82','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (143,'"Biblioteca Conjunta de Ciencias de la Tierra"','','','Investigacin Cientfica                                                                            ','1997','',' http://bcct.unam.mx ','IF','','','','31203150152106','31203150152302','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','','',NULL,NULL,'','bib143.jpg','','','','','','Mbib143.jpg','http://132.248.182.16:8991','https://goo.gl/maps/5dwmWq2BygH2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (74,'Biblioteca "Ing. Antonio Garca Cubas"','','','Investigacin Cientfica                                                                            ','1946','Biblioteca-Mapoteca especializada en el rea de geografa y disciplinas afines.$Su creacin data del ao 1946 con colecciones pequeas existentes en espacios no apropiados para biblioteca. De 1954-1975 el Instituto de Geografa se ubic en un edificio adjunto a la ex torre de ciencias, hoy Torre de Humanidades II, y en el curso de 1975 el Instituto se traslad al rea de la Investigacin Cientfica y la Biblioteca cont con un espacio de 250 m2 en dos reas separadas.$En 1986 la coleccin era de 7000 vols. de libros y el servicio era de estantera cerrada.$En 1992 se estableci el servicio de estantera abierta de las colecciones de libros, revistas y tesis; quedando en servicio de estantera cerrada la cartografa, el material digital y el audiovisual.$En 1994 se presentaron varios proyectos para remodelar la biblioteca que no lograron culminar. Fue hasta 2002 con la reestructuracin completa del edificio del Instituto en que se cont con 1028 m2 que se tradujo espacios ptimos para contener el crecimiento de las colecciones: libros, publicaciones peridicas, mapas, un fondo reservado de 250 ttulos de obras del siglo XIX a 1930 y materiales digitales y audiovisuales.$Informacin proporcionada por: Mtra. Concepcin Basilio Romero.',' http://www.igeograf.unam.mx/sigg/biblioteca/intro.php ','GG','','P8E','','31203160152103','31203160152309','0','0.00','0','0.00','0.00','0.00','0','0','1029.00','Incluye Mapoteca "Alejandro de Humboldt"','',NULL,NULL,'','bib74.jpg','','','','','','Mbib74.jpg','http://cubas.igeograf.unam.mx:8991','https://goo.gl/maps/1Mij6UHVbF32','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (142,'"Biblioteca Conjunta de Ciencias de la Tierra"','','','Investigacin Cientfica                                                                            ','1997','',' http://bcct.unam.mx ','I','','','','31203170152100 $41023170152109','31203170152306','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','','',NULL,NULL,'','bib142.jpg','','','','','','Mbib142.jpg','http://132.248.182.16:8991','https://goo.gl/maps/5dwmWq2BygH2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (88,'Biblioteca. Estacin Regional del Noroeste ','','','Investigacin Cientfica                                                                            ','1974','OBJETIVOS$*  Dar apoyo bibliogrfico a los proyectos de investigacin generados en la ERNO, al posgrado en Ciencias de la Tierra de la UNAM, a los estudiantes y acadmicos de otras instituciones de la localidad e interesados en el rea.$*  Ofrecer servicios y acervos especializados sobre las ciencias de la tierra que permitan el desarrollo institucional en particular y de los usuarios en general.$HISTORIA$La Estacin Regional del Noroeste (ERNO) del Instituto de Geologa, ubicada en Hermosillo, Sonora, fue creada en 1974 como parte de la poltica de descentralizacin que inici la UNAM ese mismo ao. Obtiene un terreno en comodato con la Universidad de Sonora, donde construye un edificio que se inaugura el 20 de noviembre de 1980, destinndose un espacio para la biblioteca.$Informacin proporcionada por: Rosa Mara Contreras Garca.','http://www.geologia-son.unam.mx/biblioteca.html','I1','','P97','','','00000','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','46.00','','',NULL,NULL,'','bib88.jpg','','','','','','Mbib88.jpg','http://132.248.182.16:8991','https://goo.gl/maps/6qCg8Gsvo7t','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (91,'Unidad de Servicios de Informacin ','','','Investigacin Cientfica                                                                            ','1978','La Unidad de Servicios de Informacin del Instituto de Ingeniera fue creada en 1978 y tiene como misin ser una entidad dinmica y de vanguardia que incida de manera decisiva, oportuna y eficiente en los procesos de generacin, transmisin y difusin del conocimiento en el pas, a travs de sus servicios$Hasta 2003 el acervo de la USI estaba dispersa en varias colecciones ubicadas en los diferentes edificios del Instituto de Ingeniera, a partir de esta fecha se logr reunir en un solo espacio todo el material bibliogrfico y hemerogrfico. Actualmente la USI se encuentra ubicada en el basamento de la Torre de Ingeniera del Instituto de Ingeniera.$Informacin proporcionada por: Guillermina Snchez Nahucatl.','http://www.iingen.unam.mx/es-mx/BancoDeInformacion/USI/Paginas/default.aspx','II','','P9B','','31023230152107','31023230152303','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','183.00','','',NULL,NULL,'','bib91.jpg','','','','','','Mbib91.jpg','http://amoxtli.iingen.unam.mx:8991','https://goo.gl/maps/8mHmQF93CAy','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (27,'Biblioteca. Instituto de Investigaciones Bibliotecolgicas y de la Informacin','','','Investigacin en Humanidades                                                                        ','1982','$La biblioteca fue fundada en 1982, unos meses despus de la creacin del CUIB en diciembre de 1981. Inicialmente se instal en el antiguo Colegio de San Idelfonso en el Centro Histrico de la Ciudad de Mxico. En 1988 se cambi a su sede actual en la Torre II de Humanidades en Ciudad Universitaria, donde se ubic en el piso 12, dividida fsicamente en dos secciones. $En 1989 se integr en una sola rea en el piso 13. En el ao 2000 se cambi provisionalmente de sede a las instalaciones de la Direccin de CCH, debido a la remodelacin de los tres pisos del entonces CUIB. A partir del 2002 se encuentra ocupando el piso 11 de la Torre II de Humanidades.$En 2013 con la creacin del Instituto, se consolida como una biblioteca acadmica con carcter de especializada, que rene, organiza, resguarda y difunde una importante cantidad de documentos, en las reas de bibliotecologa y estudios de la informacin, as como disciplinas afines. $Su misin es apoyar las labores de investigacin y docencia del Instituto a travs de los servicios de informacin que se ofrecen a los investigadores y alumnos del posgrado a partir de su acervo documental que se actualiza de forma constante.$$Informacin proporcionada por: Mtro. Jos Manuel Moya Valadz','http://iibi.unam.mx/servicios.html','CIB','','P2B','','32022110452107','32022110452303','0','0.00','0','0.00','0.00','0.00','0','0','408.00','El Centro Universitario de Investigaciones Bibliotecolgicas se transforma en Instituto de Investigaciones Bibliotecolgicas y de la Informacin por Acuerdo del Rector en marzo de 2012. DPLybf','',NULL,NULL,'','bib27.jpg','','','','','','Mbib27.jpg','http://iibiblio.unam.mx:8991','https://goo.gl/maps/xohBPPENYS72','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (86,'Biblioteca "Dr. Dionisio Nieto Gmez"','','','Investigacin Cientfica                                                                            ','1955','1955 ','http://www.biomedicas.unam.mx/_biblioteca/biblioteca.html','HE','','P94','','31203180152107','31203180152303','0','0.00','0.00','0.00','0.00','0.00','0.00','0.00','864.00','','',NULL,NULL,'','bib86.jpg','','','','','','Mbib86.jpg','http://bibliodgb.biomedicas.unam.mx:8991','https://goo.gl/maps/8C36qqDjM5v','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (93,'Biblioteca "Mtro. Jess Silva Herzog"','','','Investigacin en Humanidades                                                                        ','1968','El Centro de Informacin y Documentacin tiene como misin fundamental apoyar el trabajo acadmico de las unidades, seminarios y proyectos de investigacin que se desarrollan en el Instituto de Investigaciones Econmicas de la UNAM, comunidad universitaria y pblico en general.Fundado en 1968, el Centro de Informacin contiene un valioso acervo de fuentes de informacin especializada centrndose en aspectos de la problemtica econmica y social a nivel nacional y regional dentro de Amrica Latina y el Caribe, as como de asuntos a nivel internacional, poltica econmica, finanzas e instituciones financieras, comercio, medio ambiente, industria, empleo, teora econmica, entre otros interesantes temas. El catlogo bibliogrfico dispone actualmente de 18,688 ttulos de libros. Tiene integrada una coleccin de publicaciones peridicas impresas que incluye cerca de 619 ttulos, as como 219 ttulos de bases de datos en disco compacto. Asimismo, cuenta con colecciones especiales conteniendo una amplia cobertura temtica actualizada: artculos de publicaciones peridicas, bibliografas, censos econmicos y de poblacin, aspectos geogrficos del territorio nacional, enciclopedias, obras monogrficas, directorios, diccionarios, tratados y acuerdos comerciales, peridicos de circulacin nacional y aspectos legislativos, anuarios producidos por entidades nacionales y de organismos gubernamentales, regionales e internacionales, as como de otras importantes fuentes de informacin adquiridas y donadas por instituciones acadmicas. Tambin se incluye material estadstico, demogrfico, sectorial y trabajos emanados de conferencias y seminarios que anualmente organiza el Instituto. Texto tomado de la Web del Instituto de Investigaciones Econmicas.',' http://biblioteca.iiec.unam.mx/ ','IQ','','P9D','','32202130152108','32202130152304','0','0.00','0','0.00','0','0.00','0','0','910.00','','',NULL,NULL,'','bib93.jpg','','','','','','Mbib93.jpg','http://biblio192.dgbiblio.unam.mx:8991','https://goo.gl/maps/6sbqzi3sd8t','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (156,'Biblioteca. Instituto de Investigaciones en Ecosistemas y Sustentabilidad','','','Investigacin Cientfica                                                                            ','2003','','http://www.iies.unam.mx/docencia/biblioteca/','CIEC',NULL,NULL,'','','','','','','','','','','','72.00','El Centro de Investigaciones en Ecosistemas creci en docencia, investigacin e infraestructura por lo que se transforma en IIES. Gaceta 14 mayo 2015. DPLybf.','',NULL,NULL,'','bib156.jpg','','','','','','Mbib156.jpg','http://alephmor.matmor.unam.mx:8997','https://goo.gl/maps/sTfKVi5RNYv','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (20,'Biblioteca. Instituto de Matemticas Aplicadas y en Sistemas','','','Investigacin Cientfica                                                                            ','1973','1973 ','http://www.iimas.unam.mx/biblio/','CE','','P1F','','31203220152108','31203220152304','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','1067.00','En 2014 se redujo el espacio (40m2) de la biblioteca para hacer sanitarios para discapacitados','',NULL,NULL,'','bib20.jpg','','','','','','Mbib20.jpg','http://132.248.51.234:8991','https://goo.gl/maps/KiEZqNJt4cw','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (76,'Biblioteca. Instituto de Investigaciones en Materiales','','','Investigacin Cientfica                                                                            ','1967','La biblioteca del Instituto de Investigaciones en Materiales fue creada en 1967 en el entonces Centro de Investigaciones en Materiales, se localizaba en un cubculo del mismo Centro en la Torre de Ciencias hoy Torre de Humanidades II. En 1969 el Centro junto con la biblioteca se trasladaron a sus instalaciones actuales en la zona de la investigacin cientfica. Con el paso de los aos y el incremento del acervo y los usuarios la biblioteca se tuvo que mudar a la tambin entonces Unidad de Bibliotecas. Fue en junio de 1994 que se inaugur un nuevo edificio para la biblioteca, el cual fue diseado y construido ex profeso y que junto con el auditorio (con un aforo de 183 personas), constituye uno de los conjuntos ms importante del Instituto.$Actualmente la biblioteca apoya prioritariamente las labores acadmicas que realiza el personal acadmico del Instituto. Posee libros clsicos y recientes sobre ciencia e ingeniera de materiales, forman parte de la coleccin tesis elaboradas por el personal acadmico del IIM, estudiantes asociados y recientemente tesis del posgrado en ciencia e ingeniera de materiales.$Informacin proporcionada por: Lic. Mara Teresa Vzquez Meja.','http://www.iim.unam.mx/biblioteca/','GI','','P8F','','31203240152102','31203240152308','0','0.00','0','0.00','0','0.00','0','0','1297.00','El 2 de diciembre de 2010 sala nueva para la biblioteca','',NULL,NULL,'','bib76.jpg','','','','','','Mbib76.jpg','http://132.248.12.246:8991','https://goo.gl/maps/RJq7DXvNpuN2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (14,'Biblioteca "Justino Fernndez"','','','Investigacin en Humanidades                                                                        ','1936','1936 ',' http://www.esteticas.unam.mx/node/8\011\011 \011\011 ','BE','','P12','','32202140152105','32202140152301','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','741.00','','',NULL,NULL,'','bib14.jpg','','','','','','Mbib14.jpg','http://justino.esteticas.unam.mx:8991','https://goo.gl/maps/z5pjJgkCxXk','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (161,'Biblioteca "Beatriz de la Fuente"','','','Investigacin en Humanidades                                                                        ','2007','$ El Instituto de Investigaciones Estticas de la UNAM en su sede acadmica en Oaxaca da cabida a la Biblioteca Beatriz de la Fuente, instalada en uno de los salones del ex-Palacio Arzobispal, en el Centro Histrico de la ciudad a partir de mayo del 2007.$El acervo de la Biblioteca est integrado por cerca de 8,000 ejemplares y 871 fascculos de publicaciones peridicas que en su mayora pertenecieron a la Dra. Beatriz Ramrez de la Fuente (1929-2005), investigadora emrita especialista en arte prehispnico cuya perspectiva de anlisis ahondaba en la integracin plstica de la arquitectura, la escultura y la pintura en la obra de arte.$El fondo bibliogrfico comprende ttulos relativos al arte prehispnico mesoamericano en particular y a la historia del arte en general; comprende adems temas del rea de humanidades como filosofa, historia, antropologa, sociologa, economa, literatura y educacin. Nuestro creciente acervo incluye publicaciones de apoyo a las lneas de investigacin de los investigadores de la sede y alumnos de la Licenciatura en Historia del Arte de la UABJO, as como publicaciones del Instituto de Investigaciones Estticas y una importante coleccin de facsmiles de cdices prehispnicos y coloniales.$Informacin proporcionada por: Lic. Luca Mercedes Prez Rojas.','http://www.esteticas.unam.mx/node/218','BE1',NULL,'BE1','','','','','','','','','','','','164.00','','',NULL,NULL,'','bib161.jpg','','','','','','Mbib161.jpg','http://justino.esteticas.unam.mx:8991','https://goo.gl/maps/trWs7KZ14122','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (63,'Biblioteca "Dr. Rubn Bonifaz Nuo"','','','Investigacin en Humanidades                                                                        ','1988','Con el propsito de reunir en un solo acervo y un nico espacio arquitectnico los recursos humanos y documentales pertenecientes a las bibliotecas de los cuatro centros y el seminario que entonces lo integraban, el Instituto de Investigaciones Filolgicas (IIFL) cre en 1988 su Biblioteca.$En un principio, la Biblioteca del IIFL slo concentr los acervos de la Biblioteca y Hemeroteca del Centro de Estudios Literarios -creados en 1956-, la Biblioteca del Centro de Estudios Mayas -conformada en 1970 a partir de los acervos de los Seminarios de Cultura (1959) y de Escritura Maya (1967)-, la Biblioteca del Centro de Estudios Clsicos -instituida en 1973 y antecedida por la Biblioteca del Centro de Traductores de Lenguas Clsicas (1966)-, la Biblioteca del Centro de Lingstica Hispnica -fundada en 1967-, y la Biblioteca del Seminario de Potica -creada en 1977-. $sus colecciones se han ido enriqueciendo con la fundacin del Seminario de Lenguas Indgenas en septiembre de 1988, a los acuerdos interinstitucionales y las generosas donaciones de particulares. En 1961, diez mil volmenes provenientes de la biblioteca personal del Dr. Julio Jimnez Rueda fueron integrados al acervo de la Biblioteca del Centro de Estudios Literarios; en 1979, la empresa Altos Hornos de Mxico cedi al IIFL la coleccin de libros franceses de la biblioteca de Jaime Torres Bodet; en 1982, la biblioteca particular de Demetrio Sodi Morales fue donada al Centro de Estudios Mayas, y en 1991, el IIFL recibi en donacin la biblioteca del escritor Manuel Maples Arce.$El 26 de noviembre de 1996, se inaugura la Biblioteca ','http://www.iifilologicas.unam.mx/bibliotecaiifl/ ','FL','','P84','','32022190152102','32022190152308$32202190152306','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','2100.00','','',NULL,NULL,'','bib63.jpg','','','','','','Mbib63.jpg','http://filologicas.filologicas.unam.mx:8991','https://goo.gl/maps/cmPRGjDk55B2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (61,'Biblioteca "Eduardo Garca Mynez"','','','Investigacin en Humanidades                                                                        ','1940','Los antecedentes de la biblioteca se remontan al ao de 1940 cuando en el mes de enero se fund el Centro de Estudios Filosficos como parte de la Facultad de Filosofa y Letras en las instalaciones del edificio Mascarones.$Sin embargo, es hasta 1945 cuando se estableci la Biblioteca del Centro de Estudios Filosficos de manera formal. En 1954 el Centro se instal en Ciudad Universitaria, en el cuarto piso de la Torre de Humanidades. En 1966 la Biblioteca reuna ya cerca de 8,000 volmenes.$En 1967 el Consejo Universitario aprob los estatutos para que el Instituto adquiriera su actual denominacin. En 1968 la Biblioteca contaba con 15,500 volmenes y 156 ttulos de publicaciones seriadas. Dos dcadas despus el Instituto cambi de sede a las instalaciones actuales, en los terrenos de la Ciudad de las Humanidades, con un espacio diseado ex profeso para la Biblioteca.$En 1996 se inici el proyecto de ampliacin y remodelacin de la misma. En el ao 2001 se realizaron obras de ampliacin y remodelacin de la Biblioteca. En 2005 se contaba con un acervo de ms de 30 mil ttulos y ms de 40 mil volmenes y con 353 ttulos de revistas algunas de ellas disponibles en lnea.$En 2006 se llevaron a cabo obras de ampliacin y remodelacin de la biblioteca, creando dos nuevas reas: Fondo Reservado y Biblioteca Digital. Asimismo se puso en marcha el mdulo de circulacin en la nueva versin del programa de automatizacin ALEPH. En materia de desarrollo de colecciones se incorporaron libros electrnicos y se modific la pgina web de la biblioteca. En 2007 se liber el catlogo en lnea de las publicaciones seriadas.$Informacin proporcionada por: Mtro. Miguel Gama Ramrez.','http://biblio.unam.mx:8230/','FE','','P81','','32202150152102','32202150152308','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','789.00','','',NULL,NULL,'','bib61.jpg','','','','','','Mbib61.jpg','http://biblioteca1.filosoficas.unam.mx:8991','https://goo.gl/maps/UxdMZW6huWx','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (62,'Biblioteca "Rafael Garca Granados"','','','Investigacin en Humanidades                                                                        ','1954','En 1954 se cre la biblioteca; en ese ao el entonces Instituto de Historia se traslad del pequeo local que ocupaba en la Biblioteca Nacional, antiguo templo de San Agustn (Uruguay e Isabel La Catlica) al sptimo piso de la Torre de Humanidades, en Ciudad Universitaria. Fue entonces cuando por primera vez se cont con un espacio apropiado para la organizacin de la biblioteca. El cambio de sus instalaciones se realiz en 1986 a la Ciudad de la Investigacin en Humanidades, donde comparte desde aquel entonces el edificio con el Instituto de Investigaciones Estticas. La biblioteca ha sufrido dos remodelaciones arquitectnicas, la primera tuvo lugar en 1996-1997 y la segunda en 2004-2006.$El ncleo original de su acervo lo constituye la donacin de la coleccin particular de Rafael Garca Granados, fundador del Instituto y en cuyo honor la biblioteca lleva su nombre. A esta donacin se fueron agregando otras donaciones importantes, como han sido las colecciones de Juan Comas, Manuel Maldonado Koerdel, Peter Gerhard, H. Pittschman,  el Legado Miguel Muoz, la Hacienda Ysita Rubio, Ernesto de la Torre Villar y Jess de Garritz.$Las colecciones con las que cuenta la Biblioteca son la coleccin de consulta, la coleccin general, la coleccin hemerogrfica, las bases de datos Hermes e Histrica, el Fondo Reservado, la coleccin ','http://www.historicas.unam.mx/biblioteca/metabuscador.html','FH','','P83','','32202160152109','32202160152305','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','1023.00','Remodelacin de la biblioteca adaptacin de un segundo piso 2012-2013','Incorporacin de 8 mil titulos pertenecientes a la biblioteca de la Sociedad Antonio Alzate.  Gaceta 22 agosto 1994. DPLybf.',NULL,NULL,'','bib62.jpg','','','','','','Mbib62.jpg','http://exlibris.historicas.unam.mx:8991','https://goo.gl/maps/RmVFkhr3CXS2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (45,'Biblioteca "Jorge Carpizo"','','','Investigacin en Humanidades                                                                        ','1940','El Acervo Tradicional de la Biblioteca se comenz a formar desde 1940, ao en el que se fund el Instituto de Investigaciones Jurdicas.$La primera sede de la Biblioteca se aloj en el Centro Histrico de la Ciudad de Mxico en un despacho de la Calle Artculo 123, que se alquil en 1941 para alojar al entonces Instituto de Derecho Comparado. En 1945, el Instituto se traslad al anexo de la Escuela Nacional de Jurisprudencia, en San Ildefonso. Con la inauguracin de la Ciudad Universitaria, en 1954, el Instituto y su Biblioteca se mudan al tercer piso de la Torre I de Humanidades, en donde permanecen hasta 1976, ao en que se reubican en el piso cuarto, quinto y mitad del decimotercero de la Torre de Ciencias, hoy Torre II de Humanidades.$El 31 de julio de 1986 se inaugur la nueva sede del Instituto en la Ciudad de la Investigacin en Humanidades en donde se aloj la Biblioteca Jorge Carpizo en un espacio especialmente dispuesto para la misma. En el ao 2007 se construy una bveda con temperatura y humedad especiales para conservar los diez mil volmenes que conforman el Fondo Reservado de la  Biblioteca.$Informacin proporcionada por: Mtra. Rosa Mara Alvarez de Lara','http://www.juridicas.unam.mx/infjur/bib/','DC','','P60','','32202170152106','32202170152302','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','2377.00','','',NULL,NULL,'','bib45.jpg','','','','','','Mbib45.jpg','http://biblioteca.juridicas.unam.mx:8991','https://goo.gl/maps/JquSpveTpF42','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (22,'Biblioteca. Instituto de Investigaciones sobre la Universidad y la Educacin','','','Investigacin en Humanidades                                                                        ','1980','La biblioteca   fue creada  en 1976 en el Centro de Estudios sobre la Universidad (CESU) como apoyo a las investigaciones del Archivo Histrico de la UNAM (AHUNAM)  separando los materiales bibliohemerogrficos de la coleccin documental del Archivo Histrico.  $En septiembre de 2006, el H. Consejo Universitario, reconociendo la labor acadmica del CESU, cambi su denominacin y responsabilidad  institucional como Instituto de Investigaciones sobre la Universidad y la Educacin (IISUE)$Desde agosto de ese mismo ao la biblioteca ocupa sus nuevas instalaciones, en el Centro Cultural Universitario, al lado norte de la Sala Nezahualcoyotl.$Su acervo  ocupa un lugar prominente entre las bibliotecas especializadas en el campo educativo en Mxico. $Informacin proporcionada por: Graciela A. T. Alessio-Robles Paredes.','http://www.iisue.unam.mx/biblioteca/','CEU','','P22','','32042110252109','32022110252309$32032110252302$32042110252305','0','0.00','0','0.00','0.00','0.00','0.00','0.00','961.00','','',NULL,NULL,'','bib22.jpg','','','','','','Mbib22.jpg','http://biblioteca.isue.unam.mx:8991','https://goo.gl/maps/zMdWaqEmxQm','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (52,'Biblioteca. Instituto de Investigaciones Sociales','','','Investigacin en Humanidades                                                                        ','1939','El Instituto de Investigaciones Sociales (IIS) de la UNAM se distingue en el contexto latinoamericano por una labor acadmica ininterrumpida de ms de 60 aos, y en su trayectoria se manifiestan diversas tendencias temticas, as como variaciones metodolgicas y tcnicas que hasta la fecha siguen vigentes. En 1939:, el trabajo de las diversas reas del Instituto demanda ya la creacin de un espacio para resguardar el material de investigacin, de estudio y de comprobacin que se vaya obteniendo. El Dr. Mendieta organiza el Instituto en reas; en donde considera la Seccin de Biblioteca, Archivo y Relaciones Exteriores ','http://www.iis.unam.mx/indexcontent.php?_module=415&517a2b06a743137f8c3bad3be21a6e32','DS','','P73','','32202180152103','32202180152309','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','862.00','','',NULL,NULL,'','bib52.jpg','','','','','','Mbib52.jpg','http://132.248.234.82:8991','https://goo.gl/maps/GvXbshn9YsP2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (34,'Biblioteca del Campus Juriquilla','','','Investigacin Cientfica                                                                            ','1995','',' http://www.inb.unam.mx/biblioteca/biblioteca.html ','CNQ','','PF5','','31013310152103','31023310152302','0','0.00','0','0.00','0','0.00','0','0','0.00','','Las instalaciones  del Instituto de Neurobiologia se construyeron de abril a octubre de 1996 en Campus Juriquilla, con una superficie de 10 mil m2.  Gaceta  2987. 6 febrero 1996',NULL,NULL,'','bib34.jpg','','','','','','Mbib34.jpg','http://132.248.248.1:8991','https://goo.gl/maps/mudgSTkd9NF2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (118,'Biblioteca "Jess Romo Armera"','','','Investigacin Cientfica                                                                            ','1941','El Instituto de Qumica se funda el 5 de abril de 1941 gracias al empeo de su primer director (1941-1953) el Dr. Fernando Orozco y al Dr. Antonio Medinaveitia, quien haba sido nombrado investigador  del Instituto.  $El Instituto se ubicaba en la Escuela Nacional de Ciencias Qumicas de Tacuba. Constaba de dos laboratorios y una biblioteca, que en realidad se trataba de una coleccin de unos cuantos libros y una copia del Beilstein (coleccin de gran importancia para la qumica orgnica)  en cuatro tomos.  $ A partir de 1942 el Instituto  logr publicar el primer volumen del Boletn del Instituto de Qumica en diciembre de 1945.  Otra donacin que apoyara fundamentalmente la adquisicin de acervo para la biblioteca fue la del Comit Interamericano de Publicacin Cientfica de Nueva York.  Con esta donacin se adquirieron obras de consulta y colecciones de revistas, algunas de ellas desde su inicio de publicacin.$En el ao de 1954, con la construccin de Ciudad Universitaria, el Instituto se traslada a los pisos 11, 12 y 13 de la Torre de Ciencias (actualmente Torre II de Humanidades). La biblioteca se aloj en el piso 11.   $En 1977 el Instituto se traslada a sus nuevas instalaciones en donde se le da un espacio a la biblioteca con estantera cerrada y se le confiere el nombre de ','http://www.iquimica.unam.mx/biblioteca/','MQ','','PB7','','31203210152101','31203210152307','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','775.00','','',NULL,NULL,'','bib118.jpg','','','','','','Mbib118.jpg','http://132.248.11.3:8991','https://goo.gl/maps/Egn4VVtpRuR2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (124,'Biblioteca. Programa Universitario de Estudios sobre la Ciudad','','','Investigacin en Humanidades                                                                        ','1995','','http://biblio.unam.mx:8380/','PEC','','P29','','45022110852101','45022110852307','0.00','0.00','0.00','0.00','0.00','0.00','0.00','0.00','25.00','A partir de junio 2016 cambia de sede la biblioteca a Repblica de Cuba. En censo 2017 revisar que se actualizen los metros cuadrados. DPLybf','A partir del 6 de marzo de 2000 el PUEC forma parte de la Coordinacin de Humanidades. Gaceta 3375. El 15 junio 2000.DPLybf',NULL,NULL,'','bib124.jpg','','','','','','Mbib124.jpg','http://132.248.114.6:8991','https://goo.gl/maps/nLqejLAxF6M2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (157,'Biblioteca. Unidad Acadmica de Estudios Regionales ','','','Investigacin en Humanidades                                                                        ','2005','En el ao de 1976 se cre el Centro de Estudios de la Revolucin Mexicana Lzaro Crdenas A. C., en la ciudad de Jiquilpan de Jurez, Michoacn, con el objetivo de estudiar la revolucin mexicana y promover investigaciones sobre los problemas socioeconmicos de la regin. Con este cometido el Centro promovi y realiz investigaciones sobre migracin, historia y testimonios orales; adems, reuni una biblioteca, un acervo de documentos de valor histrico significativo, una hemeroteca, una coleccin de piezas prehispnicas de la regin y un museo dedicado al General Lzaro Crdenas. El 1 de diciembre de 2005 la UNAM recibi en comodato las instalaciones, el mobiliario, el acervo documental, bibliogrfico y museogrfico del Centro de Estudios de la Revolucin Mexicana Lzaro Crdenas A. C, dando lugar a la creacin de la Unidad Acadmica de Estudios Regionales (UAER) de la Coordinacin de Humanidades en atencin a los siguientes antecedentes: La experiencia del subsistema de Humanidades desde la creacin del CRIM en el ao de 1985 y de UACSHUM en 2004.  El renovado inters y compromiso de la actual administracin de la UNAM de ampliar su presencia en las distintas regiones del pas para fortalecer su carcter y responsabilidad nacional; atender lneas de investigacin de relevancia regional y en perspectiva mundial; promover la realizacin de las estrategias de investigacin que demanda la creciente complejidad del conocimiento; y la afirmacin de problemticas que requieren el concurso pluridisciplinario y la colaboracin interinstitucional. El renovado compromiso de la Coordinacin de Humanidades de impulsar la descentralizacin de la investigacin social y humanstica que se realiza en la UNAM y de fomentar nuevas estrategias de investigacin, as como en la formacin de recursos humanos y la difusin de la cultura. texto tomado de la WEB de la Unidad  Acadmica de Estudios Regionales','http://uaer.humanidades.unam.mx/biblioteca/introduccion/','UAER',NULL,NULL,'','','','','','','','','','','','223.00','Biblioteca dada de alta en 2007. DPLybf','',NULL,NULL,'','bib157.jpg','','','','','','Mbib157.jpg','http://201.109.10.69:8991','https://goo.gl/maps/yDK7GDriVBB2','NOMBREcorto');
INSERT INTO "datosbiblio" ("bib_id","nombre","nombre_abrev","adscripcion","subsistema","ano_fundacion","ref_historica","pag_web","control_dgb","control_lc","control_hx","categoria","cod_prog_lib","cod_prog_rev","prep_asig521","prep_ejer521","prep_asig523","prep_ejer523","prep_asig421","prep_ejer421","prep_enc_asig","prep_enc_ejer","superficie","observaciones","datospropbib_obs","status","spnosis","objetivo","foto","catalogolibros","catalogorev","catalogomap","ariel","contacto","fotomapa","opac","google","nombrecorto") VALUES (160,'Centro de Documentacin','','','Investigacin Cientfica                                                                            ','2006','El Centro de Investigaciones en Geografa Ambiental (CIGA) de la UNAM, tiene su origen en el Instituto de Geografa de la UNAM, en 2001 se dio la oportunidad de que un grupo de investigadores y tcnicos acadmicos se vinieran a trabajar a la Ciudad de Morelia para realizar investigaciones en temas geogrficos que coadyuven a estudiar y solucionar problemas ambientales de la regin, gracias a la poltica de descentralizacin de la UNAM y a los logros obtenidos durante estos 6 aos, se pudo crear el 17 de agosto de 2007 el Centro de Investigaciones en Geografa Ambiental, durante sus inicios se pens en contar con instalaciones adecuadas, laboratorios, aulas y el Centro de Documentacin que debera cumplir el siguiente objetivo: Centro bibliogrfico, cartogrfico y documentacin para apoyar la investigacin y docencia en geografa ambiental, que formar parte de la Red de Bibliotecas de la UNAM, con la tarea de generar una base de datos bibliogrfica automatizada, una mapoteca digital y la difusin de los productos generados a travs de medios electrnicos. El Centro de Documentacin inicia sus actividades en 2009 en un espacio ex profeso para el desarrollo de sus colecciones y servicios de informacin, durante este periodo recibi la donacin de libros y revistas tanto de particulares como de instituciones ligadas al estudio de la Geografa, actualmente alberga una coleccin de 3200 volmenes de libros,  contiene en su acervo mapas, atlas, diccionarios, enciclopedias y revistas, el Centro de Documentacin se ha especializado en temas concernientes a la Geografa Ambiental como: Ambientes Rurales, Urbanos y Periurbanos, Historia Ambiental, Territorialidad,  Paisaje, etc.. Apoya a la licenciatura en GeoHistoria que es impartida en la Escuela Nacional de Estudios Superiores Campus Morelia, as como tambin al posgrado de la Maestra en Geografa con la especialidad en Manejo Integrado del Paisaje y el Doctorado en Geografa, adems apoya aquellas personas e instituciones interesadas en este campo del conocimiento.','http://www.ciga.unam.mx/index.php/servicios/2014-04-08-23-00-28',NULL,'GG1','GG1','','','','','','','','','','','','285.99','Biblioteca dada de alta en 14 feb 2014. DPLybf','',NULL,NULL,'0','bib160.jpg','','','','','','Mbib160.jpg','http://alephmor.matmor.unam.mx:8998','https://goo.gl/maps/4rsA1fzATvx','NOMBREcorto');
--
-- Data for TOC Entry ID 59 (OID 3235359)
--
-- Name: direccion Type: TABLE DATA Owner: israeld
--


INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (94,34,94,0,'Centro Acadmico Cultural (UNAM)','Boulevard Juriquilla No. 3001','Juriquilla','','Quertaro','Mxico',31,'76230','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (17,0,17,0,'Av. Universidad No.  2001','Col.  Chamilpa','','Cuernavaca','Morelos','Mxico',161,'62210','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (207,0,104,0,'','','','','','',NULL,'0','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (13,0,13,0,'Boulevard Juriquilla No. 3001','','Juriquilla','','Quertaro','Mxico',157,'76230','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (16,0,16,0,'Privada  Xochicalco S/N','Col. Centro','Temixco','','Morelos','Mxico',160,'62580','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (100,144,100,0,'Av. Universidad 2001','Col. Chamilpa','Cuernavaca','','Morelos','Mxico',139,'62210','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (100,0,100,0,'Av. Universidad No. 2001','Col. Chamilpa','','Cuernavaca','Morelos','Mxico',330,'62210','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (8,0,8,0,'Av. Universidad S/N','Col. Chamilpa','','Cuernavaca','Morelos','Mxico',152,'62210','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (62,0,62,0,'Av. de los Barrios  No. 1 ','Col. Los Reyes Iztacala','Tlalnepantla de Baz','','Estado de Mxico','Mxico',206,'54090','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (105,0,105,0,'Antigua Carr. a Ptzcuaro No. 8701 ','Col. Ex Hacienda de San Jos de la Huerta','Morelia','','Michoacn','Mxico',341,'58190','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (215,0,109,0,'Antigua Carr. a Ptzcuaro  No. 8701, ','Col. Ex-Hacienda San Jos de la Huerta','','Morelia','Michoacn','Mxico',346,'58089','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (102,0,102,0,'Boulevard Juriquilla No. 3001','','Juriquilla','','Quertaro','Mxico',334,'76230','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (94,0,94,0,'Boulevard Juriquilla No. 3001','','Juriquilla','','Quertaro','Mxico',324,'76230','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (9,0,9,0,'Km. 107, Carr. Tijuana-Ensenada S/N','','Ensenada','','Baja California','Mxico',153,'22800','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (61,0,61,0,'Edif. de Gobierno de la FES-Cuautitln, P. A. Km. 2.5   Carr. Cuautitln-Teoloyucan','Col. San Sebastin Xhala','Cuautitln Izcalli','','Estado de Mxico','Mxico',205,'54714','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (123,0,123,0,'Antigua Carr. a Ptzcuaro No. 8701','Col. Ex-Hacienda San Jos de la Huerta','Morelia','','Michoacn','Mxico',76,'58190','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (244,0,124,0,'Blvd. UNAM 2911','El Saucillo y el Potrero','Comunidad de los tepetates','','Len, Guanajuato','',NULL,'37684','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (246,0,125,0,'Antigua carretera a Ptzcuario No. 8701','','Ex hacienda de San Jos de la Huerta','Morelia','Michoacan','',NULL,'58190','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (243,159,124,0,'Blvd. UNAM 2011.','Predio el Saucillo y el Potrero','Comunidad de los Tepetates','Len,','Gto.','Mxico',NULL,'37684','0','0');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (67,145,67,50,'Km. 5.5 Carr. Federal  Martnez de la Torre-Tlapacoyan.','','Martnez de la Torre,','','Veracruz','Mxico',140,'93600','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (67,57,67,23,'Km. 53.1 Carr. Federal Mxico-Cuernavaca.','Pueblo de Tres Maras','Huitzilac,','','Morelos','Mxico',54,'62515','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (67,134,67,21,'Km. 8, Carr. Tequisquiapan-Ezequiel Montes.','','Tequisquiapan,','','Quertaro','Mxico',130,'76790','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (103,154,103,0,' Ex sanatorio Rendn Peniche, Calle 43 s/n entre 44 y 46','Col. Industrial','Mrida,','','Yucatn','Mxico',338,'97150','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (3,94,3,0,'Av. Universidad n. 2001','Col. Chamilpa','Cuernavaca,','','Morelos','Mxico',90,'62210','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (85,161,85,54,'Edif. ex palacio Arzobispal, 1er. piso. Antonio de Len No. 2, Altos.','Centro Histrico','','Oaxaca,','Oaxaca','Mxico',NULL,'68000','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (99,90,99,0,'Mara Adelina Flores n. 34 A','Barrio de Guadalupe','San Cristbal de las Casas,','','Chiapas','Mxico',86,'29230','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (209,157,106,0,'Av.  Lzaro Crdenas s/n, esq. Felicitas del Ro. ','Col. Jiquilpan','Jiquilpan de Jurez,','','Michoacn','Mxico',NULL,'59510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (208,155,104,0,'Centro Acadmico Cultural (UNAM)','Boulevard Juriquilla n. 3001','Juriquilla,','','Quertaro','Mxico',NULL,'76230','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (123,158,123,0,'Antigua Carr. a Ptzcuaro n. 8701','Col. ex hacienda San Jos de la Huerta','Morelia,','','Michoacn','Mxico',76,'58190','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (17,24,17,0,'Av. Universidad n. 2001','Col. Chamilpa','Cuernavaca,','','Morelos','Mxico',22,'62210','La biblioteca del Centro de Ciencia Genmicas e Instituto de Biotecnologia funciona temporalmente en las instalaciones de  la Biblioteca del Instituto de Ciencias Fsicas enfrente de CCG a partir de enero 2013, disponen de acervo impreso en libros, las revistas se encuentran en bodega. 21/mayo/2013. DPLybf','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (105,156,105,0,'Antigua Carr. a Ptzcuaro No. 8701.','Col. ex hacienda de San Jos de la Huerta','Morelia,','','Michoacn','Mxico',340,'58190','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (245,160,125,0,'Antigua Carr. a Ptzcuaro n. 8701.','Col. ex hacienda de San Jos de la Huerta','Morelia','Morelia,','Michoacn','Mxico',NULL,'58190','0','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (71,3,71,1,'Km.103, Carr. Tijuana-Ensenada','','Ensenada,','','Baja California','Mxico',2,'22860','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (72,55,72,13,'Km. 30, Carr. Catemaco-Montepo.','','San Andrs Tuxtla,','','Veracruz','Mxico',52,'95701','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (74,117,74,48,'Prolong. Av. Nios Hroes s/n','Puerto Morelos,','','','Quintana Roo','Mxico',113,'77580','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (74,116,74,47,'Av. Cap. Joel Montes Camarena s/n.','Col. Cerro del Crestn','Mazatln,','','Sinaloa','Mxico',112,'82040','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (74,115,74,46,'Av. Adolfo Lpez Mateos n. 1.','Cd. del Carmen,','','','Campeche','Mxico',111,'24140','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (16,77,16,0,'Privada  Xochicalco s/n','Col. Centro','Temixco,','','Morelos','Mxico',74,'62580','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (80,88,80,45,'Av. Luis Donaldo Colosio, esq. Madrid s/n. ','Campus UNISON','Hermosillo,','','Sonora','Mxico',84,'83000','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (18,153,18,53,'Ex fbrica de San Manuel s/n.','San Miguel Contla','Mpio. Santa Cruz,','Tlaxcala,','Tlaxcala','Mxico',337,'90640','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (102,150,102,0,'Centro Acadmico Cultural (UNAM)','Boulevard Juriquilla n. 3001','Juriquilla,','','Quertaro','Mxico',NULL,'76230','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (13,89,13,0,'Centro Acadmico Cultural (UNAM)','Boulevard Juriquilla n. 3001','Juriquilla,','','Quertaro','Mxico',85,'76230','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (216,1090,109,0,'Antigua Carr. a Ptzcuaro n. 8701, ','Col. ex hacienda San Jos de la Huerta','','Morelia,','Michoacn','Mxico',347,'58190','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (73,120,73,0,'Edif. contiguo al Inst. de Inv. en Materiales. Circuito Exterior. ','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','D.F.','Mxico',116,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (47,7,47,0,'Av. Rancho Seco s/n.','Col. Impulsora','Mpio. Nezahualcyotl,','','Estado de Mxico','Mxico',5,'57130','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (47,0,47,0,'Av. Rancho Seco S/N','Col. Impulsora','Cd. Nezahualcyotl','','Estado de Mxico','Mxico',191,'57130','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (61,36,61,0,'Av. Primero de Mayo s/n.','Col. Sta. Mara las Torres','Cuautitln Izcalli,','','Estado de Mxico','Mxico',33,'54740','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (62,95,62,0,'Av. de los Barrios n. 1.','Col. Los Reyes Iztacala,','Tlalnepantla de Baz,','','Estado de Mxico','Mxico',91,'54090','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (51,0,51,0,'Av. de los Remedios No. 10','Col. Bosques de los Remedios','Naucalpan de Jurez','','Estado de Mxico','Mxico',194,'53400','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (51,39,51,0,'Av. de los Remedios n. 10.','Col. Bosque de los Remedios','Mpio. Naucalpan de Jurez,','','Estado de Mxico','Mxico',36,'53400','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (46,0,46,0,'Av. Alcanfores S/N y Av. San Juan Totoltepec','Col. Santa Cruz Acatln','Naucalpan de Jurez','','Estado de Mxico','Mxico',190,'53150','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (46,4,46,0,'Av. Alcanfores y San Juan Totoltepec.','Col. Santa Cruz Acatln','Naucalpan de Jurez,','','Estado de Mxico','Mxico',3,'53150','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (61,37,61,10,'Km. 2.5  Carr. Cuautitln-Teoloyucan. ','Col. San Sebastin Xhala','Cuautitln Izcalli,','','Estado de Mxico','Mxico',34,'54714','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (93,147,93,26,'Av. Universidad s/n','Col. Lomas de Chamilpa','Cuernavaca,','','Morelos','Mxico',142,'62210','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (67,70,67,49,'Km. 2 Carr. Jilotepec-Corrales.','Col. La Dalia','Jilotepec,','','Estado de Mxico','Mxico',67,'54240','0','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (9,73,9,0,'CNyN-UNAM. Km. 107, Carr. Tijuana-Ensenada s/n. Edif. C','','Ensenada,','','Baja California','Mxico',70,'22800','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (72,56,72,14,'Km.59, Carr. Federal  200, Barra de Navidad-Puerto Vallarta','','Chamela','','Jalisco','Mxico',53,'48895','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (248,162,126,0,'Antigua carretera a Ptzcuaro No. 8701','Col. ex hacienda San Jos de la Huerta','Morelia,','','Michoacn','Mxico',NULL,'58190','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (8,72,8,0,'Av. Universidad n. 2001.','Col. Chamilpa,','Cuernavaca,','','Morelos','Mxico',69,'62210','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (1,13,1,0,'Edif. de la ex Unidad de Bibliotecas de la Inv. Cientfica. Circuito Exterior de la Inv. Cientfica.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',11,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (7,0,7,0,'Circuito Exterior ','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',151,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (7,30,7,0,'Circuito Exterior ','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',27,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (101,0,101,0,'Circuito Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',331,'4510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (101,146,101,0,'Edif. de la ex Unidad de Bibliotecas de la Inv. Cientfica, Circuito de la Inv. Cientfica.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',141,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (10,31,10,0,'Edif. B, Stano (entre las facultades de Qumica e Ingeniera) Circuito Escolar','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',28,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (14,92,14,0,'Torre II de Humanidades 6o. piso. Circuito Escolar','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',88,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (11,0,11,0,'Av. Universidad No. 3002 (Col. Copilco)','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',155,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (15,58,15,0,'Torre II de Humanidades 1er. piso. Circuito Escolar','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',55,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (2,21,2,0,'Torre II de Humanidades 2o. piso. Circuito Escolar.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',19,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (4,0,4,0,'Circuito Mario de la Cueva, entre Filmoteca y TV UNAM','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',148,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (4,48,4,0,'Edif. entre Filmoteca y TV UNAM. Circuito Mtro. M. de la Cueva.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',45,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (6,0,6,0,'Centro Cultural Universitario','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',150,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (6,38,6,0,'Edif.  anexo  al CUT, 1er. piso, Centro Cultural Universitario, atrs de la Sala Nezahualcyotl.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',35,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (212,1070,107,0,'Edif. Consejos Acadmicos de rea, Planta Alta a un costado de la DGCCH, Circuito Exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','',343,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (211,0,107,0,'Edif. Consejos Acadmicos de rea, a un costado de la DGCCH, Circuito Exterior','Ciudad  Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',342,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (217,0,110,0,'Edif. de la Coordinacin Cientfica, Circuito de la Inv. Cientfica','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',348,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (218,1100,110,0,'Edif. de la Coordinacin Cientfica. Circuito de la Inv. Cientfica','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',349,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (219,0,111,0,'Av. Insurgentes Sur  No. 3000','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',350,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (220,1110,111,0,'Av. Insurgentes Sur n. 3000','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',351,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (26,0,26,0,'Unidad de Posgrado, Edif. H.  P. B. Circuito de Posgrados','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',170,'04510','Cambio de lugar antes de ubicaban en  circuito escolar en la unidad de posgrado a un lado de la Torre II de Humanidades  a partir de mayo de 2013 cambian a  la Unidad de Posgrado ubicado cerca de la Av. Insurgentes y la Reserva  Ecolgica del Pedregal. DPL. ybf','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (18,0,18,0,'Edif. de la CUAED, frente a la ENTS, Circuito Exterior, ','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',162,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (222,1120,112,0,'Lado Norte del Estadio Olmpico. Circuito Estadio Olmpico.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',353,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (229,0,116,0,'Edif. Rectora 2o. piso, Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',360,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (230,1160,116,0,'Edif. Rectora 2o. piso. Circuito Escolar.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',361,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (231,0,117,0,'Edif. Estudios Administrativos 2o. Piso, Circuito de la Zona Adminstrativa Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',362,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (232,1170,117,0,'Edif. Estudios Admnistrativos 2o. piso, Circuito de la Zona Administrativa Exterior','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',363,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (19,0,19,0,'Circuito Mtro. M. de la Cueva','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',163,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (19,64,19,0,'Circuito Mtro. M. de la Cueva. ','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',61,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (21,0,21,0,'Museo Universitario Arte Contemporneo, Insurgentes Sur, No. 3000','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',165,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (21,28,21,0,'Museo Universitario de Arte Contemporneo, Planta Baja. Insurgentes Sur  n. 3000.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',26,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (223,0,113,0,'Edif. C, 1er. Piso,  Circuito Zona Administrativa Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',354,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (224,1130,113,0,'Edif. C, 1er. piso. Circuito Zona Administrativa Exterior','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',355,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (30,50,30,0,'Edif. de Servicios Mdicos, Planta Baja. Entrada Principal, lado poniente. Circuito Escolar','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',47,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (30,0,30,0,'Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',174,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (23,0,23,0,'Edif. Biblioteca Central, Entrepiso. Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',167,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (23,12,23,5,'Edif. de Biblioteca Central, Planta Principal. Circuito Escolar.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',10,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (23,26,23,6,'Edif. Anexo de la D.G.B.,  contiguo a la BCCT, 1er. piso, Circuito de la Inv. Cientfica.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',24,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (31,0,31,0,'Edif.  DGCTIC. P. B., Circuito Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',175,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (31,131,31,42,'Ribera de San Cosme n. 71.','Col. Sta. Mara la Ribera','Del. Cuauhtmoc,','Mxico, ','Cd. Mx.','Mxico',127,'06400','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (31,130,31,41,'Av. Nuevo Len n. 167, Edif. DGCTIC Nuevo Len, 3er. piso.','Col. Hipdromo Condesa','Del. Cuauhtmoc,','Mxico, ','Cd. Mx.','Mxico',126,'06100','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (25,0,25,0,'Edif. B, 4o. piso, Circuito de la Zona Administrativa  Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',169,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (25,109,25,0,'Edif. B, 4o. piso, Circuito de la Zona Administrativa Exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',105,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (225,0,114,0,'Edif.  Consejos Acadmicos de rea a un costado de la DGCCH, Circuito  Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',356,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (226,1140,114,0,'Edif. Consejos Acadmicos de rea a un costado de la DGCCH. Circuito Exterior','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',357,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (24,0,24,0,'Edif. UNIVERSUM. Zona Cultural, Circuito de la Inv. en Humanidades ','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',168,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (24,123,24,0,'Edif. UNIVERSUM, Zona Cultural. Circuito de la Inv. en Humanidades.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',119,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (227,0,115,0,'Lado Sur de la Sala Nezahualcyotl, Centro Cultural Universitario','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',358,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (228,1150,115,0,'Lado Sur de la Sala Nezahualcyotl, Centro Cultural Universitario','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',359,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (233,0,118,0,'Av. Universidad No. 3000','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',364,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (234,1180,118,0,'Av. Universidad n. 3000','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',365,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (235,0,119,0,'Av. del Imn No. 5','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',366,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (237,0,120,0,'Adolfo Prieto No. 133','Col. Del Valle','Del. Benito Jurez','Mxico','Cd. Mx.','Mxico',368,'03100','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (238,1200,120,0,'Adolfo Prieto n. 133','Col. Del Valle','Del. Benito Jurez,','Mxico, ','Cd. Mx.','Mxico',369,'03100','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (32,0,32,0,'Circuito Mtro. M. de la Cueva ','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',176,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (221,0,112,0,'Lado Norte del Estadio Olimpico,  Edif. B. 3er. piso','Ciudad Universitaria','Del. Coyoacn','Mxico, ','Cd. Mx.','Mxico',352,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (32,53,32,0,'Edif. anexo a DGTV-UNAM. Planta Baja. Circuito Mtro. M. de la Cueva.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',50,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (20,0,20,0,'Lado Sur, Estacionamiento No.3, Circuito Estadio Olimpico','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',164,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (20,47,20,0,'Lado Sur, Estacionamiento no. 8. Circuito Estadio Olmpico. ','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',44,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (45,0,45,0,'Camino Viejo a Xochimilco y Viaducto Tlalpan S/N','Col. San Lorenzo Huipulco','Del. Tlalpan','Mxico','Cd. Mx.','Mxico',189,'14370','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (45,148,45,0,'Camino Viejo a Xochimilco y Viaducto Tlalpan s/n','Col. San Lorenzo Huipulco','Del. Tlalpan,','Mxico, ','Cd. Mx.','Mxico',143,'14370','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (49,0,49,0,'Circuito Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',193,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (49,135,49,0,'Circuito Exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',131,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (33,0,33,0,'Av. Insurgentes Sur esq. Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',177,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (33,19,33,0,'Av. Universidad No. 3000, 1er. piso','Ciudad Universitaria, Col. Copilco','Del. Coyoacn,','Mxico','Cd. Mx.','Mxico',17,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (50,0,50,0,'Av. Aquiles Serdn No. 2060','Col. Ex-Hacienda El Rosario','Del. Azcapotzalco','Mxico','Cd. Mx.','Mxico',194,'02410','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (66,40,50,0,'Av. Aquiles Serdn n. 2060.','Col. ex hacienda El Rosario.','Del. Azcapotzalco,','Mxico','Cd. Mx.','Mxico',37,'02410','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (52,0,52,0,'Prol. Canal de San Juan S/N esq. Av. Universidad','Col. Tepalcates','Del. Iztapalapa','Mxico','Cd. Mx.','Mxico',195,'09220','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (52,43,52,0,'Prol. Canal de San Juan s/n, esq. Av. Universidad.','Col. Tepalcates','Del. Iztapalapa,','Mxico','Cd. Mx.','Mxico',40,'09220','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (53,0,53,0,'Cataratas y Llanura S/N','Col. Jardines del Pedregal de San Angel','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',196,'04500','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (53,42,53,0,'Cataratas y Llanura s/n.','Col. Jardines del Pedregal de San Angel','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',39,'04500','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (54,0,54,0,'Av. de los Cien Metros S/N esq. Fortuna','Col. Magdalena de las Salinas','Del. Gustavo A. Madero','Mxico','Cd. Mx.','Mxico',197,'07760','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (54,41,54,0,'Av. de los Cien Metros s/n, esq. Fortuna','Col. Magdalena de las Salinas.','Del. Gustavo A. Madero,','Mxico, ','Cd. Mx.','Mxico',38,'07760','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (34,0,34,0,'Av. de las Torres y  Aldama S/N','Col. Tepepan','Del. Xochimilco','Mxico','Cd. Mx.','Mxico',178,'16020','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (34,100,34,0,'Av. de la Noria y  Prolongacin de Aldama s/n','Col. Tepepan','Del. Xochimilco,','Mxico, ','Cd. Mx.','Mxico',96,'16020','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (38,0,38,0,'Av. Ro Churubusco S/N esq. Tezontle','Col. Zapata Vela','Del. Iztacalco','Mxico','Cd. Mx.','Mxico',182,'08040','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (43,0,43,0,'Ing. Eduardo Molina No. 1577','Col. Salvador Daz Mirn','Del. Gustavo A. Madero','Mxico','Cd. Mx.','Mxico',187,'07400','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (43,104,43,0,'Av. Ing. Eduardo Molina n. 1577.','Col. Salvador Daz Mirn','Del. Gustavo A. Madero,','Mxico, ','Cd. Mx.','Mxico',100,'07400','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (37,0,37,0,'Av. Observatorio No. 170','Col.  Observatorio','Del. Miguel Hidalgo','Mxico','Cd. Mx.','Mxico',181,'11860','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (37,105,37,0,'Av. Observatorio n. 170.','Col. Observatorio','Del. Miguel Hidalgo,','Mxico, ','Cd. Mx.','Mxico',101,'11860','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (36,0,36,0,'Calz.del Hueso No.729','Col. Ex-Hacienda Coapa','Del. Tlalpan','Mxico','Cd. Mx.','Mxico',180,'14300','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (36,106,36,0,'Calz. del Hueso n. 729','Col. ex hacienda  de Coapa','Del. Tlalpan,','Mxico, ','Cd. Mx.','Mxico',102,'14000','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (41,0,41,0,'Corina No. 3','Col. Del Carmen Coyoacn','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',185,'04000','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (41,107,41,0,'Corina n. 3.','Col. Del Carmen','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',103,'04000','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (42,0,42,0,'Calz. de la Viga No. 54','Col. Merced Balbuena','Del. Venustiano Carranza','Mxico','Cd. Mx.','Mxico',186,'15810','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (42,108,42,0,'Calz. de la Viga n. 54.','Col. Merced Balbuena','Del. Venustiano Carranza,','Mxico, ','Cd. Mx.','Mxico',104,'15810','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (40,101,40,0,'Av. Lomas de Plateros s/n, esq. Dr. Fco. de la P. Miranda ','Col. Merced Gmez','Del. Alvaro Obregn,','Mxico, ','Cd. Mx.','Mxico',97,'01600','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (39,0,39,0,'Insurgentes Norte No. 1698','Col. Lindavista','Del. Gustavo A. Madero','Mxico','Cd. Mx.','Mxico',183,'07300','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (39,102,39,0,'Insurgentes Norte n. 1698,','Col. Lindavista','Del. Gustavo A. Madero,','Mxico, ','Cd. Mx.','Mxico',98,'07300','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (55,0,55,0,'Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',199,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (55,10,55,0,'Circuito Escolar,','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',8,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (55,11,55,3,'Edif. de Diseo Industrial, 1er. piso. Circuito Escolar','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',9,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (55,32,55,4,'Edif. de Posgrado de Arquitectura, Planta Baja. Unidad de Posgrado. Circuito Escolar','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',29,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (44,0,44,0,'Av. Constitucin No. 600','Col. Barrio La Concha','Del. Xochimilco','Mxico','Cd. Mx.','Mxico',188,'016210','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (44,8,44,0,'Av. Constitucin n. 600.','Col. Barrio la Concha','Del. Xochimilco,','Mxico, ','Cd. Mx.','Mxico',6,'16210','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (56,0,56,0,'Circuito Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',200,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (56,60,56,15,'Circuito Exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',57,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (58,0,58,0,'Circuito Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',202,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (58,15,58,0,'Circuito Exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',13,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (58,16,58,7,'Edif. de Posgrado a un costado de DGCTIC, Planta Baja. Circuito Exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',14,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (59,0,59,0,'Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',203,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (59,44,59,0,'Circuito Escolar.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',41,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (60,0,60,0,'Circuito Escolar','Cudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',204,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (60,133,60,0,'Circuito Escolar.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',129,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (60,33,60,9,'Edif.  de Posgrado de Economa, Stano. Zona cultural, Circuito Mtro. M. de la Cueva.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',30,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (63,0,63,0,'Av. Guelatao No. 66','Col. Ejrcito de Oriente','Del. Iztapalapa','Mxico','Cd. Mx.','Mxico',207,'09230','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (63,138,63,0,'Av. Guelatao n. 66.','Col. Unidad Habitacional Ejrcito de Oriente','Del. Iztapalapa,','Mxico,','Cd. Mx.','Mxico',134,'09230','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (63,139,63,44,'Batalla 5 de Mayo s/n, esq. Fuerte de Loreto.','Col. Unidad Habitacional Ejrcito de Oriente','Del. Iztapalapa,','Mxico, ','Cd. Mx.','Mxico',135,'09230','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (64,0,64,0,'Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',208,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (64,59,64,0,'Circuito Escolar.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',56,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (65,0,65,0,'Circuito Interior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',209,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (65,66,65,16,'Circuito Exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',63,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (65,68,65,18,'Circuito Exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',65,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (65,67,65,17,'Tacuba n. 5, Palacio de Minera. Planta Baja','Col. Centro','Del. Cuauhtmoc,','Mxico, ','Cd. Mx.','Mxico',64,'06000','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (65,75,65,19,'Tacuba n. 5, Palacio de Minera. Planta Baja.','Col. Centro ','Del. Cuahutmoc,','Mxico, ','Cd. Mx.','Mxico',NULL,'06000','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (65,65,65,0,'Circuito Escolar.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',62,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (66,0,66,0,'Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',210,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (66,80,66,0,'Edif. E, Circuito Escolar.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',77,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (66,85,66,30,'Repblica de Brasil No.33, Esq. Venezuela, Edif. Palacio de la antigua Escuela de Medicina 1er. piso','Col. Centro','Del. Cuauhtmoc','Mxico,','Cd. Mx.','Mxico',81,'06020','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (67,0,67,0,'Circuito Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',211,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (67,122,67,0,'Circuito Exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',118,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (67,69,67,20,'Manuel M. Lpez s/n.','Col. Zapotitln','Del. Tlhuac,','Mxico, ','Cd. Mx.','Mxico',66,'13209','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (48,0,48,0,'Xicotncatl No. 126','Col. Del Carmen','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',192,'04100','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (48,96,48,0,'Xicotncatl n. 126.','Col. Del Carmen','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',92,'04100','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (68,0,68,0,' Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',212,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (68,97,68,32,'Circuito Escolar.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',93,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (68,98,68,33,'Edif. de Posgrado 1er. piso, Circuito de la Inv. Cientfica.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',94,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (69,127,69,39,'Av. Universidad n. 3004, Edif. B, Planta Baja (Col. Copilco)','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',123,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (69,128,69,40,'Av. Universidad n. 3004, Edif. E, P lanta Baja (Col. Copilco)','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',124,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (70,0,70,0,'Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',300,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (70,113,70,36,'Edif. E, Planta Baja. Conjunto Facultad de Qumica. Circuito de la Inv. Cientfica.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',109,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (70,110,70,0,'Edif. A, Planta Baja. Circuito Escolar','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',106,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (70,114,70,37,'Edif. B, Planta Baja. Circuito Escolar.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',110,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (70,112,70,35,'Edif. D, 2o. piso. Conjunto Facultad de Qumica. Circuito de la Inv. Cientfica','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',108,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (70,111,70,34,'Edif. F, Planta Baja. (antes Instituto de Investigaciones Biomdicas) Circuito Escolar','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',107,'04510','Cambio de lugar, antes la biblioteca se ubicaba en el stano del edif. B de la FQ. a partir de 10 enero de 2014 pasa al edificio de Biomdicas. DPLybf','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (71,0,71,0,'Circuito de la Inv. Cientfica','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',301,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (71,2,71,0,'Circuito de la Inv. Cientfica.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',1,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (72,0,72,0,'Edif. contiguo al Jardn Botnico, 3er Circuito exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',302,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (72,54,72,12,'Edif. A, Planta Baja. 3er. Circuito exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico,   ','Cd. Mx.','Mxico',51,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (74,0,74,0,'Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',304,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (74,141,74,0,'Edif. de la Unidad de Bibliotecas de la Inv. Cientfica, Circuito de la Inv. Cientfica','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',136,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (73,0,73,0,'Edif. Contiguo a Instituto de Materiales, Circuito Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',303,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (75,0,75,0,'Circuito Deportivo','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',305,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (75,18,75,0,'Edif. contiguo al Jardn Botnico, Circuito Deportivo','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',16,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (77,0,77,0,'Circuito de la Inv. Cientfica','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',307,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (77,71,77,0,'Circuito de la Inv. Cientfica.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',68,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (76,0,76,0,'Circuito Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',306,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (76,23,76,0,'Circuito exterior s/n. Edif. entre los Institutos de Quimica y Ciencias del Mar, 1er. piso ','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',21,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (78,0,78,0,'Circuito Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',308,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (78,143,78,0,'Edif. de la Unidad de Bibliotecas de la Inv. Cientfica, Circuito de la Inv. Cientfica','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',138,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (79,0,79,0,'Circuito de la Inv. Cientfica','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',309,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (79,74,79,0,'Circuito de la Inv. Cientfica,','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',71,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (80,0,80,0,'Circuito Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',310,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (80,142,80,0,'Edif. de la Unidad de Bibliotecas de la Inv. Cientfica, Circuito de la Inv. Cientfica','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',137,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (81,0,81,0,'Edif. 1 Nivel 2, Circuito  Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',311,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (81,91,81,0,'Edif. 1 ','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',87,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (82,5,82,0,'Circuito de la Inv. Cientfica','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',4,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (5,27,5,0,'Torre II de Humanidades 11o. piso. Circuito Escolar.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',25,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (83,0,83,0,'Edif. de Apoyo ','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',313,'04520','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (83,86,83,0,'Edif. de Gobierno del I.I.Biomdicas, 1er. piso. Circuito Deportivo.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',82,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (84,93,84,0,'Edif. A, Planta Baja. Circuito Mtro.  M. de la Cueva.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',89,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (92,0,92,0,'Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',322,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (92,20,92,0,'Edif.  anexo del  IIMAS, 1er. piso, Circuito Escolar.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',18,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (91,0,91,0,'Circuito Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',321,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (91,76,91,0,'Circuito Exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',73,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (85,14,85,0,'Circuito Mtro. M. de la Cueva.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',12,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (86,63,86,0,'Circuito Mtro. M. de la Cueva. ','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',60,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (87,61,87,0,'Circuito Mtro. M. de la Cueva. ','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',58,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (88,62,88,0,'Circuito Mtro. M. de la Cueva.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',59,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (89,45,89,0,'Circuito Mtro. M. de la Cueva.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',42,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (89,46,89,11,'Circuito Mtro. M. de la Cueva.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',43,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (12,22,12,0,'Edif. del IISUE, Planta Baja. (entre Biblioteca Nacional y Sala Nezahualcyotl) ','Ciudad Universitaria','Del. Coyoacn,','Mxico,   ','Cd. Mx.','Mxico',20,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (90,52,90,0,'Edif. IIS,  Planta Baja. Circuito Mtro. M. de la Cueva.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',49,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (93,0,93,0,'Edif. entre los Institutos de Astronoma y Materiales, Circuito Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',323,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (93,78,93,0,'Edif. entre los Institutos de Materiales y Astronoma. Circuito Exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',75,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (95,0,95,0,'Circuito Exterior','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',325,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (95,118,95,0,'Edif. contiguo a Fisiologa Celular. Circuito Exterior','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',114,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (206,125,97,0,'Torre II de Humanidades 7o. piso, Circuito Escolar.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',121,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (214,1080,108,0,'Av. Ro Magdalena n. 100','Col. La Otra Banda','Del. Alvaro Obregn,','Mxico, ','Cd. Mx.','Mxico',345,'01090','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (239,0,121,0,'Edif.  Rectora 8o. Piso. Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',370,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (240,1210,121,0,'Edif. Rectora 8o. piso. Circuito Escolar','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',371,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (241,0,122,0,'Edif. Rectora 7o. Piso, Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',372,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (242,1220,122,0,'Edif. Rectora 7o. Piso, Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',373,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (90,0,90,0,'Edif. IIS, Circuito Mtro. M. de la Cueva','Ciudad Universitaria','Del. Coyoacn','Mxico,','Cd. Mx.','Mxico',320,'04510','Entidad creada en 1930. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. octubre 2015 ao XI Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (85,0,85,0,'Circuito Mtro. M. de la Cueva','Ciudad Universitaria','Del. Coyoacn','Mxico, ','Cd. Mx.','Mxico',315,'04510','En 1936 el Laboratorio de arte (fundado en 1935 ) se convierte en IIE. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (89,0,89,0,'Circuito Mtro. M. de la Cueva','Ciudad Universitaria','Del. Coyoacn','Mxico,','Cd. Mx.','Mxico',319,'04510','En 1940 se crea el  Instituto de Derecho Comparado; En 1967 se transforma en el IIJurdicas. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (84,0,84,0,'Edif. A,  2o. Piso, Circuito Mtro. M. de la Cueva S/N, ','Ciudad Universitaria','Del. Coyoacn','Mxico,','Cd. Mx.','Mxico',314,'04510','En 1940 se crea el IIEconmicas. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (88,0,88,0,'Circuito Mtro. M. de la Cueva','Ciudad Universitaria','Del. Coyoacn','Mxico,','Cd. Mx.','Mxico',318,'04510','En 1945 se crea el IIH. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (87,0,87,0,'Circuito Mtro. M. de la Cueva','Ciudad Universitaria','Del. Coyoacn','Mxico,','Cd. Mx.','Mxico',317,'04510','En 1940 se crea el  Centro de Estudios Filosficos; En 1967 adquiere rango de IIF. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (10,0,10,0,'Circuito Escolar ','Ciudad Universitaria','Del. Coyoacn','Mxico,','Cd. Mx.','Mxico',154,'04510','En 1966 se crea el CELE. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (82,0,82,0,'Circuito de la Inv. Cientfica','Ciudad Universitaria','Del. Coyoacn','Mxico,','Cd. Mx.','Mxico',312,'04510','En 1973 se funda el IIA. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (86,0,86,0,'Circuito Mtro. M. de la Cueva','Ciudad Universitaria','Del. Coyoacn','Mxico,','Cd. Mx.','Mxico',316,'04510','Entra en funciones el IIFilolgicas, incorporando al Centro de Estudios Literarios (1956), Centro de Estudios Clsicos (1966), Centro de Linguistica Hispnica (1967) y el Centro de Estudios Mayas (1970). Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (12,0,12,0,'Edif. del IISUE entre Biblioteca Nacional y Sala Nezahualcyotl, Centro Cultural Universitario','Ciudad Universitaria','Del. Coyoacn','Mxico,','Cd. Mx.','Mxico',156,'04510','En 1976 nace el Centro de Estudios sobre la Universidad; En 2006 se transforma en  I. I. sobre la Universidad y la Educacin. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (2,0,2,0,'Torre II de Humanidades, 8o Piso, Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico,','Cd. Mx.','Mxico',146,'04510','En 1979 entra en funciones el Centro Coordinador y Difusor de Estudios Latinoamericanos; en  2007 adquiere el nombre de Centro de Estudios sobre Amrica Latina y el Caribe. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (5,0,5,0,'Torre II de Humanidades, 12o Piso, Circuito Interior','Ciudad Universitaria','Del. Coyoacn','Mxico,','Cd. Mx.','Mxico',149,'04510','En 1981 se funda el Centro Universitario de Investigaciones Bibliotecolgicas. En 2012 se transforma en IIB y de la Informacin. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (3,0,3,0,'Av. Universidad S/N, 2o. Circuito Universitario','Col. Chamilpa','Cuernavaca','','Morelos','Mxico',147,'62210','En 1987 entra en funciones el CRIM antes se conocia como Centro de Investigaciones Multidiciplinarias sobre Sociedad y Cultura (1985) y el Centro de Estudios sobre la Identidad Nacional en Zonas Fronterizas (1983). Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (97,0,97,0,'Torre II de Humanidades, 7o. Piso, Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico,','Cd. Mx.','Mxico',327,'04510','En 1992 nace el PUEG. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (15,0,15,0,'Torre II de Humanidades 10o. Piso, Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico, ','Cd. Mx.','Mxico',159,'04510','En 1993 queda establecido EL CISAN, a partir del Programa Universitario de Investigaciones sobre Estados Unidos de Amrica. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (14,0,14,0,'Torre II de Humanidades 4o. Piso, Circuito Escolar','Ciudad Universitaria','Del. Coyoacn','Mxico,','Cd. Mx.','Mxico',158,'04510','En 1986 se instituye el Centro de Investigaciones Interdisciplinarias. En 1995 El CIIH amplia sus funciones como Centro de Investigaciones Interdisciplinarias en Ciencias y Humanidades. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (210,0,106,0,'Av. Lzaro Crdenas S/N,  esq.  Felicitas  del  Ro ','Jiquilpan','Jiquilpan de Jurez','','Michoacn','Mxico',NULL,'59510','En  2005 entra en funciones la Unidad Acadmica de Estudios Regionales, en Jiquilpan de Jurez, Mich. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (103,0,103,0,'Calle 43 S/N entre 44 y 46','Col. Industrial','','Mrida','Yucatn','Mxico',337,'97150','En  2007 se crea el Centro Peninsular en Humanidades y Ciencias Sociales en Mrida, Yucatn. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (99,0,99,0,'Mara Adelina Flores No. 34 A','Barrio de Guadalupe','San Cristobal de las Casas','','Chiapas','Mxico',329,'29230','En  2015 entra en funciones el Centro de Investigaciones Multidisciplinarias sobre Chiapas y la Frontera Sur a partir del Programa  de Investigaciones Multidisciplinarias sobre Mesoamrica y el Sureste. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (247,0,126,0,'Antigua carretera a Ptzcuaro No. 8701','Col. ex hacienda San Jos de la Huerta','Morelia,','','Michoacn','Mxico',NULL,'58190','El 31 de agosto  de 2015 se crea la Unidad de Investigacin sobre Representaciones Culturales y Sociales de la Coordinacin de Humanidades en ENES, U. Morelia. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (213,0,108,0,'Av. Rio de la Magdalena No. 100   \011','Col. La Otra Banda','Del. Alvaro Obregn','Mxico,','Cd. Mx.','Mxico',344,'01090','En  2004 se establece el Programa Universitario Mxico Nacin Multicultural. En 2014 el Programa Universitario Mxico Nacin Multicultural se covierte en Programa Universitario de Estudios de la Diversidad Cultural y al Multiculturalidad. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (69,0,69,0,'Av. Universidad No. 3004.  Edif. E, 1er. piso (Col. Copilco)','Ciudad Universitaria','Del. Coyoacn','Mxico, ','Cd. Mx.','Mxico',299,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (31,129,31,0,'Edif. DGCTIC.  Planta Baja. Circuito Exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico,','Cd. Mx.','Mxico',125,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (26,49,26,0,'Unidad de Posgrado, Edif. K,  Circuito de Posgrados','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',46,'04510','Cambio de lugar antes de ubicaban en  circuito escolar en la unidad de posgrado a un lado de la Torre II de Humanidades  a partir de mayo de 2013 cambian a  la Unidad de Posgrado ubicado cerca de la Av. Insurgentes y la Reserva  Ecolgica del Pedregal. DPL. ybf','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (35,0,35,0,'Adolfo Prieto No. 722, 7o. Piso','Col. Del Valle','Del. Benito Jurez','Mxico','Cd. Mx.','Mxico',179,'03100','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (35,99,35,0,'Adolfo Prieto n. 722, Planta Baja.','Col. Del Valle','Del. Benito Jurez,','Mxico, ','Cd. Mx.','Mxico',95,'03100','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (40,0,40,0,'Av. Lomas de Plateros s/n esq. Dr. Fco. de la P. Miranda ','Col. Merced Gmez','Del. Alvaro Obregn','Mxico','Cd. Mx.','Mxico',184,'01600','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (57,35,57,0,'Circuito Mtro. M. de la Cueva.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',32,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (57,0,57,0,'Circuito Mario de la Cueva ','Ciudad Universitaria','Del. Coyoacn','Mxico','Cd. Mx.','Mxico',201,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (11,119,11,0,'Av. Universidad No. 3002 (Col. Copilco)','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','0',115,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (11,121,11,38,'Ex-hacienda El Chorrillo s/n.','Taxco de Alarcn,','','','Guerrero','0',117,'40220','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (18,136,18,0,'Edif. de la CUAED, Planta Baja. frente a la ENTS. Circuito Exterior.','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','0',132,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (236,1190,119,0,'Av. del Imn n. 5','Ciudad Universitaria','Del. Coyoacn,','Mxico, ','Cd. Mx.','Mxico',367,'04510','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (98,0,98,0,'Repblica de Cuba No. 79','Col. Centro','Del.  Cuauhtmoc','Mxico, ','Cd. Mx.','Mxico',328,'06010','En 1994 inicia labores el Programa Universitario de Estudios sobre la Ciudad. Noticia publicada en HUMANIDADES Y CIENCIAS SOCIALES. Octubre 2015. Ao XI, Nmero 88. DPLybf.','Cambio de domicilio a partir de junio 2016 se encuentra en Rep. de Cuba. DPLybf.');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (98,124,98,0,'Repblica de Cuba n. 79','Col. Centro','Del. Cuauhtmoc','Mxico, ','Cd. Mx.','Mxico',120,'06010','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (44,9,44,2,'Academia n.  22. Planta Baja.','Col. Centro','Del. Cuauhtmoc','Mxico, ','Cd. Mx.','Mxico',7,'06060','','');
INSERT INTO "direccion" ("dir_id","bib_id","dep_id","subdep_id","calle","localidad","municipio","ciudad","estado","pais","apdo_id","cod_post","observaciones","dir_obs") VALUES (38,103,38,0,'Av. Ro Churubusco no. 654, entre  Av. Apatlaco y Av. Tezontle','Col. Zapata Vela','Del. Iztacalco,','Mxico, ','Cd. Mx.','Mxico',99,'08040','','');
--
-- Data for TOC Entry ID 60 (OID 3235365)
--
-- Name: coleccion Type: TABLE DATA Owner: israeld
--


INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1070,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1080,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1090,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1100,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1110,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1120,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1130,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1140,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1150,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1160,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1170,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1180,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1190,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1200,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1210,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (1220,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (145,'0','0','0','0','0','0','0','0','3102','','310000 Ciencias Agronmicas y Veterinarias','','','Maestra en Ciencias veterinarias$Produccin animal$Doctorado en Ciencias veterinarias','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (3,'4802','5670','200','14826','219','219','89 tts. = 12085 vols. ','0','348','','210000 Astronoma y Astrofsica','','','Astrofsica estelar$Astronoma extragalctica$Dinmica galctica$Instrumentacin astronmica$Medio interestelar','','Library of Congress','Fuente: Censo Automatizado del Sistema Bibliotecario de la UNAM 2009','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (156,'0','0','0','0','0','0','0','0','0','','','','Ecologia$Ecosistemas$Biodiversidad','Ciencias Ambientales$Ciencias Biolgicas','','','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (121,'0','0','0','0','0','0','0 ','0','1015','','0','','Arte$Espaol$Estudios latinoamericanos$Historia de Mxico$Lingstica$Literatura$','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (28,'0','0','0','0','0','0','0','116','114','','620000 Artes y Letras','','Arte contemporneo$Arte Moderno$Museografia$Museologia$','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (94,'0','0','0','0','0','0','0  ','0','0','','Ciencias Sociales y Humanidades','','Antropologa social$Biodiversidad$Ciencia poltica$Demografa$Economa$Educacin Superior$Sociologa','Cultura Sentimental y tica de la Convivencia$Estudios de Poblacin$ Estudios de lo Imaginario$Estudios Sobre Educacin y Formacin$Estudios Socioambientales$Programa de Cambio mundial, Globalizacin y Desarrollo$Programa Cultura, Poltica y Diversidad$Programa de Equidad de Gnero$Programa de Estudios Regionales$Programa Violencia(s), Derecho y Salud$Investigacin en Gobierno y Polticas Pblicas$','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (62,'0','0','0','0','0','0','0','0','10000','','550000 Historia','','Estados Unidos$Europa$Historia de Amrica latina$Historia de Mxico desde la poca prehispnica hasta la poca contempornea','Historia colonial $Historia Moderna y contemporanea$Historia Prehispnica','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (12,'0','0','0','0','0','0','0 ','0','1674401','','Multidisciplinaria','','Multidisciplinaria','','','Library of Congress','','Se tiene 360482 tits. = 360482 vols. de tesis en cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (30,'0','0','0','0','0','0',' 0 ','0','3477','','330000 Ciencias de la Tecnologa','','','Acstica, ptica y fotonica $Materiales avanzados y nanotecnologa$Pedagoga cognitiva de la ciencia$Tecnologas de la informacin y electrnica$Microtecnologa y tecnologas avanzadas para la instrumentacin','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (24,'0','0','0','0','0','0','0','0','2423','','Ciencias Exactas y Naturales$Tecnologas y Ciencia Agropecuarias','','','Genmica computacional$Genmica ecolgica$Evolucin genmica$Dinmica genmica$Ingeniera genmica$Genmica funcional de eucariote$Genmica funcional de procariote','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (31,'0','0','0','0','0','0','0','0','42098','','570111 Enseanza de Idiomas','','Lingstica$Lingstica aplicada$Sociolingstica$Enseanza de lenguas$Didctica de la lengua','Adquisicin de segundas lenguas por adultos$Anlisis de discurso$Aprendizaje autodirigido$ Diseo curricular y desarrollo de materiales$Evaluacin$Lengua y cultura$Lexicologa$Sociolingstica','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (119,'0','0','0','0','0','0','0','0','2100','','570111 Enseanza de Idiomas','','Enseanza del espaol como segunda lengua$Historia, literatura y arte de Mxico y Latinoamrica$','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (92,'0','0','0','0','0','0','0','0','628','','Multidisciplinaria','','Aspectos sociales, econmicos, polticos y culturales$Ciencia y tecnologa$Crisis del capitalismo$Educacin superior$Epistemologa de las ciencias$Estudios sobre la prospectiva global$Fundamentos, anlisis, teora y metodologa sobre y para el desarrollo de la interdisciplina$Investigacin feminista','rea Alternativas $rea de Estudios avanzados y vinculacin en posgrados$rea de Programas, proyectos y actividades especiales$rea de Teora y metodologa ','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (58,'0','0','0','0','0','0','0','0','1409','','Ciencias Sociales y Humanidades','','Cultura, Economa, Politica y Sociedad en la regin de Amrica del Norte','Estudios de la Globalidad$Estudios de la Integracin$Estudios Estratgicos','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (73,'0','0','0','0','0','0','0','0','0','','220000 Fsica','','','Catlisis$Fsica terica$Fsico qumica$Propiedades pticas$Nanoestructuras$Posgrado en Fsica de materiales$Ciencias fsicas e Ingeniera de materiales','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (48,'0','0','0','0','0','0','0','0','987','','620301 Cinematografa','','Cinematografa$Direccin artstica$Edicin$Guin$Produccin$Realizacin$Sonido','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (38,'0','0','0','0','0','0','0','0','799','','620310 Teatro','','Artes$Literatura$Teatro','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (49,'0','0','0','0','0','0','0','0','5128','','Multidisciplinaria','','Planes y Programas de estudios a nivel Licenciatura, Maestra y Doctorado','','','Library of Congress','0','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (153,'0','0','0','0','0','0','0','0','1946','','','','','Administracin pblica$Contadura$Derecho$Economa$Periodismo$Psicologa','','','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (136,'0','0','0','0','0','0','0','0','512','','531204 Educacin','','Educacin abierta$Educacin continua (computacin, filosofa, pedagoga y psicologa)$Educacin a distancia (medios y tecnologas)','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (64,'0','0','0','0','0','0','0','0','1438','','620301 Cinematografa','','Especializada en cinematografa nacional y extranjera','','','Numrica','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (47,'0','0','0','0','0','0','0','0','1197','','631199 Otros (Deportes)','','Historia del deporte$Medicina$Nutricin$Psicologa deportiva$Sociologa','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (26,'0','0','0','0','0','0','0 ','0','9967','','Multidisciplinaria','','Multidisciplinaria','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (131,'0','0','0','0','0','0','0','0','8256','','333100 Ciencias de la computacin','','Computacin$Tecnolologa$Telecomunicaciones','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (123,'0','0','0','0','0','0','0','0','9339','','','','Ciencia$Comunicacin$Comunicacin de las ciencias$Historia$Historia de la divulgacin de la ciencia$Medio ambiente y diversidad$Medios$Pedagoga   ','Divulgacin y difusin de las ciencias$Enseanza de las ciencias$Estudios de la ciencias$Museologa','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (129,'0','0','0','0','0','0','0','0','9918','','333100 Ciencias de la computacin','','Cmputo bsico y avanzado$Tecnologa de la Informacin$Telecomunicaciones$Cmputo aplicado$Multimedia$Realidad virtual$Visualizacin','','Espaol e Ingls','Library of Congress',' ','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (130,'0','0','0','0','0','0','0','0','4252','','333100 Ciencias de la computacin','','Computacin$Tecnologa$Telecomunicaciones','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (109,'0','0','0','0','0','0','0 ','0','1200','','560000 Ciencias Jurdicas y Derecho','','Derecho$Educacin superior$Legislacin universitaria','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (50,'0','0','0','0','0','0','0','0','2426','','321500 Administracin de Hospitales y de la Atencin Mdica','','Educacin para la salud$Orientacin en salud$Salud ambiental','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (53,'0','0','0','0','0','0','0','0','535','','332509 Televisin','','Cine$Comunicacin$Fotografa$Literatura$Radio$Televisin','','','Library of Congress',' ','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (148,'0','0','0','0','0','0','0 ','0','258627','','320000 Medicina y Patologa Humanas','','','Enfermera y Obstetricia','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (96,'0','0','0','0','0','0','0','0','13852','','620000 Artes y Letras','','','Canto $Composicin $Educacin musical $Etnomusicologa $Instrumentista $Piano$ Maestra y Doctorado en Msica','','Library of Congress','','En tesis se registraron tits. y vols. de formato cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (135,'0','0','0','0','0','0','0','0','274995','','630000 Sociologa','','','Trabajo social','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (19,'0','0','0','0','0','0',' 0 ','0','600','','Muldisciplinaria','','','','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (40,'0','0','0','0','0','0','0. ','0','30782','','Multidisciplinaria','','','Area 1 Matemticas $Area 2 Ciencias experimentales $Area 3 Histrico social $Area 4 Talleres de lenguaje y comunicacin','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (39,'0','0','0','0','0','0','0','0','450000','','Multidisciplinaria','','','Area 1 Matemticas $Area 2 Ciencias experimentales $Area 3 Histrico social. $Area 4 Talleres de lenguaje y comunicacin','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (43,'0','0','0','0','0','0','0 ','0','509000','','Multidisciplinaria','','','Area 1 Matemticas $Area 2 Ciencias experimentales $Area 3 Histrico social $Area 4 Talleres de lenguaje y comunicacin','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (42,'0','0','0','0','0','0','0','0','595000','','Multidisciplinaria','','','Area 1 Matemticas $Area 2 Ciencias experimentales $Area 3 Histrico social $Area 4 Talleres de lenguaje y comunicacin','Espaol $Ingls ','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (41,'0','0','0','0','0','0',' 0 ','0','752500','','Multidisciplinaria','','','Area 1 Matemticas $Area 2 Ciencias experimentales $Area 3 Histrico social $Area 4 Talleres de lenguaje y comunicacin','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (100,'0','0','0','0','0','0','0','0','354806','','Multidisciplinaria','','','Fsico matemticas $Ciencias biolgicas y de la salud $Ciencias sociales $Humanidades y arte','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (103,'0','0','0','0','0','0','0 ','0','403786','','Multidisciplinaria','','','Fsico matemticas $Ciencias biolgicas y de la salud $Ciencias sociales $Humanidades y arte','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (104,'0','0','0','0','0','0','0','0','475823','','Multidisciplinaria','','','Fsico matemticas $Ciencias biolgicas y de la salud $Ciencias sociales $Humanidades y arte','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (105,'0','0','0','0','0','0','0','0','427593','','Multidisciplinaria','','','Fsico-matematicas $Ciencias biolgicas y de la salud $Ciencias sociales $Humanidades y arte','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (106,'0','0','0','0','0','0','0 ','0','859339','','Multidisciplinaria','','','Fsico matemticas $Ciencias biolgicas y de la salud $Ciencias sociales $ Humanidades y arte','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (107,'0','0','0','0','0','0','0','0','426000','','Multidisciplinaria','','','Fsico matemticas $Ciencias biolgicas y de la salud $Ciencias sociales $Humanidades y arte','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (108,'0','0','0','0','0','0','0','0','449679','','Multidisciplinaria','','','Fsico matemticas $Ciencias biolgicas y de la salud $Ciencias sociales $Humanidades y arte','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (101,'0','0','0','0','0','0','0 ','0','559248','','Multidisciplinaria','','','Fsico matemticas $Ciencias biolgicas y de la salud  $Ciencias sociales $Humanidades y arte','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (102,'0','0','0','0','0','0',' 1407 tts. = 6906 vols. ','0','524238','','Multidisciplinaria','','','Fsico matemticas $Ciencias biolgicas y de la salud $Ciencias sociales $Humanidades y arte','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (10,'0','0','0','0','0','0','0','6002','150000','','620100 Arquitectura','','','Arquitectura $Arquitectura de paisaje $Diseo industrial $Urbanismo','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (32,'0','0','0','0','0','0','0','0','15000','','620100 Arquitectura','','','Especilizacin en vivienda, cubiertas ligeras, valuacin inmobiliaria$Maestra en Arquitectura$Diseo Industrial$Tecnologa$Urbanismo$Doctorado en Arquitectura','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (60,'0','0','0','0','0','0','0','0','0','','Multidisciplinaria','','','Actuara$Biologa$Ciencias ambientales$Ciencias de la computacin$Fsica$Manejo sustentable de zonas costeras$Matemticas$Maestra y Doctorado en Ciencias matemticas$','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (11,'0','0','0','0','0','0','0','0','25920','','620100 Arquitectura. Ergonomia. Diseo','','','Diseo Industrial','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (133,'0','0','0','0','0','0','0','0','572889','','530000 Ciencias Econmicas','','','Economa','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (33,'0','0','0','0','0','0','0','0','38060','','530000 Ciencias Econmicas','','','Economa','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (37,'0','0','0','0','0','0','0','0','106850','','Multidisciplinaria','','','Administracin$Contadura$Informtica$Ingeniera agrcola$Ingeniera mecnica elctrica$Medicina veterinaria y zootecnia$Maestra en Administracin$Ciencias de la prod. y de la salud animal$Ciencias Qumicas$Ingeniera$Doctorado en Ciencias de la prod. y de la salud animal$Ciencia e ingeniera de la computacin$Ciencias Qumicas$Ingeniera','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (95,'0','0','0','0','0','0',' 0 ','0','821286','','Multidisciplinaria','','','Biologa$Cirujano dentista$Enfermera$Mdico cirujano$Optometra$Psicologa ','','Library of Congress','','En tesis se incluyen  vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (139,'0','0','0','0','0','0','0','0','466000','','Multidisciplinaria','','','Biologa$Ingeniera qumica$Qumica Farmacutico Biolgica$Maestra en Administracin$Ciencias biolgicas$Enfermera$Psicologa (Educacin especial)$Psicopatologa (Neuropsicologa)$Trabajo social$Doctorado en Ciencias biolgicas$Psicologa','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (59,'0','0','0','0','0','0','0','0','976814','','Multidisciplinaria','','','Bibliotecologa$Estudios Latinoamericanos$Filosofa$Geografa $Historia$Letras clsicas$Letras hispnicas$Letras modernas$Literatura dramtica y teatro$Pedagoga$Maestra y Doctorado en: Antropologa; Bibliotecologa y Estudios de la Informacin; Estudios Latinoamericanos; Estudios Mesoamericanos; Filosofa; Filosofa de las Ciencias; Geografa; Historia; Historia del Arte; Letras; Linguistica; Pedagoga','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (138,'0','0','0','0','0','0','0','0','486268','','Multidisciplinaria','','','Cirujano dentista $Enfermera $Mdico cirujano$Psicologa$Maestra en Administracin$Ciencias Biolgicas$Enfermera$Psicologa(Educacin especial)$Psicopatologa(Neuropsicologa)$Trabajo social$Doctorado en Ciencias Biolgicas$Psicologa','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (68,'0','0','0','0','0','0','0 ','0','779481','','330000 Ciencias de la Tecnologa','','','Ingeniera civil$Ingeniera de minas y metalurga$Ingeniera elctrica y electrnica$Ingeniera en computacin$Ingeniera en telecomunicaciones$Ingeniera geofsica$Ingeniera geolgica$Ingeniera geomtica$Ingeniera industrial$Ingeniera mecnica$Ingeniera mecatrnica$Ingeniera petrolera ','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (66,'0','0','0','0','0','0','0 ','0','64172','','330000 Ciencias de la Tecnologa','','','Posgrado en: Ingeniera ambiental$Ingeniera civil$Ingeniera elctrica$Ingeniera mecnica$Ingeniera petrolera y gas natural$Ingeniera de sistemas$Energa$Qumica','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (65,'0','0','0','0','0','0','0 ','0','710230','','330000 Ciencias de la Tecnologa','','','Ingeniera civil $Ingeniera de minas y metalurga $Ingeniera elctrica y electrnica $Ingeniera en computacin $Ingeniera en telecomunicaciones $Ingeniera geofsica $Ingeniera geolgica $Ingeniera geomtica$Ingeniera industrial $Ingeniera mecnica $Ingeniera mecatrnica$Ingeniera petrolera ','Ingls$Espaol','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (67,'0','0','0','0','0','0','0','0','1835','','330000 Ciencias de la Tecnologa','','','Ingeniera civil$Ingeniera de minas y metalurga$Ingeniera elctrica y electrnica$Ingeniera en computacin$Ingeniera en telecomunicaciones$Ingeniera geofsica$Ingeniera geolgica$Ingeniera geomtica$Ingeniera industrial$Ingeniera mecnica$Ingeniera mecatrnica$Ingeniera petrolera ','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (80,'0','0','0','0','0','0','0','15746','825000','','320000 Medicina y Patologa Humanas','','Anatoma$Bioqumica$Ciruga$Embriologa$Farmacologa$Fisiologa$Gentica$Histologa$Inmunologa$Medicina clnica$Medicina interna$Microbiologa$Propedutica$Psicologa mdica$Salud pblica','Investigacin Biomdica Bsica $Mdico cirujano','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (85,'0','0','0','0','0','0','0','0','6200','','320000 Medicina y Patologa Humanas','','','Historia y filosofa de la medicina','','Library of Congress $Dewey','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (57,'0','0','0','0','0','0','0','0','120','','310000 Ciencias Agronmicas y Veterinarias','','','Maestra en Ciencias veterinarias$Produccin animal$Doctorado en Ciencias veterinarias','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (134,'0','0','0','0','0','0','0','0','190','','310000 Ciencias Agronmicas y Veterinarias','','','Maestra en Ciencias veterinarias$Produccin animal$Doctorado en Ciencias veterinarias','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (122,'0','0','0','0','0','0','0','0','825800','','310000 Ciencias Agronmicas y Veterinarias','','','Medicina veterinaria y zootecnia$Maestra en Ciencias veterinarias$Produccin animal$Doctorado en Ciencias veterinarias','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (69,'0','0','0','0','0','0','0','0','117','','310000 Ciencias Agronmicas y Veterinarias','','','Maestra en Ciencias veterinarias$Produccin animal$Doctorado en Ciencias veterinarias','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (70,'0','0','0','0','0','0','0','0','60','','310000 Ciencias Agronmicas y Veterinarias','','','Maestra en Ciencias veterinarias$Produccin animal$Doctorado en Ciencias veterinarias','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (97,'0','0','0','0','0','0','0','0','454414','','320000 Medicina y Patologa Humanas','','','Cirujano Dentista','','Library of Congress','','En tesis se incluyen tits. y vols. de formato en cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (98,'0','0','0','0','0','0','0','0','110186','','320000 Medicina y Patologa Humanas','','','Maestra y Doctorado en: Ciencias mdicas, Odontolgicas y de la Salud','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (127,'0','0','0','0','0','0','0','0','393910','','610000 Psicologa','','','Psicologa','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (128,'0','0','0','0','0','0','0','0','55385','','610000 Psicologa','','','Maestra y Doctorado en Psicologa','Ingls$Espaol','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (113,'0','0','0','0','0','0','0','0','3903','','230000 Qumica','','','Maestra y Doctorado en Ciencias Bioqumicas$Ciencias Qumicas$Posgrado en Ciencia e ingeniera de materiales$Ciencias de la Administracin$Ciencias del Mar y Limnologa$Especializacin en Bioqumica clnica','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (110,'0','0','0','0','0','0','0 ','0','752026','','230000 Qumica','','','Ingeniera qumica $Ingeniera qumica metalrgica $Qumica $Qumica de alimentos $Qumica farmacutica biolgica','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (114,'0','0','0','0','0','0','0 ','0','50354','','230000 Qumica','','','Ingeniera qumica$Ingeniera qumica metalrgica$Qumica$Qumica de alimentos$Qumica Farmacetica Biolgica','','','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (112,'0','0','0','0','0','0','0 ','0','0','','230000 Qumica','','','Ingeniera Qumica metalrgica$Maestra y Doctorado en Ciencias Bioqumicas$Ciencias Qumicas$Posgrado en Ciencia e Ingeniera de Materiales$Ciencias de la Administracin$Ciencias del Mar y Limnologa$Especializaciones en Bioqumica Clnica','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (111,'0','0','0','0','0','0','0','0','6511','','230000 Qumica','','','Maestra y Doctorado en Ciencias bioqumicas$Ciencias qumicas$Posgrado en  Ciencia e Ingeniera de Materiales$Ciencias de la Administracin$Ciencias del Mar y Limnologa $Especializacin en Bioqumica Clnica$Maestra de Enseanza en Educacin Media y Superior$','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (55,'0','0','0','0','0','0','0','0','70','','240000 Ciencias de la Vida','','','Ecologa de primates, otros mamferos y aves$Diversidad, manejo y economa forestal$Ornotologa y coleciones en general$Taxonoma de reptiles y anfibios$Taxonoma vegetal','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (56,'0','0','0','0','0','0','0','0','455','','240000 Ciencias de la Vida','','','Ecologa e historia natural$Educacin ambiental$Faunstica$Florstica$Taxonoma y sistemtica','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (54,'0','0','0','0','0','0','0','0','7513','','240000 Ciencias de la Vida','','','Biologa estructural$Biologa evolutiva$Biologa molecular$Ciencias biolgicas$Maestras en  Biogeografa$Evolucin$Paleobiologa$Sistemtica','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (117,'0','0','0','0','0','0','0 ','0','842','','240000 Ciencias de la Vida','','','Comunidades coralinas$Crustceos$Fotobiologa$Geologa de arrecifes$Microbiologa$Pastos marinos$Plancton$Toxinologa','Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (72,'0','0','0','0','0','0','0 ','0','1141','','220000 Fsica','','','Biofsica y Ciencia de materiales $Fsica atmica, molecular y ptica $Fsica terica $Fsica no-lineal ','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (120,'0','0','0','0','0','0','0','0','0','','220000 Fsica$230000 Qumica','','','Estructura de la materia$Fsica de altas energas$Fsica de plasmas$Gravitacin y teora de campos$Qumica de radiacin y raduioqumica','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (77,'0','0','0','0','0','0','0','0','2840','','220000 Fsica','','','Materiales solares$Sistemas energticos$Termociencias','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (71,'0','0','0','0','0','0','0','0','0','','220000 Fsica','','','Aplicaciones mdico biolgicas$Exploracin del universo$Nuevos materiales$Sistemas complejos$Tecnologa cuntica$Visin unificada de las fuerzas$Posgrado en Ciencias fsicas$Maestra en Fsica Mdica','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (5,'0','0','0','0','0','0','0','0','6525','','510000 Antropologa','','Antropologa fsica$Antropologa social$Arqueologa$Etnologa$Lingstica antropolgica','Antropologia ambiental$Antropologa biolgica$Antropologa del patrimonio natural, cultural, histrico, arqueolgico e industrial$Antropologa de la muerte$Antropologa de las sociedades urbanas y rurales desde sus origenes$Funcin simblica y sistemas representativos','','Propia','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (86,'0','0','0','0','0','0','0','0','18520','','Ciencias Exactas y Naturales$Tecnologas y Ciencias Mdicas','','','Biologa celular$Fisiologa$Biologa molecular$Biotecnologa$Inmunologa$Medicina genmica$Toxicologa ambiental$Doctorado en Ciencias biomdicas','','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (93,'0','0','0','0','0','0','0','0','3451','','530000 Ciencias Econmicas','','Economa','Departamento de anlisis$Economa aplicada $Economa de la educacin, la ciencia y tecnologa$Economa del sector energtico$Economa del sector primario y medio ambiente$Economa del  trabajo y de la tecnologa$Economa fiscal y financiera$Economa industrial$Economa mundial$Economa poltica del desarrollo$Economa urbana y regional$Historia econmica$Macroeconmicos prospectivos y de coyuntura','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (20,'0','0','0','0','0','0','0','0','10400','','120000 Matemticas','','','Ciencias de la computacin$Ingeniera de sistemas computaciones y automatizacin$Matemticas y mecnica$Mtodos matemticos y numricos$Modelacin matemtica de sistemas sociales$Probabilidad y estadstica$Especializacin en Estadstica aplicada$Posgrado  en Ciencia e Ingeniera de la Computacin$Posgrado de Ciencias Matemticas$','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (76,'0','0','0','0','0','0','0','0','10438','','331200 Tecnologa de los Materiales','','','Biomateriales$Dinmica no lineal y reologa$Estructura electrnica y fonnica de los materiales$Materiales cermicos$Mecnica de fluidos$Polmeros estructurales$Procesos de solidificacin $Maestra y Doctorado en Ciencia e Ingeniera de materiales','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (63,'0','0','0','0','0','0','0','0','51906','','Ciencias Sociales y Humanidades','','Civilizacin y cultura grecorromana, medieval y maya$Filologa$Fnetica$Gramtica$Lenguas y literaturas grecolatinas, hispnicas y amerindias$Lexicologa$Lingstica$Morfologa$Potica$Semitica','Estudio del espaol como  lengua materna$Estudios sincrnico y diacrnico del espaol$Lengua y literatura griegas$Lengua y literatura latinas$Tradicin Clsica en Mxico','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (22,'0','0','0','0','0','0','0','0','7257','','580203 Planificacin  y Financiacin de la Educacin','','Educacin$Estudios sobre la Universidad','Archivo histrico de la UNAM$Campo terico de la educacin$Educacin superior$Evaluacin educativa$Formacin profesional y planes de estudio$Historia de la educacin$Poltica educativa nacional, educacin, ciencia, tecnologa y cultural$Temas emergentes en el campo de la educacin$Vida cotidiana y dimensin pedaggica del trabajo en el aula','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (147,'0','0','0','0','0','0','0','0','1844','','120000 Matemticas','','','lgebra$Anlisis$Ecuaciones diferenciales$Fsica-matemtica$Geometra$Modelacin matemtica$Optimizacin y combinatoria$Sistemas dinmicos$Teora de singularidades$Topologa','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (78,'0','0','0','0','0','0','0','0','7895','','120000 Matemticas','','','Algebra $Anlisis matemtico$Cmputacin cientfica $Docencia y formacin$Ecuaciones diferenciales $Estadstica$Geometra$Matemticas discretas$Probabilidad$Sistemas continuos$Topologa$Especializacin en estadstica aplicada$Doctorado en reas del conocimiento','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (118,'0','0','0','0','0','0','0 ','0','0','','230000 Qumica','','','Bioqumica $Fisicoqumica$Productos naturales$Qumica analtica $Qumica de productos naturales $Qumica inorgnica $Sntesis orgnica','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (34,'0','0','0','0','0','0','0','0','0','','Ciencias Exactas y Naturales','','Neurobiologa celular y molecular$Neurobiologa conductual y cognitiva$Neurobiologa del desarrollo$Neurofisiologa','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (161,'0','0','0','0','0','0','','0','0','','','','Arte / Arte en Mxico','Arte rupestre / Arte prehispnico mesoamericano','','','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (99,'0','0','0','0','0','0','0','0','2752','','Multidisciplinaria','','','','Espaol $Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (160,'0','0','0','0','0','0','','0','0','','0','0','Geografa','Geografa$Historia de la Geografa$Medio Ambiente y Recursos Naturales$ Estados y Regiones de la Repblica Mexicana','','','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (2,'0','0','0','0','0','0','0','0','0','','210000 Astronoma y Astrofsica','','','Arqueoastronoma$Astrofsica estelar y extragalctica$Cosmologa$Estrellas$Galctica planetaria$Galaxias$Instrumentacin astronmica$Medio interestelar$ptica atmosfrica$Telescopios','','Library of Congress','Gaceta 9 enero 2014. Donacin del Fondo Arcadio Poveda que consta de 97 cajas incluye proyectos de investigacin, publicaciones, manuscritos. DPLybf.','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (144,'0','0','0','0','0','0','','0','0','','Ciencias Exactas y Naturales','','','Ingenieria Celular y Biocatlisis$ Biologa Molecular de Plantas$ Gentica del Desarrollo y Fisiologa Molecular$Microbiologa Molecular$ Medicina Molecular y Bioprocesos ','','','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (23,'0','0','0','0','0','0','0 ','0','2137','','Ciencias Exactas y Naturales$Tecnologas y Ciencias Mdicas','','','Investigacin bsica: Bioqumica y Biologia estructural, Gentica molecular, Biologia celular y del desarrollo$ Investigacin en Neurociencias$Doctorado en Ciencias biomdicas$Maestra y doctorado en Ciencias bioqumicas$Maestra y doctorado en Ciencias Biolgicas','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (157,'0','0','0','0','0','0','0','0','235','','','','Historia de Mxico$Ciencias Sociales$Michoacn','Accin colectiva en el manejo integral de los recursos hdricos$Organizaciones indgenas-campesinas y desarrollo local$Estudios regionales','Espaol','','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (155,'0','0','0','0','0','0','0','0','0','','','','Acstica$Catlisis$Corrosin$Dispersin de luz$Espectroscopa ptica y elctrica$Fibras pticas de plstico$Instrumentacin$Lseres$Materiales cermicos$Materiales compositos$Morfognesis$Reometra$Neurobiologia celular y molecular$Tectnica y geologa estructural y sismologia','Fsica aplicada$Neurobiologa$Geociencias','','','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (150,'0','0','0','0','0','0','0','0','0','','0','0','Acstica$Catlisis$Corrosin$Dispersin de luz$Espectroscopa ptica y elctrica$Fibras pticas de plstico$Instrumentacin$Lseres$Materiales cermicos$Materiales compositos$Morfognesis$Reometra','','','',' ','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (89,'0','0','0','0','0','0','0','0','0','','250000 Ciencias de la Tierra y del Cosmos','','Tectnica, geologa estructural y sismologa $Magmatismo y petrognesis $Geomagnetismo y Exploracin geofsica $Geofluidos','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (13,'0','0','0','0','0','0','0','0','11141','','250000 Ciencias de la Tierra y del Cosmos ','','Agrometeorologa$Geocronologa$Metereologa$Modelos climticos$Sismologa$Termocronologa$Vulcanologa$Geomagnetismo$Fisica espacial$Biologa marina$Ecologa$Geoqumica$Geofsica$Geologa$Tctnica','','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (143,'0','0','0','0','0','0','','0','0','','250000 Ciencias de la Tierra y del Cosmos','','Radiacin solar$Sismologia$Vulcanologia$Geomagnetismo y Exploracin geofsica$Recursos naturales$Ciencias espaciales','','Ingls$Espaol','Library of Congress','El dato de colecciones se registra en la Biblioteca Conjunta de Ciencias de la Tierra (BCCT)','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (142,'0','0','0','0','0','0','','0','0','','250000 Ciencias de la Tierra y del Cosmos','','Paleontologia experimental$Difraccin de Rayos X$Espectrometria de masas$Palcoambientes$Palentologia y Palinologia$Fertilidad de suelos$Fsica de suelos$Invernadero','Geologia Regional$Geoqumica$Paleontologia$Edafologia','','','El dato de colecciones se registra en la Biblioteca Conjunta de Ciencias de la Tierra (BCCT)','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (141,'0','0','0','0','0','0','','0','0','','Ciencias Exactas y Naturales','','','Biologa Acutica$Geologia Marina$Limnologia$Qumica Acutica$Oceanografia Fsica','Ingls$Espaol','Library of Congress','El dato de colecciones se registra en la Biblioteca Conjunta de Ciencias de la Tierra (BCCT)','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (146,'0','0','0','0','0','0','','0','0','','Ciencias Exactas y Naturales','','Aerobiologa$Cambio climtico y Radiacin solar $Citogentica y Mutagnesis ambiental$Meteorologa tropical, Climatologia urbana$','Ciencias Ambientales$Ciencias Atmsfericas','Ingls$Espaol','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (115,'0','0','0','0','0','0','0 ','0','36','','240000 Ciencias de la Vida','','','Oceonografa biolgica$Oceonografa Fsica$Oceonografa Geolgica$Oceonografa Qumica y Limnologa','Ingls$Espaol','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (116,'0','0','0','0','0','0','0','0','0','','240000 Ciencias de la Vida','','','Biologa Marina$Geologa Marina$Limnologa$Oceanografa Fsica$Qumica Acutica','Ingls $Espaol','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (88,'0','0','0','0','0','0','0','0','1500','','250000 Ciencias de la Tierra y del Cosmos','','Ecologa$Estudios geolgico-ambientales en Mxico$Evolucin Tectnica de Mxico$Origen y evolucin de cuencas sedimentarias$Volcanismo y tectnica del Cenozoico$Petrognesis, Estratigrafa y geocronologa del magmatismo Mesozoico y Cenozoico$Posgrados en Ciencias de la tierra$Biolgicas y Biomdicas','Geologia Regional$Geoqumica$Paleontologia$Edafologia$Qumica y micropaelentologia$Corte y Laminacin de rocas$Petrografa','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (91,'0','0','0','0','0','0','0','0','894','','330000 Ciencias de la Tecnologa','','','Ecosistemas$Infraestructura y Ciencias de la Tierra$Recursos Hdricos$Transporte$Energa$Planeacin$Tecnologas de la Informacin$Vivienda$Formacin de Recursos Humanos: Maestra y Doctorado en Ingeniera','','Numrico','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (21,'0','0','0','0','0','0','0','0','3702','','630106 Caractersticas y Civilizacin Nacionales','','Filosofa e historia de las ideas en Amrica Latina y el Caribe$Historia de Amrica Latina y el Caribe $Poltica, economa y sociedad en Amrica Latina y el Caribe $Literatura y ensayo latinoamericanos y del Caribe','Estudios Latinoamericanos  ','Espaol$Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (90,'0','0','0','0','0','0',' 0 ','0','2833','','Ciencias Sociales y Humanidades','','Ciudadania y derechos indigenas$Movimientos sociales y resistencias$ Municipalismo y poder local$Transfronterismo e integracin Centroamericana$Estudios Chiapanecos y Centroamericanos','Ciudadania y movimientos sociales$Migracin$Identidades y fronteras$Territorio y cambio ambiental global','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (154,'0','0','0','0','0','0','0','0','1843','','','','Antropologia$Historia$Etnologia$Filosofia$Economa$Literatura$Linguistica$Arqueologia$Cultura maya','','','','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (27,'0','0','0','0','0','0','0','0','0','','591104 Bibliotecologa','','Bibliotecologa$Ciencias de la Informacin$Estudios de la informacin','Educacin bibliotecolgica$Historia y fundamentos de la bibliotecologa y estudios de la informacin$Informacin, conocimiento y sociedad$Lectura$Metra de la informacin y del conocimiento cientfico$Organizacin de la informacin y el conocimiento$Servicios y recursos de informacin$Tecnologas de la informacin y del conocimiento$Usuarios de la informacin','Espaol$Ingls','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (14,'0','0','0','0','0','0','0','0','15262','','620305 Esttica de las Bellas Artes','','Conservacin del patrimonio cultural$ Esttica$Historia $Teora crtica del arte','Arte mundial$Arte colonial$Arte contemporneo $Arte indgena en Amrica $Pensamiento artstico','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (52,'0','0','0','0','0','0','0 ','0','8965','','Ciencias Sociales y Humanidades','','Sociologa','Actores y procesos sociales$Estudios agrarios$Estudios de la educacin y la ciencia $Estudios urbanos y regionales$Gobierno, procesos y actores sociales$Historia social y poltica$Instituciones polticas$Poblacin y estudios demogrficos$Sociedad y cultura$Sociologa de los procesos polticos$Sociolingustica y cultura ','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (61,'0','0','0','0','0','0','0 ','0','0','','Ciencias Sociales y Humanidades','','Filosofia','Epistemologa$Esttica$Etica$Filosofa de la ciencia $Filosofa del lenguaje $Filosofa de la mente$Filosofa poltica $Filosofa de la religin $Filosofa en Mxico$Filosofa del derecho$Filosofa de la historia e historia intelectual$Historia de la filosofa$Lgica$Metafisica','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (45,'0','0','0','0','0','0','0 ','0','13380','','560000 Ciencias Jurdicas y Derecho','','Derecho','Derecho administrativo $Derecho ambiental$Derecho civil y mercantil$Derecho constitucional $Derecho de la informacin$Derecho electoral y procesos democrticos$Derecho fiscal$Derecho internacional$Derecho penal $Derecho procesal$Derecho social$Filosofa y teora del derecho $Historia del derecho$Investigacin aplicada y opinin$Ncleo de estudios de salud y derecho$Ncleo Multidisciplinario sobre el derecho de las mujeres a una vida libre de violencia$Sociologa del derecho','','Propia','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (46,'0','0','0','0','0','0','0','0','3640','','560000 Ciencias Jurdicas y Derecho','','Derecho Civil$Constitucional$Laboral$Legislacin federal y estatal$Penal$','Jureconst-Sistema de informacin jurdico constitucional$JusLab-SIstema de informacin jurdico laboral$ISSSTEJure-Sistema de informacin jurdico del ISSSTE$UniJus- Sistema de informacin jurdico universitario','Espaol','Propia','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (125,'0','0','0','0','0','0','0 ','0','2700','','630909 Condicin de la Mujer','','Acoso sexual$Cultura e interculturalidad$Derechos humanos de las mujeres$Diversidad sexual$Equidad$Hostigamiento y acoso social$Identidad y sexualidad$Masculinidad$Migracin$Violencia de gnero','Cuestiones terico metodolgicas$Cultura y educacin $Estado, derecho y participacin social $Poblacin y salud $Subjetividad e identidad $Trabajo y medio ambiente ','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (124,'0','0','0','0','0','0','0','0','98','','Tecnologas y Ciencias de la Ingeniera','','Aspectos histricos de la ciudad de Mxico y otras ciudades$Planeacin territorial, urbano-regional, poblacional, vivienda$Servicios ambientales$Temas hidrulicos','Centros histricos e identidad cultural$Competitividad urbana y economa social$Gobernanza, participacin ciudadana y coordinacin metropolitana$Planeacin participativa y gestin urbana$Pobreza urbana y politicas  sociales urbanas$Recursos naturales, agua y cambio climtico$Vivienda y desarrollo urbano sustentable y poltica habitacional','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (4,'0','0','0','0','0','0','0','0','678233','','Multidisciplinaria','','Multidisciplinaria','Actuara$Arquitectura$Artes visuales$Comunicacin$Ciencias polticas y Administracin pblica$Derecho$Diseo grfico$Economa$Enseanza de alemn, espaol, francs, ingls, italiano$Filosofa$Historia$Ingeniera civil$Lengua y literatura hispnicas$Matemticas aplicadas y computacin$Pedagoga$Relaciones internacionales$Sociologa','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (7,'0','0','0','0','0','0','0','0','0','','Multidisciplinaria','','Multidisciplinaria','Arquitectura$Comunicacin y Periodismo$Derecho$Diseo industrial$Economa$Ingeniera civil$Ingeniera en computacin$Ingeniera industrial$Ingenieria elctrica-electrnica$Ingenieria mecnica$Pedagoga$Planificacin para el desarrollo agropecuario$Relaciones internacionales$Sociologa$Maestra en Derecho$Pedagoga$Especialidad en puentes','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (159,'0','0','0','0','0','0','0','0','0','','0','0','0','Odontologia$ Fisioterapia$ Economa industrial$Desarrollo y Gestin intercultural$Administracin Agropecuaria$Ciencias Agrogenmicas','0','0','Biblioteca dada de alta el 14 feb 2014 ','0');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (8,'0','0','0','0','0','0','0','3206','247871','','620000 Artes y Letras','','','Artes visuales$Artes y Diseo$Cinematografa$Diseo y Comunicacin visual ','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (9,'0','0','0','0','0','0','0','0','1914','','620000 Artes y Letras','','Artes y Diseo$Artes visuales$Diseo y comunicacin visual','Maestra en Artes Visuales$Maestra en Diseo y Comunicacin Visual$Maestra en Docencia en Artes y Diseo$Maestra en  Cine Documental$ Doctorado en Artes y Diseo','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (35,'0','0','0','0','0','0','0','0','0','','590000 Ciencias Polticas','','Politica','Administracin pblica$Ciencias de la comunicacin y periodismo $Ciencia poltica$Relaciones internacionales$Sociologa$Maestra en Estudios polticos y sociales$Gobierno y asuntos pblicos$Comunicacin$Estudios en relaciones internacionales$Estudios Mxico-Estados Unidos$ Doctorado en Ciencias polticas y sociales','Espaol$Ingls','Library of Congress','','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (15,'0','0','0','0','0','0','0 ','0','0','','530000 Ciencias Econmicas','','','Administracin $Contadura $Informtica','','Library of Congress','Fuente: Censo Automatizado del Sistema Bibliotecario de la UNAM 2009','En tesis se incluyen tits. y vols.  formato en papel y cd-dvd');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (16,'0','0','0','0','0','0','0','0','69714','','530000 Ciencias Econmicas','','','Maestra en Administracin (Organizaciones)$Administracin (Sistemas de salud)$Administracin (Negocios internacionales)$Informtica administrativa$Alta direccin$Doctorado en Ciencias de la Administracin','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (44,'0','0','0','0','0','0','0','0','0','','560000 Ciencias Jurdicas y Derecho','','','Derecho','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (36,'0','0','0','0','0','0','0','0','133650','','Multidisciplinaria','','Multidisciplinaria','Diseo y comunicacin visual$Ingeniera en alimentos$Ingeniera qumica$Qumica$Qumica farmacutica biolgica$Qumica industrial$Farmacia$MVZ$Ingenieria agrcola$ Ingenieria Mecanica elctrica$ Tecnologa$Contadura y Administracin$Informtica','','Library of Congress','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (75,'0','0','0','0','0','0','','0','0','','','','Historia de Mxico siglo XVI a XVIII$ Historia de la minera$Historia de la Ingeniera$','Ingeniera','','','','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (162,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Ciencias Ambientales$Geociencias$Geohistoria$Literatura Intercultural$EstudiosSociales y Gestin Local$Historia del Arte$Arte y Diseo$Ciencia de Materiales Sustentables$Tecnologas para la Informacin en Ciencias$Ecologa$Administracin de Archivos y Gestin Documental',NULL,NULL,NULL,NULL);
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (74,'0','0','0','0','0','0','0','0','19243','','540000 Geografa','','','Anlisis de suelos$Climatologa$geoeconoma$Geografa histrica$Geografa industrial$Geografa rural$Geomorfologa$Hidrologa$Percepcin remota$Residuos peligrosos$Sistema de informacin','','Library of Congress','Mapoteca "Alejandro de Humboldt"','');
INSERT INTO "coleccion" ("bib_id","num_tit_lib","num_vol_lib","num_tit_rev","num_fasc_rev","num_tit_tes","num_vol_tes","otros_mat_doc","num_usuarios","num_asistentes","pub_editadas","clasif_conacyt","cobert_geogra","descriptores","descript_entidad","idioma","sist_clasif","observaciones","colec_obs") VALUES (18,'0','0','0','0','0','0','0','0','3440','','240000 Ciencias de la Vida','','','Ecologa de la Biodiversidad$Ecologa Evolutiva$Ecologa Funcional$Ciencias de la Sostenibilidad$Ciencias Biomdicas','','Library of Congress','','');
--
-- Data for TOC Entry ID 61 (OID 3235373)
--
-- Name: datospersona Type: TABLE DATA Owner: israeld
--


INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1037,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1115,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1193,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1280,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1363,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1443,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1013,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1030,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1002,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1003,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1004,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1008,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1009,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1010,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1011,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1012,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1014,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1015,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1016,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1017,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1018,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1019,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1020,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1021,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1022,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1026,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1027,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1028,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1029,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1031,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1032,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1033,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1034,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1035,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1036,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1038,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1039,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1040,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1041,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1042,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1043,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1050,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1051,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1052,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1053,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1054,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1055,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1056,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1057,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1058,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1059,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1060,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1061,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1062,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1063,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1064,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1065,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1066,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1067,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1068,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1069,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1070,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1077,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1078,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1079,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1080,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1081,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1082,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1083,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1084,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1085,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1086,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1087,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1088,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1089,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1090,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1091,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1092,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1093,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1094,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1098,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1099,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1100,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1101,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1102,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1103,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1104,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1105,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1106,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1107,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1108,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1109,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1110,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1111,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1112,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1113,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1114,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1116,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1117,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1118,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1119,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1120,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1121,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1122,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1123,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1124,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1125,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1126,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1127,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1128,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1129,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1130,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1131,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1132,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1133,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1134,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1135,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1136,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1137,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1138,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1139,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1140,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1141,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1142,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1143,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1144,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1145,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1146,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1147,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1148,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1152,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1153,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1154,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1155,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1156,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1157,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1158,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1159,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1160,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1170,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1171,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1172,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1173,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1174,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1175,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1176,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1177,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1178,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1179,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1180,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1181,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1182,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1183,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1184,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1185,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1186,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1187,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1188,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1189,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1190,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1191,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1192,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1194,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1195,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1196,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1200,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1201,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1202,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1209,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1210,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1211,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1212,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1213,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1214,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1215,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1216,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1217,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1218,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1219,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1220,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1221,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1222,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1223,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1224,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1225,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1226,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1227,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1228,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1229,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1230,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1231,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1232,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1236,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1237,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1238,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1248,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1249,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1250,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1251,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1252,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1253,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1254,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1255,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1256,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1263,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1264,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1265,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1266,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1267,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1268,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1269,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1270,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1271,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1272,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1273,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1274,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1275,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1276,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1277,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1278,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1279,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1281,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1282,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1283,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1284,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1285,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1286,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1287,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1288,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1289,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1293,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1294,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1295,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1296,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1297,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1298,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1299,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1300,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1301,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1302,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1303,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1304,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1305,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1306,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1307,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1308,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1309,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1310,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1311,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1312,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1313,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1314,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1315,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1316,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1317,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1318,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1319,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1320,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1321,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1322,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1323,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1324,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1325,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1326,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1327,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1328,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1329,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1330,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1331,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1335,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1336,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1337,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1338,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1339,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1340,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1350,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1351,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1352,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1353,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1354,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1355,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1356,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1357,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1358,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1362,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1364,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1365,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1366,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1367,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1368,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1369,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1370,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1371,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1372,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1373,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1377,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1378,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1379,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1380,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1383,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1384,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1385,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1392,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1393,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1394,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1395,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1396,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1397,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1401,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1402,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1403,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1404,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1405,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1406,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1410,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1411,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1412,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1413,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1414,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1415,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1416,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1417,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1418,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1419,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1420,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1421,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1422,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1423,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1424,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1425,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1426,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1427,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1428,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1429,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1430,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1434,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1435,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1436,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1440,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1441,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1442,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1444,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1445,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1453,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1454,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1455,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1513,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1514,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1515,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1541,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1542,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1543,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1544,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1545,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1656,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1657,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1658,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1659,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1660,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2246,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2247,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2248,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2249,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2250,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2251,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2252,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2253,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2254,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2255,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2256,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2257,'','','','','','','','','',NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1197,'M. en I.','Alberto Moreno Bonett','56-23-29-00','56-23-29-01','56-23-29-02','55-10-05-73','','bonett@servidor.unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1198,'Dra.','Rosa Mara Lpez Gmez','56-23-29-45','56-23-29-46','','56-23-29-62','','rmlopez@tolsa.mineria.unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1044,'Dr.','Ignacio Mercado Gasca','56-22-84-74','','','55-50-43-83','','imercado_posgrado@hotmail.com','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1199,'C.P.','Lilia Rojas Mndez','56-23-29-75','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1045,'Lic.','David Vzquez Morales','56-22-84-66','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1381,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1046,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1382,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1699,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1290,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1291,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1292,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2189,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1759,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1341,'Lic.','Rosa del Carmen Zetina Castellanos','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1342,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1343,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1539,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1774,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1161,'Biol.','Ione Rosamond Coates Estrada (Jefe de la Estacin)','','','','','','rcoates@ibiologia.unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1162,'Lic.','Jorge Perea Guzmn','01-(200) 125-54-04','','','01-(200) 125-54-07','','biblio@mail.ibiologia.unam.mx','','9:00 a 15:00 hrs.',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1163,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1006,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1869,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1609,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1779,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1674,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1095,'Dr.','Gerardo Fujii Gambero','56-22-21-63','56-22 -21-59','','','','fujii@servidor.unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1096,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1097,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2204,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1629,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1884,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2209,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2089,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2084,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2265,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2266,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2267,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1164,'Dr.','Jorge Humberto Vega Rivera (Jefe de Estacin)','01(315) + 35-10-200','','','01(315) + 35-10-202','','jhvega@ibiologia.unam.mx','chamela@ibiologia.unam.mx','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1165,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1166,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2280,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2281,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2282,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2149,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2239,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (81,'Lic.','Patricia Espinosa Martnez','56-23-17-01','','','53-63-09-85','','coordcid@apolo.acatlan.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2295,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2296,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2297,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1764,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1347,'Dr.','Roberto Iglesias Prieto','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1348,'C.P.','Juan Ramn Ramos','01(998) +87 -10-219 ext. 13','','','01(998) + 87-10-138','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1349,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2094,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1939,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1332,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1333,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1334,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1744,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2307,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2310,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2311,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2314,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2321,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2322,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2323,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2324,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2327,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2329,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2330,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2331,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2332,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2336,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2337,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2338,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2339,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2340,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2341,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2343,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2344,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2345,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2347,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2351,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2352,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2354,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2357,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2358,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2359,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2360,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2361,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2362,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2366,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2367,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2368,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2369,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2370,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2371,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2372,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2373,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2374,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2375,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2377,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2381,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2382,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2383,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2384,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2385,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2386,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2387,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2388,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2389,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2391,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2392,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2398,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2400,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2401,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2402,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2403,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2404,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2406,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2407,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2411,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2412,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2414,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2415,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2416,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2418,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2419,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2420,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2421,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2422,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2426,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2427,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2428,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2429,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2430,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2431,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2432,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2433,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2434,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2435,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2436,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2437,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2441,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2442,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2443,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2444,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2445,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2446,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2447,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2448,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2449,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2450,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2451,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2452,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2456,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2457,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2458,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2459,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2460,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2461,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2463,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2464,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2465,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2466,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2467,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2471,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2472,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2473,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2474,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2475,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2476,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2477,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2478,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2479,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2480,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2482,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2487,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2489,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2490,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2491,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2492,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2493,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2494,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2495,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2496,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2497,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2505,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2506,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2507,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2516,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2517,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2518,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2520,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2521,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2522,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2523,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2524,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2525,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2526,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2535,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2537,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2541,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (20,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (21,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (22,'','','','','','','','','','','','El Director del Instituto de Geofsica es el encargado de manejar el presupuesto de la BCCT. La BCCT surge de conformidad con el convenio firmado el 11 de junio de 1998 por los Directores de los Institutos de Ciencias del Mar y Limnologa, Geofsica y Geologa y del Centro de Ciencias de la Atmsfera.',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2258,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2259,'','','','','','','','','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2260,'','','','','','','','','','','','El Director del Centro de Fsica Aplicada y Tecnologa Avanzada va a fungir como Presidente del Consejo de Direccin del Campus Juriquilla. El Consejo est integrado por el Director del Instituto de Neurobiologa, el Director del Centro de Geociencias, el Jefe de Ext. de la Facultad de Contadura y Administracin y el Coordinador de Servicios Administrativos (Fuente: OFICIO:CDCJ/003/2007)',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1904,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1844,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1854,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1849,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2214,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (667,'Dr.','Ignacio de Jess Ania Briseo','56-22-85-41','','','56-22-85-40','','ignacio.ania@servidor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (567,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (568,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1483,'Mtro. ','Jos Antonio Vela','001 (210) + 22-28-620','','','001 (210) + 22-51-772','','unamsa@servidor.unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1484,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1485,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1074,'Mtra.','Margarita Lugo Hubp ','56-22-39-57','56-22-39-55','','55-50-80-68','','mlugo@servidor.unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1075,'Lic.','Jernimo Snchez Caravantes','56-22-39-50','56-22-39-54','','56-22-40-29','','jeronimo@dgb.unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1076,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1934,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1579,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1949,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2154,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2169,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2159,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1604,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1644,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1534,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1519,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1794,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1789,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1524,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2049,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2019,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1489,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1799,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1864,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2114,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1474,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1859,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2179,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1594,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2271,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1569,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1824,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2501,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2502,'Lic.','Alejandro Prez Fernndez','56-23-99-57','56-23-32-58','','55-23-46-40','','pefa656@hotmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2503,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2504,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2508,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2509,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2510,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2512,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1959,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2074,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2079,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2069,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2064,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2164,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1704,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1889,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1669,'Lic.','Elvia Rodrguez Alcal','56-22-06-75 Ext. 230','','','','','elvia_roal@hotmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1954,'Lic.','Teresa Soledad Medina Malagn','56-23-42-37','','','','','smedina@teljuriquilla.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1684,'Lic.','Teresa soledad Medina Malagn','56-23-42-37','','','','','smedina@teljuriquilla.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2286,'Sra.','Ireri Guzmn Pin','56-23-28 -28','','','','','iguzman@oikos.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1969,'Lic.','Leonor Garca Urbano','56-23-00-31','56-23-04-25','','56-23-01-97','','igu@servidor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2024,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1694,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1979,'Mtra.','Martha Frias','56-22-78-20','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2301,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1679,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1974,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1734,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1504,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (810,'Dr.','Enrique Luis Graue Wiechers',' ','56-23-24-01','56-23-24-02','56-16-11-62 (Directo)','','egrauew@servidor.unam.mx','graue@servidor.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2346,'Lic.','Leonardo Arroyo Lira','32752','','','(01-443) 322 2726','','l.arroyo@crya.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (912,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (569,'Lic.','Jorge Alberto Coln Rojas (Interino)','56-22-84-91','','','56-22-84-91 (Solicitar tono)','','bibdgsca@unam.mx','george@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (570,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (571,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2166,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2167,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2168,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2170,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (981,'Lic.','Sal Armendriz Snchez','56-22-40-30 (Servicios)','56-22-40-31','56-22-40-36 (Coordinador)','56-22-40-36 (Coordinacin de la BCCT)','','asaul@bcct.unam.mx','asaul@xcaret.igeofcu.unam.mx','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (647,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (648,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (649,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2206,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2207,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2208,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2210,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (978,'Lic.','Sal Armendriz Snchez','56-22-40-30 (Servicios)','56-22-40-31','56-22-40-36 (Coordinador)','56-22-40-36 (Coordinacin de la BCCT)','','asaul@bcct.unam.mx','asaul@xcaret.igeofcu.unam.mx','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (637,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (638,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (639,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2211,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2212,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2213,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2215,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (979,'Lic.','Sal Armendriz Snchez','56-22-40-30','56-22-40-31','56-22-40-36 (Coordinador)','56-22-40-36 (Coordinacin de la BCCT)','','asaul@bcct.unam.mx','asaul@xcaret.igeofcu.unam.mx','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (641,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (642,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (643,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2216,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2217,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2218,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2220,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1005,'Dr.','David Hiriart Garca (Jefe de Estacin)','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1007,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2099,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1989,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1719,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1814,'Lic.','Antonio Pizarro Monzn','56-22-48-10','56-22-49-00','','56-22-49-00','56-22-48-10','pmonzon@servidor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1804,'Lic.','Celia Martnez Garca','56-23-03-14','','','56-23-03-15','','zairon@servidor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1619,'C.P.','Felipe Flores Gonzlez','56 23 02 11 Ext. 42217 o 42076','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2219,'C. P.','Francisco Ferruzco Guido','56-22 43-80','','','56-22-43-80','','fguido@geofisica.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1914,'Lic.','Marisela Rivera Rosales','56-23-21-03','','','','','escailena@hotmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1549,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (420,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (872,'','Marcos Garca Marcial','56-23-22-17','','','','','biblioteca.fo@gmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (421,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (422,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1991,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1992,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1993,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1995,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2039,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1984,'Lic.','Vctor Hugo Daz Muro (Coord. de Informtica y Bases de datos)','56-23-13-20','','','','','dmuro@campus.iztacala.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (80,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (922,'Lic.','Vernica  Beatriz Corts Nez','53-63-09-85','Red UNAM, ext. 31700 (Servicios)','Red UNAM, ext. 31701 (Responsable)','53-63-09-85 (Solicitar tono)','','coordcid@apolo.acatlan.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (82,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1531,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1532,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1533,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1535,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1624,'C.P.','Gabriel Flores de la Torre','56-22-69-95 ext. 2438','56-22-69-86 ext. 2705','','','','gfdelatorre@hotmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2109,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2054,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1879,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2550,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2551,'Lic.','Mireya Fabin Ramrez (Delegada Administrativa)','562-32-733','562-32-798','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2552,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2556,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1709,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1714,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2316,'Lic. ','Rodrigo Santana Magro','5622 1573','','','5622 1564','','rsantana@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2376,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (507,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (948,'Lic.','Rebeca Garca','56-22-24-75 (Acervo)','56-22-24-65 (Responsable)','','56-16-26-72 (Secretara General. Solicitar tono)','','biblioteca@cepe.unam.mx','rjg@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (508,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (509,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2101,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2102,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2103,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2105,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2229,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1874,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1479,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1480,'Lic.','Mara Elena Corts (Secretaria acadmica)','001(210) + 22-28-626, ext. 225','','','001(210)  + 22-51-772','','mecs@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1481,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1482,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1486,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1487,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1488,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1490,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (461,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (708,'Lic.','Edna Alicia Contreras Ramrez','56-22-63-77','Red UNAM ext. 48062 (Servicios)','Red UNAM ext. 48047 (Responsable)','Red UNAM ext. 48062 (Solicitar tono)','','edialis91@hotmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (462,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (463,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2051,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2052,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2053,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2055,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (46,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (864,'Lic.','Marco Alberto Soto Velasco','56-23-10-69 (Jefatura)','','','56-23-09-50 (Solicitar tono)','','sotov@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (47,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (53,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1546,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1547,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1548,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1550,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1819,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1260,'Dr.','Martn A. Valencia Moreno (jefe de Estacin Regional)','01 (662) + 21-75-019','','','01 (662) + 217-53-40','56-22-60-52','valencia@geologia.unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1261,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1262,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (30,'Lic.','Godofredo Lpez Santos','56-22-82-61 (Servicios)','56-22-82-63 (Coordinador)','','56-22-82-61 (Solicitar tono)','','gnlopez@fca.unam.mx','lsantos@unam.mx','','correo alternativo de responsable Lic. Gabriela Dominguez. gdominguez@fca.unam.mx','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (805,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (31,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (32,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1586,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1587,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1588,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1590,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (17,'Lic.','Godofredo Lpez Santos','56-22-84-83 (Circulacin)','56-22-84-84 (Servicios especializados)','56-22-82-63 (Coordinador)','56-22-84-82 (Solicitar tono)','','gnlopez@fca.unam.mx ','lsantos@unam.mx','','correo alternativo de responsable Lic. Carlos Snchez. csanchez@fca.unam.mx','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (806,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (18,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (19,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1591,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1592,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1593,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1595,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (253,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (252,'','','','','','','','','','','cambio de  Coordinador de biblioteca de confianza en 16 de abril 2012  Departamento de Planeacin','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (903,'Lic.','Antonio Estanislao Urea valos','56-22-49-81 y  56-22-49-83 (Circulacin)','56-22-49-77 (Servicios especializados) 56-22-49-82 (Hemeroteca)','56-22-49-75 (Responsable)','56-22-49-75 (Solicitar tono)','','biblioteca@ciencias.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (254,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1811,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1812,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1813,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1815,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1461,'Dr.','Roberto Castan Romo','56-22-24-72','','','56-16-26-72','','rcastanon@cepe.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1462,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1463,'','','','','','','','','','','','Cambio de director nuevo Castan Romo 16/01/12, Dpto.  Planeacin verificado  via telefonica  Rebeca Garca',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1476,'Dr. ','Roberto Castan Romo','56-22-24-72','','','56-16-26-72','','rcastanon@cepe.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1477,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1478,'','','','','','','','','','','','Nuevo director Castan Romo 16/1/2012. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (702,'Bil.','Mara Dolores Valle Martnez','56-78-20-96','56-78-20-97','','56-78-20-97 (Solicitar tono)','','prepa5direccion@hotmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (712,'Sra.','Iris Oliver Guterrez','56-77-81-99','56-78-21-04','','','','iolivergtz2903@hotmail.com','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (450,'C.P.','Calos Ramrez Paniagua','56-77-81-99','56-78-21-04','','','','charly_3030@hotmail.com','','','','Nueva directora Valle Martnez, 2010-2014, noticia  04/10/2010. Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (976,'Dr.','Jorge Manuel Vzquez Ramos','56-22-36-90','57-16-26-04','','56-16-18-28','','jorman@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (477,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (478,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (977,'Dr.','Jorge Manuel Vzquez Ramos','56-22-36-90','56-16-26-04','','56-16-18-68','','jorman@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (481,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (482,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (975,'Dr.','Jorge Manuel Vzquez Ramos','56-22-36-90','56-16-26-04','','56-16-18-68','','jorman@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (473,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (474,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (974,'Dr.','Jorge Manuel Vzquez Ramos','56-22-36-90','56-16-26-04','','56-16-18-68','','jorman@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (472,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (469,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (813,'Lic.','Mario Espinosa Ricalde','56-22-71-08','56-22-71-02','56-65-51-96','56-22-71-02 (Solicitar tono)','','cutdir@unam.mx','marioespinosaricalde@gmail.com','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (988,'C.P.','Teresa Isabel Castaeda Rojano','56-22-71-07','','','','','cutadmon@servidor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (634,'C.P.','Teresa Isabel Castaeda Rojano','56-22-71-02','','','','','cutadmon@servidor.unam.mx','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (665,'Dr.','Felipe Bracho Carpizo','56-22-85-41','56-22-85-42','','56-22-85-40','','felipe.bracho@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (559,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (560,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (916,'Lic.','Sandra Guadalupe Aguilar Fonseca','53-18-55-38, ext. 108','53-18-55-43',' ','53-18-55-38, ext. 109','','tandy0994@yahoo.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (740,'C.P.','Jos Valencia Chavez (Secretario Administrativo)','53-18-55-39  ext. 105','','','53-18-55-39 ext.109','','jvalencia57@hotmail.com','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (165,'Lic.','Nstor Ruz Soria','53-18-55-39 ext.103','','','53-18-55-39- ext. 109','','nrs@servidor.unam.mx','','','','Nueva directora, Aguilar Fonseca, periodo 2009-2013, gaceta UNAM 224/4,214. 14/ene/10 (Depto Planeacin)',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1468,'Dr.','Federico Fernndez Christlieb','001 (819) +77-78-626, ext. 311','','','001 (819) +77-78-628','','ffernandez@unam.canada,com','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1469,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1470,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1464,'','','','','','','','','','','liturbe@unamcanada.com  (hasta finales de septiembre de 2012)','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1465,'Mtra.','Patricia Almazn Dirzo','001(819)  + 77-78-626 ','','','001(819)  + 77-78-628','','biblioteca@unameseca.com','patricia.almazan@unamcanada.com','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1466,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1467,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1471,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1472,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1473,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1475,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (556,'Lic.','Jorge Alberto Coln Rojas ','56-22-85-03 (Servicios)','56-22-84-91 (Responsable)','56-22-81-93','56-22-84-91 (Solicitar tono)','','bibliotecatic@unam.mx','george@unam.mx','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (909,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (557,'Sr.','Carlos Gonzles Elvira ','56-22-80-78','','','','','hemero_dgsca@yahoo.com.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (558,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2151,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2152,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2153,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2155,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (910,'Lic.','Jorge Alberto Coln Rojas','56-22-84-91 (Coordinador)','56-22-81-93','','56-22-84-91 (Solicitar tono)','','bibliotecatic@unam.mx','george@unam.mx','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (997,'Lic.','Jorge Alberto Coln Rojas','55-53-87-34 (Servicios)','56-22-84-91 (Coordinador)','','55-53-92-32 (Coordinacin del Centro Nuevo Len)','','bibliotecatic@unam.mx','bibnl@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (561,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (562,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2156,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2157,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2158,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2160,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (824,'Dr.','Vctor Manuel Mendoza Nez','56-23-05-40','57-73-63-10','','57-73-63-10 (Solcicitar tono)','','vmmn@puma2.zaragoza.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (599,'Lic.','Pedro Pablo Gmez Flores (Secretario Administrativo)','56-23-06-35','','','','','gfpp@puma2.zaragoza.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (600,'Lic.','Sergio Silva Salgado','56-23-06-44','','','','','silva@puma2.zaragoza.unam.mx','','','','Nuevo director: Mendoza (2010-2014) boletin 16 noviembre 2010. Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2119,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1729,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2059,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1754,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2234,'Lic.','Carlos Alberto Ronquillo Mercado','56-22-40-93','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1689,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1459,'Lic.','Teresa Soledad Medina Malagn','56-23- 42-37','','','','','smedina@teljuriquilla.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1589,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1023,'','','','','','','','','','',NULL,'Posgrado de Artes y Diseo. Cambio de denominacin 30 de marzo 2011 por Consejo acadmico del Area de las Humanidades y de las Artes.19/04/2012 cambio en directorio a peticin del responsable ',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1024,'Dra.','Lucia Andrade Barrenechea (Delegada Administrativa)','55-22-06-30 ext. 116','','','','','','','8:00 a 15:00 hrs. y de 17:00 a 20:00 hrs.',NULL,'Posgrado de Artes y Diseo. Cambio de denominacin 30 de marzo 2011 por Consejo acadmico del Area de las Humanidades y de las Artes.19/04/2012 cambio en directorio a peticin del responsable ',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1025,'L.C.','Edel Obregn Velasco','55-22-06-30 ext.','','','','','','','','','Posgrado de Artes y Diseo. Cambio de denominacin 30 de marzo 2011 por Consejo acadmico del Area de las Humanidades y de las Artes.19/04/2012 cambio en directorio a peticin del responsable ',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1899,'Lic. ','Laura Macias Rodrguez','56-22-97-61','','','','','lmr@cie.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1398,'M.V.Z.','ngel Rosendo Pulido Albores','52 (414) + 29-18-100 ','56-23- 42-98','56-23-42-99','52 (414) + 29-18-105 ','','ceiepaa@unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1399,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1400,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1167,'Dr.','Octavio Meja Villanueva','(739) + 39-30-142','','','(739) + 39-30-616','','omejia@unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1168,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1169,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1203,'MVZ.','Ernesto Avila Gonzlez','58-63-42-39 ','58-45-15-30','','58-45-15-30 (Solicitar tono)','','avilaernesto@yahoo.com','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1204,'MVZ M en C','Ezequiel Snchez Ramrez','58-45-00-29','58-45-15-30','','58-45-15-30','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1205,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (190,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (713,'Lic.','Guadalupe Hermelinda Palma Anaya','56-22-28-17','','','','','dulsebrisamarina@gmail.com   ','dulcebrisamarina@hotmail.com','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (191,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (192,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1746,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1747,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1748,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1750,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2014,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (752,'Mtra.','Hortensia Lobato Reyes','56-22-20-91','56-22-21-82','','56-22-21-82 (Solicitar tono)','','hlr@economia.unam.mx','','','Responsable desde 2009 Irma Esquivel maestra titulada en Bibliotecologa y Estudios de la Informacin. DPLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (902,'Mtra. ','Irma Esquivel Esquivel','56-22-66-28','56-22-66-31 (Responsable)','','56-22-18-88, ext. 4887 (Solicitar tono)','','bibdepfe@economia.unam.mx','iees@economia.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1676,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (138,'Lic.','Juana Yolanda Guilln Cruz','56-22-21-62','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (139,'Lic.','Luis Alberto Velasco Jimnez','56-22-21-62','','','','','luisvj@economia.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1677,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1678,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1680,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (517,'','','','','','','','','','','Nueva responsable: Romero Corona licenciada en bibliotecologia 04/10/12. DPLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (966,'Lic.','Sonia Romero Corona','56-22-99-66 (Red UNAM, Secretario Acadmico, Taxco)','01 (762)  + 62-23-410 (Taxco)','','01 (762)  + 62-20-124 Taxco)','','biblioteca.taxco@cepe.unam.mx','sonia.romero@cepe.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (518,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (519,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2111,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2112,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2113,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2115,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (747,'Dr.','Roberto Castan Romo','56-16-14-74','56-22-24-72','','56-16-14-74 (Solicitar tono)','','rcastanon@cepe.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (515,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (516,'','','','','','','','','','','','Nuevo director Castan Romo 16/1/2012.DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (911,'Lic.','Jorge Alberto Coln Rojas','56-22-84-91 (Coordinador)','56-22-81-93','','56-22-84-91 (Solicitar tono)','','bibliotecatic@unam.mx','george@unam.mx','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (987,'Lic.','Erndira Montiel  Calzadilla','56-22-79-70','','','','','bibmas@unam.mx','emontiel@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (565,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (566,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2161,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2162,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2163,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2165,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (91,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (919,'Lic.','Mara Xitlaly Zugarazo Navarro','54-89-49-21, ext. 146 (Servicios)','54-89-49-21, ext. 149 (Responsable)','','54-89-49-23 (Direccin)','','cendocenapx@gmail.com','xzugarazo@yahoo.com.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (92,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (93,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1551,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1552,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1553,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1555,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (574,'Mtra.','Hortensia Lobato Reyes','56-22-20-91','56-22-21-82 ','56-22-21-84 (Servicios)','56-22-21-82 (Solicitar tono)','','hlr@economia.unam.mx','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (753,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (575,'','Catalina Tllez Chvez','56-22-21-84','','','','','catalina@economia.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (576,'','Gerardo Gutirrez Muoz','56-22-21-87','','','','','gerardo@economia.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2171,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2172,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2173,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2175,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (720,'Mtro.','Marcos Mazari Hiriart','56-22-02-14','56-22-02-15','56-16-19-60 ','56-18-17-73','','dir.arq@.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (63,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (68,'','','','','','','','','','','','Nuevo director  MAZARI 2013-2017 Boletin 111. 19/feb/2013 Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (721,'Mtro.','Marcos Mazari Hiriart','56-22-02-14','56-22-02-15','56-16-19-60 ','56-18-17-73','','dir.arq@.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (128,'Mtro.','Abel Salto Rojas (Secretario Administrativo)','56-22-03-20','56-22-03-21','','','','salto@servidor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (129,'C.P.','Silvia Meza Fernndez','56-22-03-04','','','','','besafi@hotmail.com','','','','Nuevo director  MAZARI 2013-2017 Boletin 111. 19/feb/2013 Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (993,'Dra.','Ana Carolina Ibarra Gonzlez','56-22-75-25','56-22-75-26','','56-22-75-15 (Solicitar tono)','','historicas@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (261,'Sr.','Rubn Olmedo Ponce (Secretario Administrativo)','56-22-75-17, 18 y 28','','','56-22-75-36','','rolmedop@hotmail.com','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (262,'C.P.','Leticia Salinas Coroy','56-22-75-17 y 18','56-22-75-18','','56-22-75-36','','plesa_973@yahoo.com.mx','','','','Directora actual: Ana Carolina Ibarra 2013-2017. Boletin 443- 22/07/13. Antecedentes: Dra. Mayer (2009-2013) boletin 3 julio 2009.  tercer informe del segundo periodo /28 junio 2012. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2531,'','Juana Kuri Labarthe','56-22-14-14','','','','','kuri@unam.mx','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2532,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2533,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2534,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2538,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2539,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2540,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2542,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (403,'','','','','','','','','','','Nuevo responsable a partir de 12 de agosto de 2013, Licenciatura y maestria en sociologia. Tec. acadmico titular A y de confianza ( acad.-adm)','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (956,'Lic.','Vctor Medina Corona','56-23-01-00, ext. 42497 (Servicios)','56-23-00-96 (Secretaria)','56-23-00-98 (Responsable)','','','biblioie@unam.mx','corona@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (404,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (405,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1971,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1972,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1973,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1975,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (780,' Lic.','Gerardo Arvalo Guzmn','56-22-91-10','Red UNAM ext. 47782','','56-22-91-09','','biblio@ib.unam.mx','arevalo@ib.unam.mx','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (791,'Biol.','Rosamond Ione Coates Lutes','56-22-80-38','01(200) + 12-55-409','','01(200)  + 12-55-407','','rcoates@ib.unam.mx','rcoates@ibunam2.ib.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (230,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (231,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1786,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1787,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1788,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1790,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (781,' Lic. ','Gerardo Arvalo Guzmn','56-22-91-10','Red UNAM ext. 47782','','56-22-91-09','','biblio@ib.unam.mx','arevalo@ib.unam.mx','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (951,'Dr.','Jorge Humberto Vega Rivera','','01(315) + 35-10-200','','01(315) + 35-10-202','','jhvega@ib.unam.mx','chamela@ib.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (234,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (235,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1791,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1792,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1793,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1795,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (676,'Dr.','Juan Alberto Adam Siade','56-22-83-75 ','56-22-83-76','','56-16-15-61','','jadam@fca.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (28,'Lic.','Araceli Mosqueda Lpez (Secretario Administrativo)','56-22-83-78','','','','','amosqueda@correo.fca.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (29,'Mtra.','Ana Ruth Bravo Sosa','56-22-83-64','','','','','bavososa@yahoo.com.mx','','','','Segundo periodo de Adam, (2013-2017) Boletin 662. 05/nov/2013 DPLybf. Nuevo Director: Adam Siade (2009-2013) Boletin 3 noviembre 2009./ Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1839,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2174,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2199,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1574,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2565,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2567,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2571,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2580,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2581,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2582,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2029,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1784,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2004,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1809,'Lic.','Roberto Gonzlez Moreno','56-22-72-94','','','56-22-18-28','','rgmoreno_@hotmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1654,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1724,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (624,'Dr.','Jos Antonio Seade Kuri','56-22-45-23','56-22-45-24','56-22-45-25','55-50-13-42','','jseade@matcuer.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (625,'C.P.','Armando Ramrez Manjarrez','5622 4528','5622 4757','','5622 4473','','aramirez@matem.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (626,'Lic.','Patricia Valle Garca','5622 4754','','','5622 4473','','paty@matem.unam.mx','','','','Nuevo director  Seade 2014-2018. Boletin 326. 22/abril/2014  DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1437,'Dr.','David Guillermo Romero Vargas (Jefe de Unidad)','56-22-77-21','56-22-78-80','','52 (777)+317-00-44','','davidr@matcuer.unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1438,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1439,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (815,'Dr.','Jess Salinas Herrera','56-22-00-22','','','56-22-00-22 (Solicitar tono)','','jesus.salinas25@gmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (907,'L.A.E.','Miguel Agustn Garca Domnguez','56-22-01-69','56-22-00-24','','56-22-23-88','','escorpio@servidor.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (4,'Lic.','Zaira Salinas Sierra','56-63-35-88','56-63-34-87 ext. 13 ','','56-22-00-31','','','','','','Nuevo director Salinas Herrera (2014-2018) Boletin 130. 04/03/2014 DPLybf / directora Muoz Corona (2010-1014) gaceta 04/03/10, 4, 228. Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (671,'Dr.','Benjamn Barajas Snchez','53-60-03-23 y 53-60-03-24, ext. 203','53-60-03-23 y 53-60-03-24, ext. 202','','','','bbarajas45@yahoo.com.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (959,'Mtro.','Adrian Aguilar Cruz','53-73-12-56','53-60-03-24 y 25 Ext. 209','','53-73-12-64','','','patgro_67@hotmail.com','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (162,'Lic.','Ral Gonzlez Rodrguez','53-60-03-24 y 25  Ext. 245','','','','','raulglezrguez@yahoo.com.mx','','','','Nuevo director: Barajas (2012-2016) 24 junio/ 2012. Gaceta 09ago2012. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (677,'Dr.','Juan Alberto Adam Siade','56-22-83-75 ','56-22-83-76','','56-16-15-61','','jadam@fca.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (15,'L.C. ',' Adriana Padilla Morales ','56-22-83-78','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (16,'','','','','','','','','','','','Ratificacin Adam Siade 2013-2017 DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (881,'Dra.','Alina Mara Signoret Dorcasberro','56-22-06-76','56-22-06-82','','55-50-30-08','','alina@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (137,'Lic.','Csar Adrin Andrade Rodrguez','55-50-00-52','56-22-06-89','','','','candrader2002@yahoo.com.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (136,'Lic.','Alicia Gonzlez Granados','56-22-06-75','56-22-06-89 ext. 235','','','','provalis2@yahoo.com.mx','','','','Ratificacin Alina Signoret (2013-2017). Boletin 326/ 28 mayo 2013. Primer periodo (2009-2013) segundo y tercer informe 30 abril 2012. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (803,'Dra.','Silvia Nez Garca','56-23-03-00','56-23-03-01','','55-50-03-79','','nugar@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (245,'Act.','Erich Stephen Ferrera Abre','56-23-03-02','56-23-03-06','','56-23-03-09','','cisanadm@servidor.unam.mx ','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (241,'Sra.','Mara Soledad Reyes Lucero','56-23-02-46','42-286','','56-23-03-09','53-36-35-97','luceror@servidor.unam.mx','','','','Ratificacin Nuez 2013-2017, boletin 527, 2 septiembre 2013. Primer periodo (2008-2012) Segundo informe 2010-2011 /24 octubre 2012. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (949,'Dr.','Manuel Perl Cohen','56-22-73-71','56-22-73-73','56-65-07-86','','','iis@sociales.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (214,'Lic.','Juana Esquivel Flores  (Secretario Administrativo)','56-22-73-99','','','56-65-24-43','','jesquive@servidor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (215,'C.P.','Ruth Botello Landa','56-22-73-82','','','56-65-24-43','','','','','','Nuevo director Perl Cohen 2013-2017. Boletin 20 agosto 2013. DPLybf. Directora: Casas (2009-2013) boletin 17 agosto 2009. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (664,'Dr.','Felipe Bracho Carpizo','56-22-85-41','56-22-85-42','','56-22-85-40','','felipe.bracho@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (554,'Lic.','Mara Cristina Ordez Rangel','56-22-85-16','56-22-85-15','','','','ordonez@servidor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (555,'Lic.','Juan Carlos Osnaya Gamboa','56-22-85-17','56-22-84-92','','','','jcgamboa@servidor.unam.mx','','','','Nuevo director Dr. Bracho (2011-2015) 2 mayo 2011. DPLybf ',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (790,'Dra.','Vernica Ofelia Villarespe Reyes','56-23-00-87','56-23-00-91','','56-23-00-92','','direcc@unam.mx','reyesvv@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (401,'Lic.',' Alberto Antonio Pedroza Mena(Secretario Administrativo)','56-23-01-00 ext. 30143','','','56-23-01-49','','','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (402,'C.P.','Humberto Mondragn Correa','56-23-01-00 ext. 42479','','','','','presupuesto.iiec@correounam.mx','','','','Ratificacin Villarespe (2014-2018) Boletin 279 13 de mayo 2014. Primer periodo (2010-2014) boletin 11 mayo 2010. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2318,'Etnlgo. ','Jos Manuel del Val Blanco ','56-16-10-45, ext. 103','56-16-00-20, ext. 103','56-16-03-55','56-16-10-45, ext. 216','','multicultural@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2319,'C.P.','Antonio Aguilar Lagunes (Delegado Administrativo)','56-16-00-20 ext. 205','','','5-16-00-20 ext. 216','','antag@servidor.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2320,'C.P.','Gabriel Alberto Morales Caballero','56-16-00-20 ext. 209','','','56-16-00-20 ext. 216','','gabrielmc79@hotmail.com.mx','','','','Cambio de denominacin por acuerdo del Rector, marzo 2014. Director del Val (2014-2018) 25 marzo 2014. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (840,'Mtra.','Graciela de la Torre Prez','56-22-69-01','56-22-69-02','','56-22-69-44','','gdelatorre@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (119,'Lic.','Daniel Zamora Fbila','56-22-04-01','56-22-02-99','','56-22-02-99','','zfabila@prodigy.net.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (120,'Lic. ','Antonio Espinoza de los Montero Snchez','','','','5-22-02-99','','objetoae@hotmail.com','','','','Ratificacin de la Torre (2012-2016) Primer periodo (2008-2012)sf. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (617,'Dra.','Telma Gloria Castro Romero','56-22-40-69','56-22-40-76','','56-16-07-89','','telma@unam.mx','telma@atmosfera.unam.mx','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (618,'Lic.','Lidia Barrera Snchez','56-22-40-65','56-16-08-59','','56-16-07-89','','lbarrera@atmosfera.unam.mx','','',NULL,'',NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (619,'Act.','Jorge Alberto Aldana Jamaica','56-16-24-08','','','56-16-07-89','','jaldanaj@atmosfera.unam.mx','','','','Ratificacin Castro 2013-2017,  Boletin 648/ 29 octubre 2013. Primer periodo 2009-2013. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (842,'Dr.','Gerardo Carrasco Nez','56-23-41-04, ext. 196','','','56-23-41-29','','direccin@dragon.geociencias.unam.mx','gerardoc@geociencias.unam.mx','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (385,'Lic.','Dionisio Len Salas','56-23-41-03','42-38-11-04 ext 170','','','','dls@geociencias.unam.mx','','',NULL,'',NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (381,'Ing.','Carlos Hernndez Cabrera','56-23-41-04 ext. 174','','','','','carlosh@dragon.geociencias.unam.mx','','','','Ratificacin Carrasco (2014-2018) Boletin 266. 07 mayo 2014. Primer periodo (2010-2014) Gaceta 4,245. 11/05/2010. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2303,'M. C. ','Lidia Guadalupe Ortega Gonzlez  (Coordinadora)','56-22-15-38','','','56-22-05-15','','cab@unam.mx ','lortegag@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2304,'Lic. ','Misael Dominguez Hernndez (Deleg. Unid. Adva.)','5622 1564','5622 1544','','5622 1413','','misaeld@oficina.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2305,'Lic. ','Aracel Valdez Len','5622 1564','40762','','5622 1564','','araval_2006@hotmail.com','','','','Ratificacin (2013-2015). Primer periodo 2011-2013.fp. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2378,'Lic.','Mario Dubn Peniche','56-22-29-87','','','56 16 24 58','','mdubon@dgp.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2379,'Lic.','Mario Dubn Peniche','56-2228-45','','','56-22-28-46','','mdubon@dgb.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2380,'Lic. ','Yuridia Camara Aisa','56-22-28-44','','','56-22-28-46','','yuri01_@hotmail.com.mx','','','','Nuevo director Dubn (2013-2017).  17/enero/2013.DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2129,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2601,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (23,'Lic.','Sal Armendriz Snchez','56-22-40-30','56-22-40-31','','56-22-40-36 (Coordinacin de la BCCT)','','asaul@bcct.unam.mx','asaul@xcaret.igeofcu.unam.mx','','2008 reporta nombramiento de coordinador y tcnico acadmico titular B, pasante en maestra de Bibliotecologia y Estudios de la Informacin. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (980,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (24,'Lic.','Ofelia Barrientos Bernab  ','56-22-40-33','56-22-40-37','','55-50-66-44','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (25,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1576,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1577,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1578,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1580,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (125,'','','','','','','','','','','2008 reporta nombramiento de jefe de seccin acadmica y tcnico acadmico asociado C, Licenciada en Bibliotecologa y Estudios de la Informacin. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (732,'Lic.','Mara Roco Bastida Garca','56-22-86-02, ext. 1105 (Servicios)','56-22-86-02, ext. 1106 (Responsable) ','56-22-86-25 (Responsable)','56-22-86-25 (Solicitar tono)','','rocio.bastida@ccadet.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (126,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (127,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1661,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1662,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1663,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1665,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (527,'','','','','','','','','','','2008 reporta nombramiento de jefe de la Unidad de biblioteca y de honorarios, Maestro en Bibliotecologia. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (870,'Mtro.','Ral Ortega Muoz','56-22-72-52  y 56-22-72-54 (Servicios)','56-65-13-73 (Responsable)','','56-22-72-51','','biblioteca@universum.unam.mx','rortega@universum.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (528,'','Miriam Navarrete','56-22-72-54','','','','','namiriam@universum.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (529,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2121,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2122,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2123,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2125,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (50,'','','','','','','','','','','2008 reporta nombramiento de  tcnico acadmico  Titular A. Licenciada en informtica. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (878,'Lic.','Mara Elena Jimnez Fragozo','56-22-65-26, 56-22-65-27 y 56-22-65-28','01(646)  + 17-44-593, ext. 323','','01(646)  + 17-44-607','','bibens@astrosen.unam.mx','jimenez@astrosen.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (51,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (52,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1526,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1527,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1528,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1530,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (304,'','','','','','','','','','','2008 reporta nombramiento de Jefe de seccin acadmica y  tcnico acadmico Asociado C. Pasante en la maestria de Bibliotecologia y Estudios de la Informacin. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (844,'Lic.','Lucila Martnez Arellano','56-22-50-31','','','','','bif@fisica.unam.mx','lucila@fisica.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (305,'Lic.','Pablo Carrasco Caas ','','','','pablo@fisica.unam.mx ','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (306,'Lic.','Ma. de la Luz Vela Rosales','','','','luz@fisica.unam.mx','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1866,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1867,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1868,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1870,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (368,'','','','','','','','','','','2008 Reporta nombramiento de Jefe de departamento y Tcnico Acadmico Titular A. Pasante en la maestria de Bibliotecologia y Estudios de la Informacin. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (369,'Lic.','Lucia Brito Ocampo','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (716,'Lic.','Luca Brito Ocampo','56-22-89-07','','','56-22-89-23','','biblioteca@biomedicas.unam.mx','lucia@biomedicas.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (370,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1936,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1937,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1938,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1940,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (661,'','','','','','','','','','','2008 reporta nombramiento de Coordinador de Biblioteca y   tcnico acadmico  Titular B. Doctor en Bibliotecologa y Estudios de la Informacin. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (723,'Dr.','Felipe Meneses Tello','56-22-44-77 (Servicios)','56-22-44-75 (Responsable)','','56-22-44-76 (Solicitar tono)','','biblioteca@matem.unam.mx','felipemt@matem.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (336,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (337,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1901,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1902,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1903,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1905,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (627,'','','','','','','','','','','2008 reporta nombramiento de tcnico acadmico Asociado C. Maestra en Bibliotecologa y Estudios de la Informacin. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (628,'Mtra.','Mara del Pilar Lpez Rico','56-22-78-90','Ext. Red UNAM 38255','','56-22-77-22','','mplr@unam.mx','pilar@matcuer.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (629,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (630,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2236,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2237,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2238,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2240,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2546,'','','','','','','','','','','2008 reporta nombramiento de  tcnico acadmico Titular A. Pasante en maestra de Bibliotecologia. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2547,'Lic.','Lidia Gonzlez Garca','56-23-27-72','01(443)  + 32-22-772 (Morelia)','','56-23-27-32 ','01(443)  + 32-22-732 (Direccin)','lidia@matmor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2548,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2549,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2553,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2554,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2555,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2557,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (257,'','','','','','','','','','','2008 reporta nombramiento de Coordinador de biblioteca y tcnico acadmico Titular B. Maestro en Bibliotecologa y Estudios de la Informacin. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (908,'Mtro.','Miguel Gama Ramrez ','56-22-74-25 (Prstamo)','56-65-14-51 (Responsable)','','56-65-14-51(Solicitar tono)','','bib@filosoficas.unam.mx','mgamar@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (258,'','Pedro Espinosa Ruiz','56-22-74-28','','','','','pedroer@servidor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (259,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1816,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1817,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1818,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1820,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (748,'Dra.','Elena Centeno Garca','56-16-05-57','56-22-43-10, ext. 113','','55-50-66-44','','centeno@unam.mx','hildals@geologia.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (376,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (377,'','','','','','','','','','','','Segundo periodo de Centeno 2014-2018, Boletin 366. 24 junio 2014 DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (763,'Mtra.','Silvia Estela Jurado Cullar','56-87-68-28, ext. 1701','56-87-62-38, ext. 1704','','silvia.jurado@dgenp.unam.mx','','silvia.jurado@dgenp.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (871,'Lic.','Luis Felipe Ortega Montiel','56-87-68-28 ext. 1211','55-36-74-25','','55-36-74-25','','luisfelipeom@yahoo.com','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (427,'C.P.','Sonia Marn Flores','56-87-69-09 ext. 1101, 1102','56-87-69-29 ext. 1101, 1102','','55-36-74-25','','','','','','Ratificacin Jurado Cullar (2014-2018) Boletin 380. 1 julio 2014, DPLybf. Nueva directora: Jurado (2010-2014) gaceta 4,261. 26 julio 2010. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (995,'','','','','','','','','','','NOTA: se cancela el registro de certificacin ISO, el 21 de mayo de 2013. confirmado con Mauricio Ramrez','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (904,'','Mauricio Ramrez Cuevas','56-23-05-30','56-23-06-25','56-23-05-00, ext. 30534','','','fesz.bc1@gmail.com','mauricio.ramrezcuevas@gmail.com','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (597,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (598,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2196,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2197,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2198,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2200,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (928,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (731,'Lic.','Luca Castro Prez','56-23-07-65 (Servicios)','56-23-07-64 (Responsable)','56-23-07-28 ','56-23-07-64 (Solicitar tono)','','lkastro71@yahoo.com.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (601,'','Juan Pramo','56-23-07-64','','','','','56-23-07-65','','L - V  8:30 a 20:00 hrs.',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (602,'','Silvia Gmez Rodrguez','56-23-07-28','','','56-23-07-65','','sigomr@correo.unam.mx','','L -V  8:30 a 18:00 hrs.',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2201,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2202,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2203,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2205,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (833,'Mtro. ','Carlos Vieyra Sedano','56-22-20-08','56-22-19-86','','','','cvieyras@derecho.unam.mx','cvieyra@unam.mx','','Nuevo coordinador de biblioteca de confianza. Mtro en Derecho titulado, Vieyra a partir del 01 agosto 2014, Confirmado via tel. Cese de responsable Sara Arellano 22 mayo 2014 via telefonica','6/6/14 interinos Eugenia y Emmanuel',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (950,'','Mara Eugenia Esparza Orozco (Jefa de biblioteca)','56-22-19-56 (Servicios)','56-22-19-86 (Hemeroteca)','','56 22 19 56 (Solicitar tono)','','mesparzao@derecho.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (177,'Lic.','Sara Arellano Palafox','56-22-20-19','','','56-22-19-56','','','','L - V 8:00 a 14:00 hrs.',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (178,'Mtro.','Alejandro Ortiz Mar','56-22-20-19','','','56-22-19-56','','','','L - V 8:00 a 18:00 hrs.',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1731,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1732,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1733,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1735,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1834,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (606,'','','','','','','','','','','eliminacin de telefonos a peticin de Shirley, por "acoso" 12.08.2014. DPLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (607,'Mtra.','Shirley Ainsworth','','','','','','shirley@ibt.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (608,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (609,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2221,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2222,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2223,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2225,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1206,'M. V. Z.','Oscar Gutirrez Prez','(761) + 73-40-454','(761) + 73-41-382','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1207,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1208,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1431,'M.P.A.','Hctor Basurto Camberos','(232) + 3 2-43-941','(232) + 32-43-942','','(232) + 32-43-943','','basurtoh@unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1432,'','Vctor Manuel Morales Huesca','01-323-324-3941 al 43','','','','','victormorales55@hotmail.com','','7:30 a 13:30   y 15:30 a 17:30',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1433,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (694,'Lic.','Concepcin Christlieb Robles','56-22-03-54 (Servicios)','56-22-02-97 (Coordinadora)','56-22-07-04','','','biblio_arquitectura_unam@yahoo.com.mx','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (894,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (75,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (76,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1561,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1562,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1563,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1565,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (696,'Lic.','Concepcin Christlieb Robles','56-22-02-97','56-22-03-54','56-22-07-04','','','biblio_arquitectura_unam@yahoo.com.mx','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (697,'','Mara de Lourdes Robleda Gonzlez de Castilla','56-23-00-62 (Servicios)','56-23-00-63 (Responsable)','','56-23-00-61 (Solicitar tono)','','lrobledag@unam.mx','lrobleda@prodigy.net.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (130,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (131,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1671,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1672,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1673,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1675,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (695,'Lic.','Concepcin Christlieb Robles','56-22-02-97','56-22-03-54','56-22-07-04','','','biblio_arquitectura_unam@yahoo.com.mx','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (865,'','Marco Miguel Moreno Crdova','56-22-07-12','','','56-22-08-35 (Unidad Administrativa)','','biblioteca_cidi@unam.mx','komar59@terra.com.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (69,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (70,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1566,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1567,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1568,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1570,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (996,'Arq.','ngel Huitrn Bernal','55-93-33-34','56-80-11-02','','56-80-09-31','','huitronb@hotmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (802,'Lic.','Armando Hernndez Gutirrez','55-93-36-04','','','','','','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (436,'Ing.','Rosa Maria Nares Ruiz','56-80-10-06','','','','','','','','','Nuevo director Angel Huitrn a partir del 29 de agosto de 2014. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (931,'Dra.','Rosaura Ruiz Gutirrez','56-22-49-94','56-16-18-03','','56-22-49-48 (Solicitar tono)','','direccion@ciencias.unam.mx','rosaura@ciencias.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (255,'Mtro.','Francisco Xavier Garca Santos (Secretario Administrativo)','56-22-48-97','56-16-04-51','','','','sadmin@hp.fciencias.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (251,'Ing.','Rosa Mara Nares Ruz','56-22-48-11','','','','','naresunam@hotmail.com','','','','Ratificacion 2014-2018 Rosaura Ruiz. 02.09.2014. DPLybf. Nueva directora: Ruiz (2010-2014) boletin  30 agosto 2010. Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (704,'Dr.','Pedro Salazar Ugarte','56-22-74-74, ext. 1214','','','','','pedsalug@yahoo.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (188,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (184,'','','','','','','','','','','','Nuevo director Dr. Salazar (2014-2018) 9.sept. 2014. DPLybf. Ratificacin Fix-Fierro (2010-2014)  boletin 08/09/10, Primer periodo 2006-2010 DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (620,'Lic.','Sal Armendriz Snchez','56-22-40-30','56-22-40-31','56-22-40-36 (Coordinador)','56-22-40-36 (Solicitar tono)','','asaul@bcct.unam.mx','asaul@xcaret.igeofcu.unam.mx','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (621,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (622,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (623,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2231,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2232,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2233,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2235,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (955,'Mtro.','Rosalio Luis Aguilar Almazn','56-68-08-08','56-22-92-68','','56-22-92-47','','director.sur.cch@gmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (954,'Lic.',' (Secretario Administrativo)','56-22-92-66','','','','','','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (174,'','','56-22-92-69','56-22-92-84','','','','','','','','Nuevo director Aguilar (2014-2018) 10 Abril 2014. DPLybf. Lic. Jaime Flores Suaste. 2o. perodo 2010-2014 a partir del 5 de abril de 2010 publicado en su pagina. Depto. Planeacin ',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (311,'','','','','','','','','','','2008 reporta nombramiento de  tcnico acadmico  Titular A. Mtria. Fsica de materiales. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (691,'Mtra.','Citlali Martnez Sisniega','56-22-65-20 al 24, ext. 601 (Servicios)','56-22-65-20 al 24, ext. 500 (Responsable)','01(646)  + 17-44-602, exts.  501 y 504 ','','','citlali@cnyn.unam.mx','apatron@cnyn.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (312,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (313,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1876,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1877,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1878,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1880,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (248,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (799,'Dr.','Fermn Lpez Franco','56-22-18-91 (Prstamo)','56-22-18-53 (Responsable)','56-22-18-90','56-22-18-28 (Solicitar tono)','','bsramos@unam.mx','ferminl@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (249,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (250,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1806,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1807,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1808,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1810,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (722,'Dr.','Rodolfo Zanella Specia','55-50-03-57','56-22-86-01','','56-22-86-20','','rodolfo.zanella@ccadet.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (123,'C.P.','Delia Angelica OReilly Haro (Secretario Administrativo)','56-22-86-02 Ext. 1104','','','','','delia@servidor.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (124,'LIC.','Nancy Pedroza','56-22-86-02 Ext. 1103','','','','','jorge.aldana@ccadet.unam','','','','Nuevo director Zanella 2013-2017 Boletin 734bis 9 dic.2013. Director  Saniger. Segundo informe del segundo periodo 13 febrero 2012. Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1664,'Sra.','Carmen Chagoyan Garca','56-22-86-02 Ext. 1113','','','','','carmenchag@correo.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1564,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1829,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (823,'Dr.','Vctor Manuel Mendoza Nez','56-23-05-40','57-73-63-10','','57-73-63-10 (Solicitar tono)','','vmmn@puma2.zaragoza.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (595,'Lic.','Raymundo David Garca Barrn (Secretario Administrativo)','56-23-06-35','','','','','gbr@fragoso.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (596,'Lic.','Elizabeth Olivares Castillo','56-23-06-44','','','','','','','','','Segundo periodo (2014-2018) 15 de nov. 2014. DPLybf. Mendoza Nez Primer periodo (2010-2014). 16 nov 2010. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (678,'Dr.','Mario Rueda Beltrn','56-22-69-86, exts. 2453','56-65-16-61','','','','diriisue@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (72,'Lic.','Jos Mara Garca Rojas(Secretario Administrativo)','56-22-69-77','56-22-69-95 exts. 2018 y 2019','','56-22-69-76','','jmaria@servidor.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (77,'C.P.','Gabriel Flores de la Torre','56-22-69-95 ext. 2438','56-22-69-86 ext. 2705','','','','gfdelatorre@hotmail.com','','','','Nuevo director Rueda (2014-2018) Boletin 684. 25 nov. 2014. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (135,'','','','','','','','','','','cambio de responsable Coordinador de biblioteca de confianza en 28 marzo 2012  .OTRO CORREO ALTERNATIVO : zapaliname56@libe.com.mx','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (786,'Dr.','Jess Valdez Ramos   ','56-22-06-79','','','55-50-30-08 (Direccin. Solicitar Tono)','','biblioteca@cele.unam.mx','valram@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (134,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (133,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1666,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1667,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1668,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1670,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1359,'Dra.','Berta Gilabert Hidalgo','56-22-99-68 (Red UNAM)','01 (762) + 62-23-410','','01 (762) + 62-20-124','','bgilabert@cepe.unam.mx','','',NULL,'Nueva directora CEPE TAXCO, Gilabert gaceta 10/marzo/2014 DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1360,'','','','','','','','','','',NULL,'Nueva directora CEPE TAXCO, Gilabert gaceta 10/marzo/2014 DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1361,'','','','','','','','','','','','Nueva directora CEPE TAXCO, Gilabert gaceta 10/marzo/2014 DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (61,'','','','','','','','','','','cambio de correos 9/11/12. CAMBIO RESPONSABLE Dr,  en matemticas Arturo Vargas  abril/2013. su nombramiento es de investigador, no tiene nombramiento oficial de responsable de la bca. DPLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (936,'Dr.','Carlos Arturo Vargas Guadarrama','56-22-36-54 (Servicios al pblico)','56-22-36-56 (Prstamos)','56-22-36-11  y 56-22-35-61 (Responsable)','55-50-75-92','','biblio@iimas.unam.mx','cav@mym.iimas.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (62,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (71,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1611,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1612,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1613,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1615,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (322,'Lic.','Mara de Guadalupe Flor Daz de Len Fernndez de Castro','56-22-82-12','56-22-81-56','56-22-08-97','','','diazdeleonflor@ingenieria.unam.mx','diazdeleonsua@gmail.com','','A partir de abril 2012, el espacio en mezanine fue ocupado para archivo histrico y la biblioteca  ','Nueva coordinadora a partir de 25 de julio/2012 Diaz de Len',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (882,'','Francisco Omar Escamilla Gonzlez','56-23-29-92','56-23-29-93','','55-10-05-73','','acervohistoricopalaciomineria@yahoo.com.mx','omareg@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (323,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (324,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1886,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1887,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1888,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1890,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2588,'Dr.','Renato Gonzlez Mello','','','','','','iie.direccion@gmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2589,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2590,'','','','','','','','','','','','Ratificacin de director. Segundo periodo 2014-2018. Boletin 698. 2 dic. 2014. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2134,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (736,'Dr.','Carlos Agustn Escalante Sandoval','56-22-08-66','56-16-28-27','','56-16-28-90','','faing@unam.mx','caes@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (281,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (282,'','','','','','','','','','','','Nuevo Director Agustin Escalante (2015-2019) Boletin 98. 17 feb 2015 DPLybf. Segundo periodo: Guerrero (2011-2015) gaceta 4,313, 17 febrero 2011. Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (739,'Dr.','Carlos Agustn Escalante Sandoval','56-22-08-66','56-16-28-27','','56-16-28-90','','faing@unam.mx','caes@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (320,'','','','','','','','','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (321,'','','','','','','','','','','','Nuevo director (2015-2019) 17 feb 2015. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (738,'Dr.','Carlos Agustn Escalante Sandoval','56-22-08-66','56-16-28-27','','56-16-28-90','','faing@unam.mx','caes@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (289,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (290,'','','','','','','','','','','','Nuevo director (2015-2019) 17 feb 2015. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (425,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (737,'Dr.','Carlos Agustn Escalante Sandoval','56-22-08-66','56-16-28-27','','56-16-28-90','','faing@unam.mx','caes@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (285,'Ing.','Luis Jmenez Escobar (Secretario Administrativo)','56-22-08-68','56-22-08-67','55-50-71-50','','','jimeneze@yahoo.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (286,'Lic.','Martn Santa Olalla Calvo','56-23-29-67','','','','','martinsan@mineria.unam.mx','','','','Nuevo director (2015-2019) 17 feb 2015. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (735,'Dr.','Carlos Agustn Escalante Sandoval','56-22-08-66','56-16-28-27','','56-16-28-90','','faing@unam.mx','caes@unam.mx','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (280,'Ing.','Luis Jmenez Escobar','55-50-71-50','','','','','jimeneze@yahoo.com','','',NULL,'',NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (276,'Lic.','Pablo Cervantes Prez','56-22-08-69','','','','','dte18@hotmail.com','','','','Nuevo director (2015-2019) 17 feb 2015 DPLybf. Ratificacin Guerrero (2011-2015) 17 febrero 2011. Primer periodo (2007-2011)  DPLybf. director Carrasco Nez, 2010-2014, g. 4,245. 11/05/2010. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (327,'','','','','','','','','','','2008 reporta nombramiento de Coordinador de Biblioteca y tcnico acadmico  Titular B. Maestra en Bibliotecologia y Estudios de la Informacin. PLybf ','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (328,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (329,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (884,'Mtra.','Mara Teresa Vzquez Meja','56-16-11-48','56-22-46-09','','56-16-11-48 (Solicitar tono)','','biblioteca@iim.unam.mx','mtvm@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1891,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1892,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1893,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1895,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (832,'','','','','','','','','','','Nueva responsable Mtra. en  bibliotecologia (COLMEX) Alexa Milley. 12 enero 2015. DPLybf. La Lic. Edith Cinta Elias est en trmites de Jubilacin enero-abril 2014. El coordinador de la biblioteca es el Dr. Julio Collado Vides- enero 2014 DPLyb','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (707,'Mtra.','Alexa Milley Gmez Restrepo','56-22-77-06 (Servicios)','56-22-77-07 (Responsable) ','','','','biblio@ccg.unam.mx','amgomez@ccg.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (105,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (106,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1631,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1632,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1633,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1635,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (99,'','','','','','','','','','','2008 reporta nombramiento de tcnico Acadmico Titular B. Pasante en la maestria de Bibliotecologia y Estudios de la Informacin. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (971,'Lic.','Sandra Guillermina Moncada Hernndez','56-22-56-06','','','','','smoncada@ifc.unam.mx','moncada@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (100,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (101,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1626,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1627,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1628,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1630,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (411,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (778,'Lic.','Luis Alfonso Vilchis Romero ','56-23-13-21 (Servicios)','56-23-13-19 (Responsable)','53-90-76-03','53-90-76-03 (Solicitar tono)','','udc@campus.iztacala.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (412,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (413,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1981,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1982,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1983,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1985,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2034,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (711,'Lic. ','Diana Cecilia Ortega Amieva','56-22-63-71 al 74','','','56-22-63-70','','dcortega@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (459,'Lic. ','Luis Rogelio Fvela Hernndez','56-22-63-77','56-24-80-64','','56-22-63-13','','hcastuera@servidor.unam.mx','lrfavela@unam.com.mx','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (460,'Sr.','Francisco Aguilar Vargas (encargado del rea)','56-22-63-77','56-24-80-66 ','','56-22-63-13','','efaufran@yahoo.com.mx','','','','cambio de director. Lic. Ortega a partir de 16 de enero 2015. DPLybf. Ratificacin Director Eslava (2012-2016) Primer periodo (2008 -2012) marzo 2008. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1649,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (156,'Mtra. ','Rosa Guadalupe Valadez Olguin','56-23-19-97 (Coordinadora)','56-23-19-95 (Coordinadora)','56-23-19-96 (Servicios)','58-70-56-73','','fesc@unam.mx','','','CAMBIO DE RESPONSABLE: lic. Escobedo termina y continua la Mtra. Valadez a partir del 17. de febrero 2014. DPLybf ','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (963,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (157,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (158,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1696,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1697,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1698,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1700,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (962,'Mtra.','Rosa Guadalupe Valadez Olguin','56-23-19-97 ','56-23-19-95 ','','58-70-56-73','','fesc@unam.mx','','','Cambio de coordinador y responsable a partir de 17 de febrero de 2014. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (961,'Mtra.','Margarita Zapata Guerrero','56-23-20-52 (Servicios)','56-23-20-33 (Responsable)','','56-23-20-52 (Solicitar tono)','','margaret@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (152,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (153,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1691,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1692,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1693,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1695,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1529,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2124,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2104,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (66,'','','','','','','','','','','Nueva responsable Mtra Valdez ingreso abril 2015. DPL. ybf. Provisional Bibiotecario. 5 marzo 2015. Nuevo coordinador Belmont, ingresa el 1 de octubre 2013. DPLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (893,'Mtra.','Georgina Yuriko Valdez Angeles','55-22-06-30, exts. 236 (Servicios) ','55-22-31-02, exts. 236 y 237 ','55-22-04-77, ext. 237 (Responsable)','','','gyvaldeza@gmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (67,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (60,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1556,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1557,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1558,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1560,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (795,'Mtro.','Jos Arturo Fernndez Pedrero','56-23-22-00','56-16-27-12','','55-50-87-07','','pedrero1@servidor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (423,'Lic.','Jorge Ramrez Oropeza  (Secretario Administrativo)','56-23-22-34','','','','','jramirez@fo.odonto.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (424,'C.P.','Silvia Meza Fernndez','56-23-22-02','','','','','saravm@economia.unam.mx','','','','Segundo periodo Pedrero (2014-2018) Boletin 541. 17 sept. 2014. DPLybf. Nuevo director Fernndez Pedrero, 2010-2014, noticia 14/09/2010. Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1999,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (915,'Mtra. ','Mara del Carmen de Lara Rangel','56-23-38-01','56-22-48-00, ext. 47126','','','','dircuec@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (755,'Lic.','Jos Antonio Martnez Durn','56-82-61-95','56-82-71-23 ext. 109','','56-82-78-44','','joseamtz@correo.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (194,'C.P.','Rosana Bates Acosta','56-82-61-95 ext. 122 y126','','','56-82-78-44','','','','','','Designacin de nueva directora cineasta De Lara. Boletin 274. 12 mayo 2015 DPLybf. Nuevo director: Coria Coral 2012-2016 Via telefonica 1o. agosto/2012. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (873,'','','','','','','','','','','','Nuevo responsable Maestro en bibliotecologia (UNAM) Fernando con nombramiento de jefe de biblioteca, administrativo. DPLybf. 13 mayo 2015.Cambio de responsable interina. Bibliotecaria Silvia Mndez. 16/feb/2015. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (866,'Mtro.','Fernando Xochiteotzin Pea','56-22-55-51','','','56-22-55-51 (Solicitar tono)','','biblioposgrado.fo@gmail.com','fxoch@yahoo.com.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (426,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1996,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1997,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1998,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2000,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (493,'Lic.','Sal Armendriz Snchez','56-22-40-30','56-22-40-31','56-22-40-36 (Coordinador)','56-22-40-36 ','','asaul@bcct.unam.mx','asaul@xcaret.igeofcu.unam.mx','','Nueva responsable  Mtra. en Ciencias, Tcnico Acadmico titular A, 01 junio 2014. DPLybf  .','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (924,'Mtra.','Laura Celis Gutirrez','56-22-85-96, ext. 152','56-22-85-97, ext. 152','01(998)  + 87-10-009, ext. 152','','','lcelis@cmarl.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (499,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (496,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2091,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2092,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2093,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2095,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2184,'Lic.','Ma. Eugenia Iniestra Figueroa (encargada)','56-22-87-89','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (725,'Dr.','Manuel Torres Labansat','56-22-50-32','56-65-72-63','','56-16-15-35','','direccion-if@fisica.unam.mx','torres@fisica.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (302,'C.P.','Rosa Ma. Pacheco Lpez','56-22-50-35','','','56-22-50-00','','rosma@fisica.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (388,'','','','','','','','','','','2015 abril Nuevo responsable Lic. en bibliotecologa, tcnico acadmico. DPLybf. 2008 reporta nombramiento de Jefe de biblioteca.Bachillerato. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (303,'C.P.','Marcos Snchez Csar','56-22-50-36','','','56-22-50-00','','marcos@fisica.unam.mx','','','','Ratificacin, 2o. periodo de Torres (2015-2019) 18 de mayo 2015 DPLybf. Nuevo director Torres Labansat  (2011-2015) Boletin 16 mayo 2011.  Depto. Planeacin ',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (291,'Lic.','Mara de Guadalupe Flor Daz de Len Fernndez de Castro','56-22-82-12','56-22-81-56','56-22-08-97','','','diazdeleonflor@ingenieria.unam.mx','diazdeleonsua@gmail.com','','Nueva coordinadora a partir de 25 julio/2012  Daz de Len. correo alternativo  diazdeleonflor@fingenieria.unam.mx','Correo alternativo Lic. Garca. oicoracilegna@gmail.com  DPL.bfy 25 mayo 2015',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (900,'Lic.','Roco Anglica Garca Garca (Jefa de Biblioteca)','56-22-82-11 (Servicios)','56-22-82-15 (Prstamo)','56-22-82-12','','','bibliotecanexo@gmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (292,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (293,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1851,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1852,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1853,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1855,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2273,'Dr.','Alejandro Casas Fernndez','56- 23- 27- 04','01 (443) +  32-22-704 (Morelia)','','01 (443) +  32-22-719 (Morelia)','','acasas@cieco.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2274,'Lic.','Claudia Sanchez Hernndez','56-23-27-02','','','56-23-27-22','','csanchez@cikos.unam','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2275,'Ing.','Jess Enrique Velazquez Barrera','56-23-28-29','','','56-23-27-22','','evelazquez@cikos.unam.mx','','','','Ratificacin  Dr. Casas como primer director de IIES (2015-2019) 28 mayo 2015. DPLybf. Nuevo director  Casas Fernndez, 2011-2015 boletin 298-20/mayo/2011. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (96,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (990,'Mtra.','Beatrz Jurez Santamara ','56-22-39-04 (Servicios)','56-24-49-36 (Responsable)','','','','bibliotecacu@astro.unam.mx','bjuarez@astro.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (95,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (94,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1521,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1522,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1523,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1525,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (613,'Lic.','Sal Acua Paredes','56-22-59-57','56-22-59-04 (Coordinacin)','Ext. RedUNAM 45325','56-22-59-04 (Solicitar tono)','','saul.3710@gmail.com','','','Nuevo coordinador a partir del 1 de junio de 2015 Licenciado en bibliotecologa titulado por la UNAM. DPLybf 1 junio 2015. Cambio de coordinador a partir de 1 de agosto 2013, ingresa Novelo','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (614,'Dr.','Jess Jarillo Rodriguez','01(232)  + 32-43-941, ext. 122 (Servicios)','01(232)  + 32-43-942, ext. 103 (Responsable)','','01(232)  + 32-43-943 (Solicitar tono)','','jarilloj22@hotmail.com','basurtoh@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (615,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (616,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2226,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2227,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2228,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2230,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (887,'Lic.','Sal Acua Paredes','56-22-59-57','56-22-59-04 (Coordinacin)','Ext. RedUNAM 45325','56-22-59-04 (Solicitar tono)','','saul.3710@gmail.com','','','Nuevo coordinador licenciado en bibliotecologia titulado por la UNAM el 1 de junio 2015. DPLybf 1 junio 2015','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (952,'M. V. Z.','Csar Flores Serrano','01(739)  + 39-30-142 ','01(739)  + 39-30-616 ','','01(739)  + 39-30-616 (Solicitar tono)','','ceflose@yahoo.com.mx','omejia@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (238,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (239,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1796,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1797,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1798,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1800,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (891,'Lic.','Sal Acua Paredes','56-22-59-57','56-22-59-04 (Coordinacin)','Ext. RedUNAM 45325','56-22-59-04 (Solicitar tono)','','saul.3710@gmail.com','','','Nuevo coordinador licenciado en bibliotecologia titulado por la UNAM el 1 de junio 2015. DPLybf 1 junio 2015','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (991,'M. V. Z.','Juan Antonio Rodrguez Garca','01 (414) + 291-81-00','','','01 (414) + 291- 81- 05','','ceiepaa@unam.mx','jarg9702@hotmail.com','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (579,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (580,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2176,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2177,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2178,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2180,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (889,'Lic.','Sal Acua Paredes','56-22-59-57','56-22-59-04 (Coordinacin)','Ext. RedUNAM 45325','56-22-59-04 (Solicitar tono)','','saul.3710@gmail.com','','','Acadmico director tcnico Gutirrez. 10/mar/2015 DPL','Nuevo coordinador de bibliotecas licenciado en bibliotecologia, titulado por la UNAM. ingresa el 1 de junio de 2015. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (926,'M.V.Z.','Oscar Gutirrez Prez','01(761)  + 73-40-454','01(761)  + 73-41-382','','','','koala630816@yahoo.com.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (300,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (301,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1861,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1862,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1863,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1865,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (888,'Lic.','Sal Acua Paredes','56-22-59-57','56-22-59-04 (Coordinacin)','Ext. RedUNAM 45325','56-22-59-04 (Solicitar tono)','','saul.3710@gmail.com','','','Nuevo coordinador licenciado en bibliotecologia titulado por la UNAM ingresa el 1 de junio 2015. DPLybf ','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (679,'M.V.Z','Alma Selene Vzquez Delgado','58-45-00-29','58-45-15-30','','58-45-15-30 (Solicitar tono)','','mvzalmavazquez@gmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (296,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (297,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1856,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1857,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1858,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1860,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (779,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (523,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (973,'Dr.','Jorge Manuel Vzquez Ramos','56-22-36-90','56-16-26-04','','56-16-18-68','','jorman@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (464,'Dr.','Rodolfo Luis Moreno Gonzlez(Secretario Administrativo)','56-22 3510','','','5622 3715','','rodolfo@dgp.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (465,'L.A.E.','Liliana Snchez Lpez','56-22-30-96','56-16-13-13','','','','','','','','Ratificacin de Vzquez (2015-2019) DPLybf. 2 de junio 2015. Nuevo director : Vzquez Ramos 2011-2015 boletin 31/05/2011. Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1634,'Lic.','Mara del Carmen Armijo Abdo','56-22-76-99','','','01(777) + 31-75-581','','armijo@ccg.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (200,'','','','','','','','','','','Licenciada en psicologa: Briseida nueva responsable del CI, cambio 5/12/13 DPLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (827,'Psic.','Briseida Garca Verdugo','56-23-70-85, ext. 80319','56-22-66-66, ext. 80319','','','','bgarcia@posgrado.unam.mx','begobass@hotmail.com','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (201,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (202,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1756,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1757,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1758,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1760,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (398,'','','','','','','','','','','Cambio de responsable 1o. mayo 2013 Licenciada en bibliotecologia.UNAM, Nicolasa Ramrez. DPLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (836,'Lic.','Nicolasa Ramrez Vicente','56-23-04-25 (Servicios)','56-23-00-31 (Responsable)','','','','bibliosceiich@gmail.com','nicolasa@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (399,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (400,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1966,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1967,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1968,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1970,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (9,'','','','','','','','','','','2008 reporta nombramiento de Jefe de Departamento y tcnico acadmico titular B. Pasante en la Maestra en Bibliotecologa y Estudios de la Informacin. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (798,'Lic.','Jos Juan Betn Gonzlez','56-23-02-20','56-23-02-21','Ext. RedUNAM 42233 (Responsable)','56-23-02-19','','bcialc@unam.mx','betan@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (10,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (11,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1616,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1617,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1618,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1620,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (242,'','','','','','','','','','','2008 reporta nombramiento de Coordinador y tcnico acadmico Asociado B. Licenciada en Bibliotecologa. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (788,'Lic.','Celia Martnez Garca','56-23-03-15 ','56-23-03-14 (Responsable)','Ext. RedUNAM 42029 (Informacin especializada)','56-23-03-15 (Solicitar tono)','','zairon@hotmail.com','zairon@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (243,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (244,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1801,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1802,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1803,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1805,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (905,'Lic.','Mara Eidi Crdova Moreno','01(967)  + 67-82-997, ext. 121 (Servicios)','01(967)  + 67-81-491, ext. 136 (Responsable)','','01(967)  + 67-80-631','','cmeidi@hotmail.com','angovez@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (389,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (390,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1956,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1957,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1958,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1960,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (406,'','','','','','','','','','','Cambio responsable 17 sept 2013. Licenciada en bibliotecologia titulada: Flores./1o. feb. cambio de responsable por lo menos en tres meses posteriores se tendr responsable interina la S. T. Gallardo Gutirrez. Prejubilacin de Martha Alicia Fras. DPLybf','Correo alternativo stecnica@correo.crim.unam.mx. 22 mayo 2013',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (876,'Lic.','Alva Flores Romero','56-22-78-20 ','01(777) + 317-50-11, ext. 118 (Cuernavaca)','01(777) + 317-52-99, ext. 118 (Cuernavaca)','','','biblioteca@correo.crim.unam.mx','floralv@correo.crim.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (407,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (408,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1976,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1977,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1978,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1980,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1509,'','','','','','','','','','','santiago@humanidades.unam.mx (alternativo). Nuevo responsable oficial desde mayo 2013, Maestro en bibliotecologia y Estudios de la Informacin: Santiago Pacheco. DPLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1510,'Mtro.','Luis E. Santiago Pacheco ','56-22-67-28, ext. 111 ','01(999) + 92-28-446 al 48, ext. 111 (Mrida)','','','','lsantiago@humanidades.unam.mx','zanthiago@gmail.com','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1511,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1512,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1516,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1517,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1518,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1520,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2595,'Mtra.','Alba Eugenia Vsquez Miranda','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2596,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2597,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2591,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2592,'Lic.','Luca Mercedes Prez Rojas','01 (951) + 51-12-150, ext. 519 ','01 (951) + 51-60-541, ext. 519','','','','luciaperezrojas@hotmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2593,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2594,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2598,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2599,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2600,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2602,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (537,'','','','','','','','','','','ejoel62@hotmail.com (Alternativo) junio2015. 2008 reporta nombramiento de  Coordinador de biblioteca y Tcnico Acadmico Titular B. Maestro en Bibliotecologa y Estudios de la Informacin. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (775,'Mtro.','Joel Estudillo Garca','56-23-00-07','Ext. RedUNAM 42155 (Responsable)','','56-23-00-19 (Direccin)','','joel_estudillo@pueg.unam.mx','ejoel@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (538,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (539,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2131,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2132,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2133,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2135,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2511,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (673,'Mtra.','Alma Anglica Martnez Prez ','56-01-35-62 ','56-01-35-59','','56-01-35-61, ext. 132 (Solicitar tono)','','alma_angelica_s@hotmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (831,'Lic.','Luis Felipe Ortega Montiel','56-01-35-61','56-01-35-61','','','','luisfelipeom@yahoo.com','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (453,'C.P.','Perla Xochitl Escutia Montiel','56-01-35-61 al 70 ext. 124','','','','','','','','','Ratificacin directora nuevo periodo 2009-2013 DPLybf, Gaceta 221/4212. 7/1/10 CAMBIO DE DIRECTOR EL 5 DE JULIO DE 2010 Jurado Cullar a la Dir. Gral. de Preparatoria, Nueva directora Martinez Prez a partir de nov. 2010 ',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2044,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1344,'Dr.','Samuel Enrique Gmez Noguera (Jefe de Unidad)','01(669) 98-52-848 ext. 205','','','01(669) 98-13-688','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1345,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1346,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (492,'Lic.','Sal Armendriz Snchez','56-22-40-30','56-22-40-31','56-22-40-36 (Coordinador)','56-22-40-36 (Coordinacin de la BCCT)','','asaul@bcct.unam.mx','asaul@xcaret.igeofcu.unam.mx','','2015 Nuevo responsable Oviedo y tcnico acadmico asociado c. Licenciado en biblioteconoma. 25 feb 2015. DPLybf. 2008 reporta nombramiento de  Tcnico Acadmico Titular A. Bachillerato. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (877,'Lic.','Daniel Oviedo Jurez','56-22-65-40 y 41, ext. 246 (Circulacin)','56-22-65-40 y 41, ext. 244 (Responsable)','01(669)+ 98-52-845 al 48, exts. 244 y 246','01(669) + 98-26-133','','biblio@ola.icmyl.unam.mx','danieloviedo@ola.icmyl.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (495,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (498,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2086,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2087,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2088,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2090,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (767,'Dr.','Vctor Snchez-Cordero Dvila','56-22-90-65','56-22-90-66','','56-16-23-26','','dibunam@ibiologia.unam.mx','victor@ibiologia.unam.mx','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (232,'C.P.','Pedro Enrique Muoz Jurez','56-22-90-83','','','55-50-14-14','','secadmon@ibiologia.unam.mx','','9:00 a 16:00 y de 17:00 a 19:30 hrs.',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (229,'Lic. ','Ramn Santiago Guadalupe','56-22-90-81','','','55-50-14-14','','rsg@ibiologia.unam.mx','','9:00 a 15:00 y de 16:00 a 18:30 hrs.','','Segundo periodo de Snchez Cordero (2015-2019), gaceta 2 de julio 2105, DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (768,'Dr.','Vctor Snchez-Cordero Dvila','56-22-90-65','56-22-90-66','','56-16-23-26','','dibunam@ibiologia.unam.mx','victor@ibiologia.unam.mx','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (236,'C.P.','Pedro Enrique Muoz Juarz','56-22-90-83','','','55-50-14-14','','secadmon@ibiologia.unam.mx','','9:00 a 16:00 y de 17:00 a 19:30 hrs.',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (233,'Lic.','Ramn Santiago Guadalupe','56-22-90-81','','','55-50-14-14','','rsg@ibiologia.unam.mx','','9:00 a 15:00 y de 16:00 a 18:30 hrs.','','Segundo periodo de Snchez (2015-2019), 2 julio 2015 DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2558,'Dr.','Javier de la Fuente Hernndez','01 (477) 194-08-00, ext. 43304','','','','','direccion@enes.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2559,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2560,'','','','','','','','','','','','Ratificacin  boletin 447. 3 de agosto 2015 DPLybf. Segundo periodo de de la Fuente (2015-2019) via  telefnica 1 julio 2015 DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (332,'','','','','','','','','','','2008 reporta nombramiento de jefe de departamento y de confianza, Pasante en Biblioteconoma. DPLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (834,'','Fernando Garca Prez','56-22-98-46 (Responsable)','56-22-98-47 (Jefa de Biblioteca)','56-22-98-45 (Servicios)','56-22-98-45 (Solicitar tono)','','biblioteca@ier.unam.mx','fgp@ier.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (333,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (334,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1896,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1897,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1898,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1900,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (588,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (885,'Lic.','Mara Guadalupe Rojo Czares','56-22-87-19','','','55-50-84-05 (Coordinacin)','','biblioteca_cuaed@cuaed.unam.mx','guadalupe_rojo@cuaed.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (589,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (590,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2186,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2187,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2188,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2190,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (78,'','','','','','','','','','','Nuevo Coordinador de la biblioteca y tcnico acadmico: Mtro. en bibliotecologia y ciencias de la informacin, titulado. 04 sept. 2015. DPLybf. Domnguez, 19 agosto 2013- baja 26 de agosto 2015.  DPLybf ','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (717,'Mtro.','Sergio Arregun Meneses','56-22-69-86, exts. 2109 y 1312 (Servicios)','56-22-69-86, ext. 2101 (Responsable)','56-22-69-86, ext. 2103 ','56-65-01-23 (Direccin)','','bibiisue@gmail.com','biblioteca_iisue@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (88,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (89,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1621,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1622,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1623,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1625,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (858,'Dra.','Elizabeth Fuentes Rojas','54-89-49-24, exts. 119 y 121','','','54-89-49-23','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (999,'Lic.','Luis Carlos Santana quintana (Secretario Administrativo)','54-89-54-25','','','','','luiscs@servidor.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (930,'Mtro.','Jos Cupertino Rubio Rubio','57-19-21-93','50-97-21-01 ','','53-68-87-67','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (90,'L.C.','Olmpica Obregn Velasco','54-89-49-18, 22','','','','','maxyamy@hotmail.com','','','','Nueva directora FAD: Fuentes (2014-2018) Boletin 29 abril 2014 DPLybf. Nuevo director: Manzano (2010- 2014) Boletin informativo 28 abril 2010. Departamento de Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1554,'Lic.','Daniel Garca Barragn','54-89-49-21  ext. 110 y 106','','','','','abidan66@hotmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (501,'','','','','','','','','','','2008 reporta nombramiento de Coordinador de Biblioteca  y tcnico acadmico Titular B. Pasante en la maestra de Bibliotecologa y Estudios de la Informacin. PLybf','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (690,'Lic.','Sandra Guadalupe Rosas Poblano','56-22-45-66','56-24-56-07','','56-16-62-27 (Solicitar tono)','','biblioteca@iquimica.unam.mx','sandrarp@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (502,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (503,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2096,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2097,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2098,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2100,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2543,'Dr.','Daniel Juan Pineda','56-23-27-98','01 (443) + 322-27-98 (Morelia)','','56-23-27-32','01 (443) + 322-27-32 (Morelia)','daniel@matmor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2544,'Lic','Mireya Fabin Ramrez (deleg. admva.)','56-23-27-31','','','56-23-27-32','','mireya@matmor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2545,'Lic.','Mireya Fabin Ramrez','562-32-733','562-32-798','','56-23-27-32','','mireya@matmor.unam.mx','','','','Ratificacin  Juan Pineda (2015-2019) Boletin 524. 11.sept. 2015. DPLybf. Primer director Juan Pineda 2011-2015, Gaceta 12/septiembre/2011. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2573,'Dr.','Jos Antonio Vieyra Medrano','56-23-27-77','Red UNAM ext. 32865','01 (443) +322-38-65 (Morelia)','01 (443) +322 38 65 (Morelia, solicitar tono)','','avieyra@ciga.unam.mx','direccin@ciga.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2574,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2575,'','','','','','','','','','','','Nuevo director Vieyra Medrano (2015-2019) G. 4722. 14 sept. 2015. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2333,'Dr.','Enrique Cristian Vzquez Semadeni','56-23-27-95','Ext. Red UNAM  32795','01 (443) +322-27-95 (Morelia)','','','direccin@crya.unam.mx','e.vazquez@crya.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2334,'Lic.','Reynaldo Hernndez Delgado','01(443) 322 2728 ','5623 2728','','56-23-27-26 ','','rhernandez@crya.unam.mx','rhernandez@astrosmo.unam.mx','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2335,'Lic.','Carol Rangel Castro','56-23-27-95 y 96','56-23-22-78','01(443) 322 3884','56-23-27-26','','c.rangel@astrosmos.unam.mx','','','','Nuevo director Vzquez Semadeni (2015-2019) G. 4722. 14 sept. 2015. DPLybf. Ratificacin Lizano (2011-2015) 20 mayo 2011. Primer periodo (2007-2011) DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (766,'Dr.','Vctor Snchez-Cordero Dvila','56-22-90-63','56-22-90-67','','55-50-01-64','','dibunam@ib.unam.mx','victor@ib.unam.mx','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (228,'Lic.','Claudia A. Canela Galvn ','56-22-90-83','56-22-90-69','','55-50-14-14','','ccanela@ibiologia.unam.mx','','9:00 a 16:00 y 17:00 a 19:30',NULL,'',NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (224,'Ing.','Enrique Sandoval Ballesteros','56-22-90-81','56-22-91-28','','55-50-14-14','56-22-89-70','rsg@ibiologia.unam.mx','ifcomi@ibiologia.unam.mx','9:00 a 15:00 y de 16:00 a 18:30','','Ratificacin de director (2015-2019) segundo periodo de Snchez Cordero, gaceta 2 julio 2015. DPLybf. Nuevo director, nombre completo Vctor Manuel Guillermo Snchez Cordero Dvila (2011-2015) Boletin 28 junio 2011 DPLybf, Primer informe 2011-2012 Gaceta 07/01/13. Segundo informe, gaceta 02/dic/2013.',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (777,'Dr.','Arturo Iglesias Mendoza','56-16-23-44','56-22-41-22','','55-50-24-86','','director@geofisica.unam.mx','arturo@geofisica.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (644,'Sra.','Cecilia Pliego Garza (Secretario Administrativo)','56-16-27-33','56-22-41-08','','56-22-41-44','','cpliego@geofisica.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (640,'C. P. ','Viviana Torres Valle','56-22-41-11','56-22-41-02','','56-22-41-11','','viviana@geofisica.unam.mx','','','','Nuevo director: Iglesias (2013-2017) boletin DGCS 202, 02/abril/2013.  DPLybf. Director: Valds Galicia (2009-2013) Boletin 189 /31 marzo/2009. ',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (826,'Dra.','Martha Patricia Ostrosky Shejet','56-22-89-05','56-22-89-06','','55-50-64-47','','direccion@biomedicas.unam.mx','ostrosky@biomedicas.unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (371,'Lic.','Cristina Ordoez Rangel (Secretario Administrativo)','56-22-89-02','','','55-50-00-48','','bandrade@biomedicas.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (367,'Lic.','Mario Curel Fonseca','56-22-89-03','','','55-50-00-48','','mariocuriel@biomedicas.unam.mx','','','','Ratificacin  Dra. Ostrosky (2015-2019) segundo periodo 26/03/2015 DPLybf. Nueva directora: Ostrosky Shejet, (2011-2015) gaceta  4.323.  24 marzo 2011. Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (796,'Dr.','Jos Antonio Seade Kuri','56-22-45-23','56-22-45-24','56-22-45-25','55-50-13-42','','jseade@matcuer.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (338,'C.P.','Armando Ramrez  Manjarrez (Secretario Administrativo)','56-22-45-54 y 57','56-22-44-74','56-22-45-82 y 29','56-22-44-73','','aramirez@matem.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (335,'Lic.','Patricia Valle Garca','56-22-47-54','','','56-22-44-73','','paty@matem.unam.mx','','','',' Nuevo director Seade (2014-2018) Boletin 236, 22 abril 2014. DPLybf. Segundo periodo: Bracho (2010-2014) gaceta 4,240  22/04/10. Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (934,'Dr.','Jorge Pen Peralta','56-22-44-20','56-22-44-26','56-16-25-76','56-16-22-17','','direciq@unam.mx','jpeon@unam.mx','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (504,'Lic.','Jos Alejandro Roque (Secretario Administrativo)','56-22-44-34','56-16-68-96','','56-16-22-03','','jroque@servidor.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (500,'Sra.','Araceli  Vzquez','56-22-44-39','','','56-16-22-03','','araceliv@correo.unam.mx','','','','Nuevo director: Pen (2014-2018) Boletin 264. 06 mayo 2014 DPLybf.  Cuevas (2010-2014), gaceta 4,244.  06 mayo 2010. Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1446,'Dr.','Ramiro Prez Campos','56-23-41-50','56-23-41-51','01 (442) 238-11-51 (Quertaro)','56-23-41-50','','ramiro@fis.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1447,'C. P.','Andrea','56-23-41-56 ','Qro. (442) 238-11-56','','','','ruma@servidor.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1448,'C.P.','Miguel Velzquez Mora','56-23-41-55','Qro. (442) 238-11-55','','','','','vemora@fata.unam.mx','','','Ratificacin Prez (2014-2018) Boletin 07 mayo 2014. Primer periodo 2010-2014. G. 4,245. 11/05/2010. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (835,'Dr.','scar Edel Contreras Lpez','56-22-65-20, exts. 704 y 706','01 (646) +17-44-602, exts. 704 y 706 (Ensenada)','','','','edel@cnyn.unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (314,'C.P.','Rben Cruz Medrano','56-22-64-77','','','56-22-64-77','','ruben@dgsg.unam.mx','','',NULL,'',NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (310,'C.P.','Jos Prez Gonzalez','56-22-65-20 Ext. 4333','','','01 646 1752361','','jperez@cnyn.unam.mx','','','','Cambio de director Contreras  (2014-2018) 05/03/14, Boletin 132, DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1506,'Dr.','Adrin Curiel Rivera','56-22-67-28, ext, 121','56-22-67-29, ext. 121','01 (999) 92-28-446, ext. 121 (Mrida)','','','acurielrivera@gmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1507,'Lic.','Gerardo Oceguera Jmenez (Deleg. Administrativo)','01 (353) 53-30-758 ext. 311','','','01 (353) 53-30-758 ext. 312','','goceguera@humanidades.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1508,'Lic.','Jess Ramos Cedillo','56-22-75-67 ext. 154','','','56-22-75-77','','jramosc@humanidades.unam.mx','','','','Nuevo Director Curiel Rivera (2015-2019) Boletin 540. 17 sept. 2015. DPLybf. Dir. anterior: Lisbona Guilln 2012-2016. Boletin 752bis/05/12/12. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (789,'Dr.','Jaime de Urquijo Carmona','56-22-77-45','56-22-77-46','01 (777) + 329-17-30 (Cuernavaca)','56-22-77-53','','direccion@fis.unam.mx','jdu@fis.unam.mx','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (674,'Lic.','Sabino Marban Ocampo','56-22-77-47','56-22-77-48','','56-22-77-53','','smo@fis.unam.mx','','',NULL,'',NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (307,'Lic.','Martha Patricia Rodrguez Moran','56-23-82-11','','','56-22-77-39','','rodriguez@fis.unam.mx','','','','Nuevo director  2014- 2018 De Urquijo. BOLETIN 649, 8 nov 2014. DPLybf. Nuevo director : Ortega (2010-2014) boletin 10 noviembre 2010. Depto.  Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (782,'Dra.','Marcia Hiriart Urdanivia','56-22-56-65','56-22-56-04','Red UNAM ext. 45228','56-16-22-82 (Solicitar tono)','','mhiriart@ifc.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (102,'L.A.E.','Gilberto Escamilla Marvan (Secretario Administrativo)','56-22-55-95','56-22-55-96','','56-22-56-38','','gescami@ifisiol.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (37,'C.P.','Angel Cedillo Hernndez','56-22-56-00','56-22-56-01','','','','acedillo@ifisiol.unam.mx','','','','Ratificacin Hiriart 2013-2017, Boletin 618 , 15 oct. 2013. DPLybf. Primer periodo (2009-2013) boletin 607-14/oct/2009 . Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (749,'Dra.','Elena Centeno Garca','56-22-43-08','56-16-05-57','','55-50-66-44','','centeno@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (635,'Lic.','Ana Mara Rodrguez Simental (Secretario Administrativo)','56-22-42-95','56-22-49-07','','56-22-43-18','','simental@servidor.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (636,'Srita.','Guadalupe Chvez Villagrana','56-22-43-22','56-22-42-73','','56-22-43-22','','presup@geologia.unam.mx','','','','Segundo periodo: Centeno Garca ( 2014-2018), Boletin 366. 24 junio 2014 DPLybf. Primer periodo (2010-2014) noticia 30/06/2010. Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (653,'Dra.','Elva Guadalupe Escobar Briones','56-22-57-70','56-22-57-71','56-22-58-41','56-16-27-45','','direccion@cmarl.unam.mx','escobri@cmarl.unam.mx','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (645,'L.C.','Myrna Jossie Avila Muoz (Secretario Administrativo)','56-22-57-74','56-22-57-75','','56-16-27-09','','administracion@icmyl.unam.mx','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (646,'Lic.','Alejandra Garca Reyes','56-22-57-74','56-22-57-75','56-22-58-08','56-16-27-09','','alejandra_garcia@icmyl.unam.mx','presupuesto@icmyl.unam.mx','','Segundo periodo de Escobar (2015-2019) Gaceta 24 septiembre 2015. DPLybf. Nueva directora: Escobar  (2011-2015) Boletin 508. 04/0ct/2011 Depto. Planeacin','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (652,'Dra.','Elva Guadalupe Escobar Briones','56-22-57-70','56-22-57-71','56-22-58-41','56-16-27-45','','direccion@cmarl.unam.mx','escobri@cmarl.unam.mx','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (487,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (490,'','','','','','','','','','','','Segundo periodo de Escobar (2015-2019) Gaceta 24 septiembre 2015. DPLybf.',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (651,'Dra.','Elva Guadalupe Escobar Briones','56-22-57-70','56-22-57-71','56-22-58-41','56-16-27-45','','direccion@cmarl.unam.mx','escobri@cmarl.unam.mx','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (486,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (489,'','','','','','','','','','','','Segundo periodo Escobar (2015-2019) Gaceta 24 septiembre 2015. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (650,'Dra.','Elva Guadalupe Escobar Briones','56-22-57-70','56-22-57-71','56-22-58-41','56-16-27-45','','direccion@cmarl.unam.mx','escobri@cmarl.unam.mx','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (485,'','','','','','','','','','',NULL,'',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (488,'','','','','','','','','','','','Segundo periodo de Escobar (2015-2019) Gaceta 24 septiembre 2015. DPLybf. Nueva directora Escobar, periodo 2011-2015. Gaceta 4,369. 03/octubre/2011. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1894,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (195,'','','','','','','','','','','Gregoria es egresada de la FCPyS, en carrera de comunicacin.(INF. 2015)','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (742,'','Gregoria Bustamante Rojas','56-22-48-00, ext. 47178','','','','','gregoria@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (196,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (197,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1751,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1752,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1753,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1755,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (984,'Mtra.','Mara Dolores Zarza Arizmendi','56-55-23-32, exts. 201 y 211','56-55-07-34','','56-55-71-53, ext. 209 (Solicitar tono)','','mdz55@hotmail.com','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (733,'Mtra.','Gabriela Garza Infante','56-55-22-98','','','56-55-22-98 ext. 310','','ggarza@.eneo.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (362,'Lic.','Cristian Viviana Solares Vargas','56-55-22-98 ext. 280','','','','','alendramora41@hotmail.com','','','','Ratificacin de Zarza (2015-2019) Boletin 069. 3 de febrero 2015 DPLybf. Nueva directora: Zarza Arizmendi (2011-2015) Boletin.  01/02/2011. Depto. Planeacin',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2244,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (1614,'','','56223550','','','','','jadquis@leibniz.iimas.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (765,'Dra.','Margarita Velzquez Gutirrez','56-22-78-35, ext. 102','56-22-77-77, ext. 102','','01(777) + 31-75-981','','mavg@unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (769,'Ing.','Hctor Silva Rhoads','01(777) +329-18-30 ','01(777) +313-05-55','56-22-78-30 ','01(777) + 317-59-81','','hsilva@servidor.unam.mx','','',NULL,NULL,NULL,'');
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (409,'Lic.','Mara Claudia Snchez Garca','56-22-78-39','','','','','mcasg@correo.crim.unam.mx','','','','Ratificacin Dra. Velzquez, para segundo periodo 2015-2019. 12 nov 2015, DPLybf. Nueva directora: Velzquez 2011-2015. Boletin 20/10/2011. DPLybf',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2610,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2611,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2612,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2616,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2606,'','','','','','','','','','','','',NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2607,'Lic.','Jos Mauricio Anaya Rivas','56-23-73-00, ext. 80517','01 (443) + 689-35-00 (Morelia) ','','','','mauricio.anaya@enesmorelia.unam.mx','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2608,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2609,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2613,'','','','','','','','','','',NULL,NULL,NULL,NULL);
INSERT INTO "datospersona" ("per_id","grado","nombre","tel_1","tel_2","tel_3","fax_1","fax_2","mail_1","mail_2","horario","observaciones","per_obs","foto","funcion") VALUES (2614,'','','','','','','','',