#!/usr/bin/perl
# Prueba OpenURL a bases de datos de libros en Aleph

use CGI;
use LWP;
use LWP::Simple qw($ua get);
use LWP::Protocol;

## Tiempo maximo en segundos para que responda el URL 
$ua->timeout(50);

$query = new CGI;
$linea='';

#Archivo de entrada
system('clear');
print "\nMonitor - Verificacin de URLs\n\n";
#print "Introduce el nombre del archivo de entrada: ";
$file_entrada=$ARGV[0];
#chop($file_entrada);

#Archivo de salida
#print "\nNombre de la coleccin de urls: ";
$coleccion=$ARGV[1];
#chop($coleccion);

$fecha=`date '+%y%m%d'`;
chop($fecha);

$file_salida="monitor_"."$coleccion"."_"."$fecha".".txt";

$start = `date '+%H:%M:%S'`;
chop($start);


if ($file_entrada eq '' or $coleccion eq '')
{
    print "\nFalta indicar el nombre del archivo de entrada y de la coleccion";
    print "\n\nEjemplo: ";
    print "\n\n      perl monitorurlbatch.pl file_entrada nombre_coleccion";
    print "\n\n\n";
}
else
{


    open(ENTRADA, "< $file_entrada") ||die "No existe archivo de entrada: $file_entrada\n\n";
    open(SALIDA,"> $file_salida")||die "No existe archivo de salida: $file_salida\n\n";

    print "\nVerificando URLs....\n";

    #Definicion de variables
    $url=0;
    $fila=0;
    $fallaurl=0;

    $tipo0=0;
    $tipo1=0;
    $tipo2=0;
    $tipo3=0;

    #Valida cada biblioteca recuperada en la busqueda
    while ($linea = <ENTRADA>)
    {
       chop($linea);
       @arreglo=split('#',$linea);
       $id=$arreglo[0];
       $url=$arreglo[1];

       validaurl($url);

       #Agrupar errores
       $tipoOK = "Status OK ";
       $tipoerror1 = "Redireccionamientos ";
       $tipoerror2 = "Errores del cliente ";
       $tipoerror3 = "Errores de servidor ";

       if ($error >= 300 and $error < 400)
       {
           $tipoerror1 = "Redireccionamientos ";
           $tipo1++;
       }
       if ($error >= 400 and $error < 500)
       {
           $tipoerror2 = "Errores del cliente ";
           $tipo2++;
       }
       if ($error >= 500 and $error < 600)
       {
           $tipoerror3 = "Errores de servidor ";
           $tipo3++;
       }
    } #fin while archivo
    $end = `date '+%H:%M:%S'`;
    chop($end);

    print "\n\n**********************RESUMEN******************************\n";
    print "\nTotal de urls=\t $fila";
    print "\n$tipoOK= \t$tipo0";
    print "\n$tipoerror1= \t$tipo1";
    print "\n$tipoerror2= \t$tipo2";
    print "\n$tipoerror3= \t$tipo3";
    print "\n\nTotal de fallas= \t$fallaurl";
    print "\n";
    print "\nInicio: $start \t Fin: $end\n";
    $tiempoejecucion= "$start - $end";

    print SALIDA "\n\n##Tiempo de ejecucin: $tiempoejecucion#";

    #Cierre de archivos
    close(ENTRADA);
    close(SALIDA);


    print "\n\nFinaliz\363 la verificaci\363n de URLs del archivo $file_entrada";
    print "\nArchivo de salida: $file_salida";
    print "\nEnviando correo con archivo adjunto...";
    sendmail($file_salida);
    print "\n\nProceso finalizado....\n\n";

}






### Definicion de funciones 

# Verifica la disponibilidad del url 
sub validaurl()
{
       $HTML = LWP::UserAgent->new(ssl_opts => { verify_hostname => 1 });
       $response = $HTML->get($url);
       $HTML= $response->as_string;
       $mensaje="";

       $fila++;
       $error ="";
       $mensaje="";
       if ($response->is_success) 
       {
           $mensaje="OK"; 
           $tipo0++;
       }
       else 
       {
           $fallaurl++;
           $mensaje= $response->status_line;
           print SALIDA "\n$fallaurl#$id#$url#$mensaje";
           $error = substr($mensaje,0,3);
       }
       #print "\n$fila\t$url\t$mensaje";
       return($error);
}

# Envio de correo
sub sendmail()
{
   $mailprog = '/usr/lib/sendmail';
   $destinatario="isela\@dgb.unam.mx";
   $from="alerta\@fantiguo.cichcu.unam.mx";
   $asunto="MonitorURL - Reporte de url's fallidos";
   #-- Abrimos el programa de correo.
   open(MAIL,"|$mailprog -t");
   print MAIL "To: $destinatario\n";
   print MAIL "From: $from\n";
   print MAIL "Subject: $asunto\n\n";
   print MAIL "Url's fallidos de la coleccin $coleccion\n";
   print MAIL "Total de urls: $fila\n";
   print MAIL "Total de fallas: $fallaurl\n";
   print MAIL "Tiempo de ejecucin: $tiempoejecucion\n\n";
   print MAIL "-" x 75 . "\n\n";

   $attachment = "/var/www/cgi-bin/monitor/$file_salida";
   open(FILE, "uuencode $attachment $attachment|");
   while (<FILE> ){
      print MAIL;
   };
   close(FILE);
   close (MAIL);
}

exit;

