#!/usr/bin/perl
# Prueba OpenURL a bases de datos de libros en Aleph

use CGI;
use LWP;
use LWP::Simple qw($ua get);
use LWP::Protocol;

## Tiempo maximo en segundos para que responda el URL 
$ua->timeout(20);

$query = new CGI;
$linea='';

#Rutas
$patharchivos="/var/www/cgi-bin/monitor/archivos";
$pathreportes="/var/www/cgi-bin/monitor/reportes";


system('clear');
print "\nMonitor - Verificacion de URLs\n\n";


@ficheros;

opendir(DIR, $patharchivos) or die "El directorio $patharchivos no existe!";
while ( $file = readdir DIR ) {
    #Solo archivos con extension txt 
    if ($file =~ m/txt/)
    {
       unshift @ficheros, $file if -d "$patharchivos/$file";
       push    @ficheros, $file if -f _;
    }
}
closedir DIR;

$fecha=`date '+%y%m%d'`;
chop($fecha);
$start = `date '+%H:%M:%S'`;
chop($start);

$totarchivos=0;
foreach $coleccion (@ficheros) 
{
   $file_entrada = $coleccion;
   $coleccion =~ s/\.txt//;
   $file_salida="monitor_"."$coleccion"."_"."$fecha".".txt";

   if ($file_entrada eq '' or $coleccion eq '')
   {
       print "\nFalta indicar el nombre del archivo de entrada y de la coleccion";
       print "\n\n\n";
   }
   else
   {
       print "\n----------------------------------------------------------------------------------------------------------------------";
       print "\nColeccion: $coleccion\n";
       analiza();
       $totarchivos++;
   }
}
print "\n\nTotal de archivos analizados del directorio $patharchivos: $totarchivos\n\n";

#Definicion de funciones
#Inicia lectura de urls y creacion de archivo de salida
sub analiza()
{
    open(ENTRADA, "< $patharchivos/$file_entrada") ||die "No existe archivo de entrada: $file_entrada\n\n";
    open(SALIDA,"> $pathreportes/$file_salida")||die "No existe archivo de salida: $file_salida\n\n";

    #Definicion de variables
    $fila=0;
    $fallaurl=0;
    #$fallareal=0;

    $tipo0=0;
    $tipo1=0;
    $tipo2=0;
    $tipo3=0;

    #Valida cada biblioteca recuperada en la busqueda
    while ($linea = <ENTRADA>)
    {
       $fila++;
       chop($linea);
       @arreglo=split('#',$linea);
       $id=$arreglo[0];
       $url=$arreglo[1];

       validaurl($url);

    } #fin while archivo
    $end = `date '+%H:%M:%S'`;
    chop($end);

    print "\n\n**********************RESUMEN******************************\n";
    print "\nTotal de urls        =\t$fila";
    print "\nStatus OK            = \t$tipo0";
    print "\nRedireccionamiento   = \t$tipo1";
    print "\nErrores del cliente  = \t$tipo2";
    print "\nErrores del servidor = \t$tipo3";
    print "\n\nTotal de fallas      = \t$fallaurl";
    print "\n";
    print "\nInicio: $start \t Fin: $end\n";
    $tiempoejecucion= "$start - $end";

    print SALIDA "\n\nTiempo de ejecucion: $tiempoejecucion";

    #Cierre de archivos
    close(ENTRADA);
    close(SALIDA);


    print "\n\nFinalizo la verificacion de URLs del archivo $file_entrada";
    print "\nArchivo de salida: $file_salida";
    print "\nEnviando correo con archivo adjunto...";
    #sendmail($file_salida);
    #$cadena = "php correo.php $coleccion $fila $tipo0 $tipo1 $tipo2 $tipo3 $fallaurl $file_salida";
    #system($cadena);

    print "\n\nAnalisis de la coleccion finalizado....\n\n";

}

# Verifica la disponibilidad del url y el tipo de error 
sub validaurl()
{
       $HTML = LWP::UserAgent->new(ssl_opts => { verify_hostname => 1 });
       $response = $HTML->get($url);
       $HTML= $response->as_string;
       $mensaje="";
       $error ="";
       $mensaje="";
       if ($response->is_success) 
       {
           $mensaje="OK"; 
           $tipo0++;
       }
       else 
       {
           $fallaurl++;
           $mensaje= $response->status_line;
           chop($mensaje);
           $error = substr($mensaje,0,3);

           if ($error >= 300 and $error < 400)
           {
               $tipo1++;
           }
           if ($error >= 400 and $error < 500)
           {
               $tipo2++;
            }
            if ($error >= 500 and $error < 600)
            {
               $tipo3++;
            }
            print SALIDA "\n$fallaurl#$id#$url#$mensaje";
        }
        print "\n$fila\t$id\t$url\t$mensaje";
}

# Envio de correo
sub sendmail()
{
   $mailprog = '/usr/lib/sendmail';
   $destinatario="igarciab\@dgb.unam.mx";
   #$from="alerta\@fantiguo.cichcu.unam.mx";
   $from="rtalizer\@gmail.com";
#   $cc = "iselagb27\@gmail.com, msanchezr\@dgb.unam.mx, idiazc\@dgb.unam.mx";
$cc="iselagb27\@gmail.com";
   $asunto="MonitorURL - Reporte de fallas ($coleccion)";
   #-- Abrimos el programa de correo.
   open(MAIL,"|$mailprog -t");
   print MAIL "To: $destinatario\n";
   print MAIL "From: $from\n";
   print MAIL "cc: $cc\n";
   print MAIL "Subject: $asunto\n\n";
   print MAIL "Url's fallidos de la coleccion: $coleccion\n";
   print MAIL "\n\n                RESUMEN              ";
   print MAIL "\nTotal de urls=\t $fila\n";
   print MAIL "\nStatus OK= \t$tipo0";
   print MAIL "\nRedireccionamiento= \t$tipo1";
   print MAIL "\nErrores del cliente= \t$tipo2";
   print MAIL "\nErrores del servvidor= \t$tipo3";
   print MAIL "\nTotal de fallas= \t$fallaurl";
   print MAIL "\n\nTiempo de ejecucion $tiempoejecucion\n\n";
   print MAIL "\n\nArchivo adjunto: $file_salida\n\n";
   print MAIL "-" x 75 . "\n\n";

   $attachment = "$pathreportes/$file_salida";

   open(FILE, "uuencode $attachment $attachment|");
   while (<FILE> ){
      print MAIL;
   };
   close(FILE);
   close (MAIL);
}

exit;

