--
-- PostgreSQL database dump
--

SET client_encoding = 'LATIN1';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public schema';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: amigos; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE amigos (
    id numeric(3,0),
    pais character(15),
    institucion character varying(100),
    url character varying(200),
    indice_titulo character varying(10),
    indice_tema character varying(10),
    indice_autor character varying(10),
    indice_todo character varying(10),
    software character varying(100),
    status boolean,
    id_grupo numeric(4,0)
);


ALTER TABLE public.amigos OWNER TO postgres;

--
-- Name: amigosecoes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE amigosecoes (
    id numeric(3,0),
    tabla character(15),
    pais character(15),
    institucion character varying(100),
    url character varying(200),
    indice_titulo character varying(10),
    indice_tema character varying(10),
    indice_autor character varying(10),
    indice_todo character varying(10),
    software character varying(100),
    status boolean
);


ALTER TABLE public.amigosecoes OWNER TO postgres;

--
-- Name: demo; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE demo (
    id numeric(3,0) NOT NULL,
    id_region numeric(2,0),
    id_grupo numeric(4,0),
    siglas character varying(30),
    institucion character varying(100),
    url character varying(200),
    indice_titulo character varying(15),
    indice_tema character varying(15),
    indice_autor character varying(15),
    indice_todo character varying(15),
    software character varying(100),
    status boolean
);


ALTER TABLE public.demo OWNER TO postgres;

--
-- Name: ecoes; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE ecoes (
    id numeric(3,0),
    pais character(15),
    institucion character varying(100),
    url character varying(200),
    indice_titulo character varying(10),
    indice_tema character varying(10),
    indice_autor character varying(10),
    indice_todo character varying(10),
    software character varying(100),
    status boolean
);

CREATE TABLE bitacora_ecoes (
    ip varchar(15),
    fecha date,
    hora time,
    campo varchar(20),
    termino text,
    biblioteca text  
);

CREATE TABLE bitacora_nacional (
    ip varchar(15),
    fecha date,
    hora time,
    campo varchar(20),
    termino text,
    zona text 
);

CREATE TABLE bitacora_amigos (
    ip varchar(15),
    fecha date,
    hora time,
    campo varchar(20),
    termino text,
    biblioteca text
);



ALTER TABLE public.ecoes OWNER TO postgres;

--
-- Name: grupo; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE grupo (
    id_grupo numeric(5,0) NOT NULL,
    siglas character varying(15),
    grupo character varying(100)
);


ALTER TABLE public.grupo OWNER TO postgres;

--
-- Name: multibase; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE multibase (
    id numeric(3,0) NOT NULL,
    id_region numeric(2,0),
    id_grupo numeric(4,0),
    siglas character varying(30),
    institucion character varying(100),
    url character varying(200),
    indice_titulo character varying(15),
    indice_tema character varying(15),
    indice_autor character varying(15),
    indice_todo character varying(15),
    software character varying(100),
    status boolean
);


ALTER TABLE public.multibase OWNER TO postgres;

SET default_with_oids = false;

--
-- Name: multibase2; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE multibase2 (
    id numeric(3,0),
    id_region numeric(2,0),
    id_grupo numeric(4,0),
    siglas character varying(30),
    institucion character varying(100),
    url character varying(200),
    indice_titulo character varying(15),
    indice_tema character varying(15),
    indice_autor character varying(15),
    indice_todo character varying(15),
    software character varying(100),
    status boolean
);


ALTER TABLE public.multibase2 OWNER TO postgres;

SET default_with_oids = true;

--
-- Name: region; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE region (
    id_region numeric(2,0) NOT NULL,
    region character varying(100),
    estados character varying(200)
);


ALTER TABLE public.region OWNER TO postgres;

--
-- Name: pk_id; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY multibase
    ADD CONSTRAINT pk_id PRIMARY KEY (id);


--
-- Name: pk_idgrupo; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY grupo
    ADD CONSTRAINT pk_idgrupo PRIMARY KEY (id_grupo);


--
-- Name: pk_idregion; Type: CONSTRAINT; Schema: public; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY region
    ADD CONSTRAINT pk_idregion PRIMARY KEY (id_region);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: amigos; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE amigos FROM PUBLIC;
REVOKE ALL ON TABLE amigos FROM postgres;
GRANT ALL ON TABLE amigos TO postgres;
GRANT SELECT ON TABLE amigos TO apache;
GRANT ALL ON TABLE amigos TO isela;


--
-- Name: amigosecoes; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE amigosecoes FROM PUBLIC;
REVOKE ALL ON TABLE amigosecoes FROM postgres;
GRANT ALL ON TABLE amigosecoes TO postgres;
GRANT SELECT ON TABLE amigosecoes TO apache;
GRANT ALL ON TABLE amigosecoes TO isela;


--
-- Name: demo; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE demo FROM PUBLIC;
REVOKE ALL ON TABLE demo FROM postgres;
GRANT ALL ON TABLE demo TO postgres;
GRANT SELECT ON TABLE demo TO apache;


--
-- Name: ecoes; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE ecoes FROM PUBLIC;
REVOKE ALL ON TABLE ecoes FROM postgres;
GRANT ALL ON TABLE ecoes TO postgres;
GRANT SELECT ON TABLE ecoes TO apache;


--
-- Name: grupo; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE grupo FROM PUBLIC;
REVOKE ALL ON TABLE grupo FROM postgres;
GRANT ALL ON TABLE grupo TO postgres;
GRANT SELECT ON TABLE grupo TO apache;


--
-- Name: multibase; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE multibase FROM PUBLIC;
REVOKE ALL ON TABLE multibase FROM postgres;
GRANT ALL ON TABLE multibase TO postgres;
GRANT SELECT ON TABLE multibase TO apache;


--
-- Name: multibase2; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE multibase2 FROM PUBLIC;
REVOKE ALL ON TABLE multibase2 FROM postgres;
GRANT ALL ON TABLE multibase2 TO postgres;
GRANT SELECT ON TABLE multibase2 TO apache;


--
-- Name: region; Type: ACL; Schema: public; Owner: postgres
--

REVOKE ALL ON TABLE region FROM PUBLIC;
REVOKE ALL ON TABLE region FROM postgres;
GRANT ALL ON TABLE region TO postgres;
GRANT SELECT ON TABLE region TO apache;


--
-- PostgreSQL database dump complete
--

